/*
 * Decompiled with CFR 0.152.
 */
package dd.galveston;

import dd.hurricane.Main;
import dd.sim.Layer;
import dd.sim.MapCell;
import dd.ui.GameSupport;
import dd.ui.HexView;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;

public class GalHexView
extends HexView {
    public static final int[] ix = new int[]{18, 32, 46, 11, 25, 39, 53, 4, 18, 32, 46, 60, 11, 25, 39, 53, 18, 32, 46};
    public static final int[] iy = new int[]{3, 3, 3, 15, 15, 15, 15, 27, 27, 27, 27, 27, 39, 39, 39, 39, 51, 51, 51};
    public static boolean needToLoadIcons = true;
    public static HashMap luIcons;
    public ImageIcon[] iconArray;
    public static boolean[] showLU;
    public static boolean showOpen;
    public static boolean showFactory;
    public static boolean debug;

    public GalHexView() {
        if (needToLoadIcons) {
            luIcons = new HashMap();
            for (int i = 0; i < Main.luNames.length; ++i) {
                String s = Main.luNames[i];
                luIcons.put(s, GameSupport.getImage(s + ".png"));
            }
            luIcons.put("industrial", GameSupport.getImage("industrial.png"));
            luIcons.put("mixed", GameSupport.getImage("mixed.png"));
            luIcons.put("destroyed", GameSupport.getImage("destroyed.png"));
            luIcons.put("openspace", GameSupport.getImage("open-icon.png"));
            if (debug) {
                luIcons.put("none", GameSupport.getImage("dot.png"));
                luIcons.put("road", GameSupport.getImage("road.png"));
                luIcons.put("water", GameSupport.getImage("water.png"));
            }
            needToLoadIcons = false;
        }
        this.iconArray = new ImageIcon[19];
    }

    public int defaultCellWidth() {
        return 54;
    }

    public int defaultCellHeight() {
        return 63;
    }

    public void setCell(MapCell c) {
        super.setCell(c);
        this.setMyColor(this.getHazardColor());
    }

    public Color getHazardColor() {
        try {
            float hazard = this.myCell.getAttribute("water", this.myCell.getMap().getLayer("hazard"));
            int green = (int)(255.0 * (1.0 - ((double)hazard - 0.2) / 0.4));
            return new Color(255, green, 0, 96);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        String layerName = (String)this.myCell.getMap().getObjectAttribute("currentLayer", "landuse");
        Layer layer = this.myCell.getMap().getLayer(layerName);
        ArrayList luArray = (ArrayList)this.myCell.getObjectAttribute("luArray", layer);
        if (layer != null && luArray != null) {
            int i;
            for (i = 0; i < 19; ++i) {
                String lu = (String)luArray.get(i);
                this.iconArray[i] = this.showLU(lu) ? (ImageIcon)luIcons.get(lu) : null;
            }
            for (i = 0; i < 19; ++i) {
                if (this.iconArray[i] == null) continue;
                g.drawImage(this.iconArray[i].getImage(), this.xPosition + ix[i], this.yPosition + iy[i], null);
            }
        }
    }

    private boolean showLU(String lu) {
        if ("destroyed".equals(lu)) {
            return true;
        }
        if ("openspace".equals(lu)) {
            return showOpen;
        }
        if ("industrial".equals(lu)) {
            return showFactory;
        }
        if (debug && "none".equals(lu)) {
            return true;
        }
        if (debug && "road".equals(lu)) {
            return true;
        }
        if (debug && "water".equals(lu)) {
            return true;
        }
        for (int i = 0; i < Main.luNames.length; ++i) {
            if (!Main.luNames[i].equals(lu)) continue;
            return showLU[i];
        }
        return false;
    }

    static {
        showLU = new boolean[]{true, true, true, true};
        showOpen = true;
        showFactory = true;
        debug = false;
        fillHexes = false;
    }
}

