/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane;

import dd.hurricane.HurricaneHex;
import dd.hurricane.Main;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.SimObject;
import dd.ui.MapView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JFrame;

public class HurricaneManager {
    private static MapView view;
    private GameRoot root;
    private Random rng;
    private String summary;
    private int total;
    private boolean debug = false;
    static /* synthetic */ Class class$dd$hurricane$HurricaneHex;

    public HurricaneManager(GameRoot root, Random rng) {
        this.root = root;
        this.rng = rng;
    }

    public GameRoot getRoot() {
        return this.root;
    }

    public Random getRng() {
        return this.rng;
    }

    public String getSummary() {
        return this.summary;
    }

    public int getTotal() {
        return this.total;
    }

    public void debug(MapCell cell) {
        if (this.debug) {
            view.drawArrow(cell.getName());
            view.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void go() {
        SimObject destroyed = new SimObject(){};
        Map map = this.root.getScenario().getMap();
        Layer haz = map.getLayer("hazard");
        float windExposure = haz.getAttribute("wind", 0.5f);
        Layer lulayer = map.getLayer("landuse");
        Iterator iter = map.getCells().iterator();
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            float waterExposure = cell.getAttribute("water", haz, 0.0f);
            ArrayList luArray = (ArrayList)cell.getObjectAttribute("luArray", lulayer);
            for (int i = 0; i < luArray.size(); ++i) {
                String lu = (String)luArray.get(i);
                float wind = windExposure * haz.getAttribute(lu + "WindVulnerability", 0.0f);
                float water = waterExposure * haz.getAttribute(lu + "WaterVulnerability", 0.0f);
                if (!(wind > 0.0f && this.rng.nextFloat() < wind) && (!(water > 0.0f) || !(this.rng.nextFloat() < water))) continue;
                luArray.set(i, "destroyed");
                destroyed.incrementAttribute(lu);
                ++this.total;
            }
        }
        this.summary = "<ul>\n";
        for (int i = 0; i < 4; ++i) {
            String lu = Main.luNames[i];
            this.summary = this.summary + "<li>" + (int)destroyed.getAttribute(lu, 0.0f) + " " + lu + "</li>\n";
        }
        this.summary = this.summary + "</ul>\n";
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Destruction Debug");
        GameRoot root = new GameRoot();
        Map m = root.getScenario().getMap();
        Random rng = new Random(2222L);
        HurricaneHex.debug = true;
        view = new MapView(m, class$dd$hurricane$HurricaneHex == null ? (class$dd$hurricane$HurricaneHex = HurricaneManager.class$("dd.hurricane.HurricaneHex")) : class$dd$hurricane$HurricaneHex);
        f.getContentPane().add(view);
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        HurricaneManager hm = new HurricaneManager(root, rng);
        hm.go();
        view.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

