/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane;

import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class LanduseManager {
    public static void rebuild(GameRoot root, String oldLayer) {
        Collection sites = root.getScenario().getMap().getCells();
        LanduseManager.rebuild(root, oldLayer, sites);
    }

    public static void rebuild(GameRoot root, String oldLayer, Collection sites) {
        Map map = root.getScenario().getMap();
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            ArrayList lu = (ArrayList)map.getObjectAttribute("landuse", cell, "luArray");
            ArrayList oldLu = (ArrayList)map.getObjectAttribute(oldLayer, cell, "luArray");
            for (int i = 0; i < lu.size(); ++i) {
                if (!"destroyed".equals(lu.get(i))) continue;
                lu.set(i, oldLu.get(i));
            }
        }
    }

    public static void rebuild(GameRoot root, Random rng, String oldLayer, double prob) {
        Collection sites = root.getScenario().getMap().getCells();
        Map map = root.getScenario().getMap();
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            ArrayList lu = (ArrayList)map.getObjectAttribute("landuse", cell, "luArray");
            ArrayList oldLu = (ArrayList)map.getObjectAttribute(oldLayer, cell, "luArray");
            for (int i = 0; i < lu.size(); ++i) {
                if (!"destroyed".equals(lu.get(i)) || !((double)rng.nextFloat() < prob)) continue;
                lu.set(i, oldLu.get(i));
            }
        }
    }

    public static int convert(GameRoot root, Random rng, String luFrom, String luTo, double prob) {
        Collection sites = root.getScenario().getMap().getCells();
        return LanduseManager.convert(root, rng, sites, luFrom, luTo, prob);
    }

    public static int convert(GameRoot root, Random rng, Collection sites, String luFrom, String luTo, double prob) {
        int count = 0;
        Map map = root.getScenario().getMap();
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            ArrayList lu = (ArrayList)map.getObjectAttribute("landuse", cell, "luArray");
            for (int i = 0; i < lu.size(); ++i) {
                if (!luFrom.equals(lu.get(i)) || !((double)rng.nextFloat() < prob)) continue;
                lu.set(i, luTo);
                ++count;
            }
        }
        return count;
    }

    public static boolean isFull(Map map, MapCell cell, String lu) {
        ArrayList luArray = (ArrayList)map.getObjectAttribute("landuse", cell, "luArray");
        Layer layer = map.getLayer("landuse");
        boolean mixed = cell.isSet("mixedUse", layer);
        if (mixed) {
            for (int i = 0; i < luArray.size(); ++i) {
                if ("mixed".equals(luArray.get(i)) || lu.equals(luArray.get(i))) continue;
                return false;
            }
            return true;
        }
        return !luArray.contains("none");
    }
}

