/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane;

import dd.net.TurnClient;
import dd.net.TurnServer;
import dd.net.Venue;
import dd.sim.Briefing;
import dd.sim.GameRoot;
import dd.sim.Map;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.ui.BriefingPanel;
import dd.ui.ChatPanel;
import dd.ui.ChooseGame;
import dd.ui.DLUGUIHelper;
import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import dd.ui.HelpPanel;
import dd.ui.InfoPanel;
import dd.ui.MapView;
import dd.ui.ProposalList;
import dd.ui.ProposalView;
import dd.ui.ProposalVisualizer;
import dd.ui.StatusBar;
import dd.ui.VotePanel;
import dd.util.DLUGUI;
import dd.util.Logger;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Main
extends GameSupport
implements DLUGUI,
GUIEvents {
    protected static HashMap imageCache;
    public static final boolean useServiceDiscovery = true;
    protected int myNumber;
    protected int requestedRole = 1;
    protected TurnClient netClient;
    protected GameRoot gameRoot = new GameRoot();
    protected HashMap propViz;
    public HashSet showViz = new HashSet();
    protected ChooseGame chooseGame;
    protected JFrame mainWindow;
    protected JFrame pauseWindow;
    protected BriefingPanel briefingPanel;
    protected JTabbedPane controlPanel;
    protected JPanel main;
    protected JPanel swap;
    protected Box notifyBox;
    protected JLabel pauseMessage;
    protected CardLayout controlManager;
    protected boolean notifying = false;
    protected String state = "pause";
    protected HelpPanel helpPanel;
    protected MapView mapView;
    protected ProposalList proposalList;
    protected JScrollPane proposalListPane;
    protected ProposalView currentProposalView;
    protected StatusBar statusBar;
    protected Proposal pendingAmendment;
    protected JLabel waitMessage;
    protected ChatPanel chatPanel;
    protected InfoPanel infoPanel;
    protected Box buttons;
    protected JButton opinionYesButton;
    protected JButton opinionNoButton;
    protected JButton opinionMaybeButton;
    protected JButton opinionCancelButton;
    protected JButton amendButton;
    protected JButton retractButton;
    protected VotePanel votePanel;
    protected boolean gameRunning = true;
    protected Proposal selectedProposal;
    protected static final boolean singlePlayerMode = false;
    protected static JFrame splash;
    public static final String[] luNames;
    public static final String[] metrics;
    public static final String[] metricsColors;
    public static final String[] roleNames;
    public static final Color[] luColors;
    public static final String[] luColorNames;
    public static final Color hazardYellow;
    static /* synthetic */ Class class$dd$hurricane$HurricaneHex;

    protected static void cacheDlugImages() {
        String[] preload = new String[]{"background.png", "bridge.png", "cancel.png", "condo.png", "destroyed.png", "dot.png", "education-extra.png", "education.png", "ferry.png", "highway-improvement.png", "highway-ferry.png", "hotel.png", "house.png", "industrial.png", "labels.png", "maybe.png", "mixed.png", "no.png", "no-septic.png", "openspace-both.png", "openspace-coast.png", "openspace-wetland.png", "retro-both.png", "retro-commercial.png", "retrofit.png", "retro-grants.png", "retro-hotel.png", "retro-residential.png", "retro-water.png", "retro-wind.png", "store.png", "tdr.png", "ws-facilities.png", "ws-liberal.png", "ws-restrictive.png", "ws-statusquo.png", "yes.png"};
        Main.cacheImages(preload);
    }

    private void removeButtons() {
        this.buttons.removeAll();
    }

    private void createNegotiationPhaseButtons() {
        this.removeButtons();
        this.opinionYesButton = new JButton(Main.getImage("yes.png"));
        this.opinionYesButton.setToolTipText("Support this proposal");
        this.opinionNoButton = new JButton(Main.getImage("no.png"));
        this.opinionNoButton.setToolTipText("Oppose this proposal");
        this.opinionMaybeButton = new JButton(Main.getImage("maybe.png"));
        this.opinionMaybeButton.setToolTipText("Support this proposal if...");
        this.opinionCancelButton = new JButton(Main.getImage("cancel.png"));
        this.opinionCancelButton.setToolTipText("No opinion");
        this.amendButton = new JButton("Propose");
        this.retractButton = new JButton("Retract");
        this.opinionYesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.indicateOpinion("I support this proposal");
            }
        });
        this.opinionNoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.indicateOpinion("I do not support this proposal");
            }
        });
        this.opinionMaybeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String maybe = JOptionPane.showInputDialog(Main.this.mainWindow, (Object)"Conditional support:\n\"I will support this proposal if...\"");
                if (maybe != null) {
                    maybe = "I will support this proposal if... " + maybe;
                    Main.this.indicateOpinion(maybe);
                }
            }
        });
        this.opinionCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.indicateOpinion("None");
            }
        });
        this.amendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.doAmendButton();
            }
        });
        this.retractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.doRetractButton();
            }
        });
        this.buttons.add(this.amendButton);
        this.buttons.add(this.retractButton);
        this.buttons.add(Box.createHorizontalGlue());
        this.buttons.add(this.opinionYesButton);
        this.buttons.add(this.opinionMaybeButton);
        this.buttons.add(this.opinionNoButton);
        this.buttons.add(this.opinionCancelButton);
        this.buttons.revalidate();
        this.buttons.getParent().repaint();
    }

    public void doAmendButton() {
        Proposal p2 = (Proposal)this.proposalList.getSelectedProposal().duplicate();
        this.currentProposalView.setProposal(p2);
        this.currentProposalView.makeEditView();
        this.pendingAmendment = p2;
        this.mapView.setCurrentVisualizer(ProposalVisualizer.visualize(p2));
        this.amendButton.setEnabled(false);
        this.retractButton.setEnabled(false);
    }

    public void doRetractButton() {
        this.netClient.withdraw(this.proposalList.getSelectedProposal().getProposalID());
        this.mapView.setCurrentVisualizer(null);
        this.amendButton.setEnabled(false);
        this.retractButton.setEnabled(false);
    }

    public void callForVote(String proposalID) {
        this.votePanel.caller();
        int i = this.controlPanel.indexOfTab("Vote");
        this.controlPanel.setBackgroundAt(i, hazardYellow);
        this.netClient.callForVote(proposalID);
    }

    public void doEditButton() {
        this.currentProposalView.makeEditView();
    }

    public String askUserName() {
        String str = JOptionPane.showInputDialog(this.chatPanel, (Object)"<html>Welcome to Disaster Dynamics!<br>What is your name?<br>(max 15 chars)</html>");
        if (str == null || "".equals(str)) {
            System.exit(0);
        }
        str = str.replace('[', ' ');
        if ((str = str.replace(']', ' ')).length() > 15) {
            str = str.substring(0, 15);
        }
        if (this.chatPanel != null) {
            this.chatPanel.setUserName(str);
        }
        return str;
    }

    public void makeUI() {
        JPanel proposalTab = new JPanel(new BorderLayout());
        this.mapView = new MapView(new Map(10, 10), class$dd$hurricane$HurricaneHex == null ? (class$dd$hurricane$HurricaneHex = Main.class$("dd.hurricane.HurricaneHex")) : class$dd$hurricane$HurricaneHex);
        this.chatPanel = new ChatPanel("**UNSET**", this.netClient);
        this.chatPanel.setGUIEventTarget(this);
        this.netClient.setChatClient(this.chatPanel);
        this.controlPanel = new JTabbedPane();
        this.controlPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane p = (JTabbedPane)e.getSource();
                if (p.getSelectedIndex() == 2) {
                    p.setBackgroundAt(2, null);
                }
            }
        });
        this.buttons = Box.createHorizontalBox();
        proposalTab.add((Component)this.buttons, "North");
        this.proposalList = new ProposalList(this);
        this.proposalListPane = new JScrollPane(this.proposalList);
        this.proposalListPane.setPreferredSize(new Dimension(350, 375));
        this.proposalListPane.setMinimumSize(new Dimension(350, 375));
        proposalTab.add((Component)this.proposalListPane, "Center");
        Box south = Box.createVerticalBox();
        this.currentProposalView = new ProposalView(this);
        south.add(this.currentProposalView);
        proposalTab.add((Component)south, "South");
        this.infoPanel = new InfoPanel(this);
        this.votePanel = new VotePanel(this);
        this.helpPanel = new HelpPanel(this);
        this.controlPanel.addTab("Proposals", proposalTab);
        this.controlPanel.addTab("Vote", this.votePanel);
        this.controlPanel.addTab("Chat", this.chatPanel);
        this.controlPanel.addTab("Info", this.infoPanel);
        this.controlPanel.addTab("Help", this.helpPanel);
        this.main = new JPanel(new BorderLayout());
        this.main.add((Component)this.mapView, "West");
        JPanel controls = new JPanel(new BorderLayout());
        controls.add((Component)this.controlPanel, "Center");
        this.statusBar = new StatusBar(this);
        controls.add((Component)this.statusBar, "South");
        JPanel pausePanel = new JPanel();
        this.pauseMessage = new JLabel("Paused...");
        pausePanel.add(this.pauseMessage);
        JPanel notify = new JPanel(new BorderLayout());
        JButton okButton = new JButton("OK");
        this.notifyBox = Box.createVerticalBox();
        Box hBox = Box.createHorizontalBox();
        Box vBox = Box.createVerticalBox();
        hBox.add(Box.createHorizontalGlue());
        hBox.add(vBox);
        hBox.add(Box.createHorizontalGlue());
        vBox.add(Box.createVerticalGlue());
        vBox.add(this.notifyBox);
        vBox.add(Box.createVerticalStrut(10));
        vBox.add(okButton);
        vBox.add(Box.createVerticalGlue());
        notify.add((Component)hBox, "Center");
        this.briefingPanel = new BriefingPanel(this, this.mapView);
        this.controlManager = new CardLayout();
        this.swap = new JPanel(this.controlManager);
        this.swap.add((Component)notify, "notify");
        this.swap.add((Component)controls, "negotiate");
        this.swap.add((Component)pausePanel, "pause");
        this.swap.add((Component)this.briefingPanel, "briefing");
        this.controlManager.show(this.swap, "negotiate");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Main.this.notifying = false;
                Main.this.setState();
            }
        });
        this.main.add((Component)this.swap, "Center");
        this.mainWindow = new JFrame("DD");
        this.mainWindow.setDefaultCloseOperation(3);
        this.mainWindow.setSize(1024, 700);
        this.mainWindow.getContentPane().add(this.main);
        ((JComponent)this.mainWindow.getContentPane()).setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, Color.LIGHT_GRAY));
        Main.centerWindow(this.mainWindow);
    }

    void setState(String newState) {
        this.state = newState;
        this.setState();
    }

    void setState() {
        if (this.notifying) {
            return;
        }
        this.controlManager.show(this.swap, this.state);
        this.pauseWindow.setVisible(false);
        this.mainWindow.setVisible(true);
    }

    public void enableUI() {
    }

    public void disableUI() {
    }

    public void startBriefing(Briefing b) {
        this.briefingPanel.setBriefing(b);
        this.setState("briefing");
    }

    public void briefingEnded() {
        this.notifying = false;
        this.netClient.endBriefing();
    }

    public void pauseUI(String message) {
        this.pauseMessage.setText(message);
        this.setState("pause");
    }

    public void unpauseUI() {
        this.setState("negotiate");
    }

    public void lostServer() {
        Logger.getDefaultLog().log("Lost connection to server.  Exiting");
        if (this.gameRunning) {
            System.exit(1);
        }
    }

    public Color getColor(Proposal p) {
        if (p == null) {
            return Color.black;
        }
        return this.getColor(this.gameRoot.player(p.getOwnerID()));
    }

    public Color getColor(Player p) {
        if (p == null || p.equals(Player.nobody())) {
            return Color.black;
        }
        return this.getColor(p.getTurnNumber());
    }

    public Color getColor(int turnNumber) {
        if (turnNumber < 1 || turnNumber > luColors.length) {
            return Color.black;
        }
        return luColors[turnNumber - 1];
    }

    public String getColorName(int turnNumber) {
        if (turnNumber < 1 || turnNumber > luColorNames.length) {
            return "**NO COLOR**";
        }
        return luColorNames[turnNumber - 1];
    }

    public static Color getColor(String landuse) {
        for (int i = 0; i < luNames.length; ++i) {
            if (!luNames[i].equals(landuse)) continue;
            return luColors[i];
        }
        return new Color(0, 0, 0, 0);
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void setSelectedProposal(Proposal proposal) {
        this.currentProposalView.setProposal(proposal);
        this.currentProposalView.makeInterface();
        if (this.selectedProposal == proposal) {
            return;
        }
        this.selectedProposal = proposal;
        this.proposalList.selectProposal(proposal);
        this.setButtonStates();
        if (proposal == null) {
            return;
        }
        if (proposal.getStatus().equals("Played")) {
            this.mapView.setCurrentVisualizer(ProposalVisualizer.visualize(proposal));
        } else {
            this.mapView.setCurrentVisualizer(null);
        }
    }

    public void setHelpContent(String location) {
        this.helpPanel.setPage(location);
        this.controlPanel.setSelectedIndex(this.controlPanel.indexOfTab("Help"));
    }

    public void proposalDoubleClicked(Proposal p) {
        if ("negotiate".equals(this.gameRoot.getPhase())) {
            // empty if block
        }
    }

    public void plistRefreshed() {
        this.setButtonStates();
    }

    public void editingComplete(Proposal p) {
        if (!this.pendingAmendment.equals(p)) {
            p.fatal("editingComplete: Something is terribly wrong");
        }
        if (this.pendingAmendment != null) {
            this.pendingAmendment.setOwnerID(this.getCurrentPlayer().getPlayerID());
            this.netClient.amend(this.pendingAmendment);
            this.pendingAmendment = null;
            this.amendButton.setEnabled(false);
        }
    }

    public Player getCurrentPlayer() {
        return this.getPlayer(this.myNumber);
    }

    public Player getPlayer(int turnNumber) {
        List s = SimObject.filter(this.gameRoot.getPlayers().values(), "turnNumber", turnNumber);
        if (s.size() > 1) {
            throw new IllegalStateException("player registry returned " + s.size() + " players with turnNumber of " + turnNumber);
        }
        if (s.size() < 1) {
            return Player.nobody();
        }
        return (Player)s.iterator().next();
    }

    public GameRoot getRoot() {
        return this.gameRoot;
    }

    public void gotUserMessage(Color color) {
        int i = this.controlPanel.indexOfTab("Chat");
        if (this.controlPanel.getSelectedIndex() == i) {
            this.controlPanel.setBackgroundAt(i, null);
        } else {
            this.controlPanel.setBackgroundAt(i, color);
        }
    }

    public void setNetClient(TurnClient client) {
        this.netClient = client;
    }

    public void setNumber(String turnNumber) {
        this.myNumber = Integer.parseInt(turnNumber);
        ((JComponent)this.mainWindow.getContentPane()).setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, this.getColor(this.myNumber)));
    }

    public void availableGames(String[] gameList) {
        if (this.chooseGame == null) {
            this.chooseGame = new ChooseGame(this, gameList);
        } else {
            this.chooseGame.setGameList(gameList);
        }
    }

    public void refreshGameList() {
        this.netClient.listGames();
    }

    public void rejoinGame(String name, int requestedPlayer) {
        this.netClient.rejoinGame(name, requestedPlayer);
    }

    public void joinGame(String name, int requestedPlayer) {
        this.requestedRole = requestedPlayer;
        this.netClient.joinGame(name);
    }

    public void createNewGame(String name) {
        this.netClient.createNewGame(name);
    }

    public void joinedGame() {
        if (this.chooseGame != null) {
            this.chooseGame.close();
        }
        this.chooseGame = null;
        this.netClient.joinGame(this.askUserName(), this.requestedRole);
    }

    public void beginSetupPhase() {
        this.pauseUI("Setting up next turn...");
        this.controlPanel.setSelectedIndex(this.controlPanel.indexOfTab("Proposals"));
        this.helpPanel.doHomeButton();
    }

    public void setRoot(GameRoot root) {
        ChangeHandler c = new ChangeHandler();
        if (this.chooseGame != null) {
            this.chooseGame.close();
        }
        this.chooseGame = null;
        this.gameRoot = root;
        this.mainWindow.setTitle("DD - " + root.getGameName() + " - Player " + this.myNumber);
        this.gameRoot.getProposalRegistry().addPropertyChangeListener(c);
        this.mapView.setMap(this.gameRoot.getScenario().getMap());
        this.chatPanel.updateUsers();
        this.proposalList.rootChanged();
        this.infoPanel.rootChanged();
        this.statusBar.rootChanged();
        this.votePanel.rootChanged();
        c.propertyChange(new PropertyChangeEvent(c, "dummy", "a", "b"));
    }

    public void beginNegotiationPhase() {
        this.setState("negotiate");
        this.mapView.tocUpdated();
        this.pendingAmendment = null;
        this.controlPanel.setBackgroundAt(this.controlPanel.indexOfTab("Vote"), null);
        this.createNegotiationPhaseButtons();
        this.setButtonStates();
        this.votePanel.updateResponse();
        this.votePanel.listChanged(this.gameRoot.getPlayedProposals().iterator());
    }

    public void indicateOpinion(String val) {
        this.netClient.opinion(this.proposalList.getSelectedProposal().getProposalID(), val);
    }

    public void doneNotify(Player p) {
        this.votePanel.doneNotify(p);
    }

    public void beginVotePhase() {
        this.setButtonStates();
    }

    public void prepareForVotingOn(Proposal proposal) {
        this.pendingAmendment = null;
        this.setSelectedProposal(proposal);
        this.votePanel.prepareForVotingOn(proposal);
    }

    public void startVote() {
        int i = this.controlPanel.indexOfTab("Vote");
        this.controlPanel.setBackgroundAt(i, hazardYellow);
    }

    public void startVotingTimer() {
        if (this.votePanel == null) {
            this.gameRoot.error("Can't start timer - No proposal to vote on");
            return;
        }
        this.votePanel.startVotingTimer();
    }

    public void votingTimerExpired() {
        this.netClient.votingTimerExpired();
    }

    public void castVote(Proposal p, int vote) {
        this.netClient.vote(vote);
    }

    public void gameMessage(String message) {
        this.infoPanel.getMessagePanel().addMessage(message);
    }

    public void errorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "DD Error", 2);
    }

    public void notifyUser(String message) {
        if (this.notifying) {
            this.notifyBox.add(Box.createVerticalStrut(5));
            this.notifyBox.add(new JLabel(message));
            this.controlManager.show(this.swap, "notify");
        } else {
            this.notifying = true;
            this.notifyBox.removeAll();
            Box hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalGlue());
            this.notifyBox.add(new JLabel(message));
            hBox.add(Box.createHorizontalGlue());
            this.notifyBox.add(hBox);
            this.controlManager.show(this.swap, "notify");
        }
    }

    public void endVote() {
        this.pauseUI("Completing voting phase");
        this.controlPanel.setComponentAt(this.controlPanel.indexOfTab("Vote"), this.votePanel);
        this.votePanel.prepareForVotingOn(null);
        this.votePanel.listChanged(this.gameRoot.getPlayedProposals().iterator());
        this.controlPanel.revalidate();
        this.controlPanel.setSelectedIndex(this.controlPanel.indexOfTab("Info"));
        this.setSelectedProposal(null);
    }

    public void gameEnded() {
        this.gameRunning = false;
        this.briefingPanel.gameOver();
    }

    public HashMap getPropViz() {
        return this.propViz;
    }

    public void setButtonStates() {
        Proposal proposal = this.proposalList.getSelectedProposal();
        if (this.opinionYesButton == null) {
            return;
        }
        if (proposal == null || !this.getRoot().getPhase().equals("negotiate") || !proposal.isActive()) {
            this.opinionYesButton.setEnabled(false);
            this.opinionNoButton.setEnabled(false);
            this.opinionMaybeButton.setEnabled(false);
            this.opinionCancelButton.setEnabled(false);
            this.amendButton.setEnabled(false);
            this.retractButton.setEnabled(false);
            return;
        }
        this.opinionYesButton.setEnabled(true);
        this.opinionNoButton.setEnabled(true);
        this.opinionMaybeButton.setEnabled(true);
        if ("None".equals(proposal.getPlayerOpinion(this.getCurrentPlayer(), "None"))) {
            this.opinionCancelButton.setEnabled(false);
        } else {
            this.opinionCancelButton.setEnabled(true);
        }
        this.retractButton.setEnabled(false);
        if ("Played".equals(proposal.getStatus())) {
            boolean iOwn = proposal.ownedBy(this.getCurrentPlayer());
            if (iOwn) {
                this.amendButton.setText("Amend");
                if (proposal.getConfigParameters().isEmpty()) {
                    this.amendButton.setEnabled(false);
                } else {
                    this.amendButton.setEnabled(true);
                }
                this.retractButton.setEnabled(true);
            } else {
                this.amendButton.setText("Propose");
                this.amendButton.setEnabled(false);
            }
        } else if ("New".equals(proposal.getStatus())) {
            this.amendButton.setText("Propose");
            this.amendButton.setEnabled(true);
            Iterator iter = this.getRoot().getProposals().iterator();
            while (iter.hasNext()) {
                Proposal p = (Proposal)iter.next();
                if (p.getFamily().equals(proposal.getFamily()) && "Played".equals(p.getStatus())) {
                    this.amendButton.setEnabled(false);
                } else {
                    if (!p.ownedBy(this.getCurrentPlayer())) continue;
                    if ("Played".equals(p.getStatus())) {
                        this.amendButton.setEnabled(false);
                    } else {
                        if (!p.getFamily().equals(proposal.getFamily()) || !"Failed".equals(p.getStatus())) continue;
                        this.amendButton.setEnabled(false);
                    }
                }
                break;
            }
        } else {
            this.amendButton.setText("Propose");
            this.amendButton.setEnabled(false);
        }
    }

    void setupMessage(String message) {
        this.waitMessage.setText(message);
        this.pauseWindow.pack();
        Main.centerWindow(this.pauseWindow);
        this.mainWindow.setVisible(false);
        this.pauseWindow.setVisible(true);
    }

    public Main() {
        this.propViz = new HashMap();
        this.amendButton = new JButton("Amend");
        this.retractButton = new JButton("Retract");
        JPanel pause = new JPanel(new BorderLayout());
        pause.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Box pauseContents = Box.createVerticalBox();
        this.waitMessage = new JLabel();
        pauseContents.add(this.waitMessage);
        pause.add(pauseContents);
        this.pauseWindow = new JFrame("DD Setup");
        this.pauseWindow.setDefaultCloseOperation(3);
        this.pauseWindow.getContentPane().add(pause);
    }

    public static void splash() {
        splash = new JFrame("Disaster Dynamics");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    splash.getContentPane().add(new JLabel(GameSupport.createImageIcon("dd-logo.png")));
                    splash.pack();
                    GameSupport.centerWindow(splash);
                    splash.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        TurnClient tc = null;
        Main me = new Main();
        boolean startedOwnServer = false;
        String serverName = null;
        Main.splash();
        if (args.length != 1) {
            if (serverName == null) {
                List venues = TurnClient.discoverVenues();
                if (venues.size() == 0) {
                    serverName = null;
                } else {
                    int i;
                    Object[] venueNames = new String[venues.size()];
                    for (i = 0; i < venues.size(); ++i) {
                        venueNames[i] = ((Venue)venues.get(i)).getName();
                    }
                    serverName = (String)JOptionPane.showInputDialog(null, "Choose a venue:", "DD Venue Chooser", 1, null, venueNames, venueNames[0]);
                    for (i = 0; i < venues.size(); ++i) {
                        if (!((String)venueNames[i]).equals(serverName)) continue;
                        serverName = ((Venue)venues.get(i)).getAddress();
                    }
                }
            }
        } else {
            serverName = args[0];
        }
        if (serverName == null) {
            TurnServer.startServer(false);
            startedOwnServer = true;
            serverName = "127.0.0.1";
        }
        try {
            Main.cacheDlugImages();
            tc = new TurnClient(me, serverName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        splash.setVisible(false);
        tc.setUI(new DLUGUIHelper(me));
        me.setNetClient(tc);
        me.makeUI();
        if (startedOwnServer) {
            me.netClient.createNewGame("Game 1");
            me.setupMessage("Waiting for other players...");
        } else {
            me.setupMessage("Waiting for other players...");
            me.netClient.listGames();
        }
        try {
            while (me.netClient.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!me.gameRunning) {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        roleNames = new String[4];
        Main.roleNames[0] = "hotel manager";
        Main.roleNames[1] = "local resident";
        Main.roleNames[2] = "local shopkeeper";
        Main.roleNames[3] = "vacation resident";
        luNames = new String[4];
        Main.luNames[0] = "hotel";
        Main.luNames[1] = "house";
        Main.luNames[2] = "store";
        Main.luNames[3] = "condo";
        metrics = new String[6];
        Main.metrics[0] = "hotel";
        Main.metrics[1] = "house";
        Main.metrics[2] = "store";
        Main.metrics[3] = "condo";
        Main.metrics[4] = "ecology";
        Main.metrics[5] = "hazard";
        luColors = new Color[4];
        Main.luColors[0] = new Color(255, 30, 30);
        Main.luColors[1] = new Color(0, 180, 0);
        Main.luColors[2] = new Color(0, 128, 255);
        Main.luColors[3] = new Color(186, 16, 240);
        luColorNames = new String[]{"Red", "Green", "Blue", "Violet"};
        metricsColors = new String[6];
        Main.metricsColors[0] = "#ff1e1e";
        Main.metricsColors[1] = "#00b400";
        Main.metricsColors[2] = "#0080ff";
        Main.metricsColors[3] = "#ba10f0";
        Main.metricsColors[4] = "#669900";
        Main.metricsColors[5] = "#cc6600";
        hazardYellow = new Color(255, 230, 20);
    }

    class ChangeHandler
    implements PropertyChangeListener {
        ChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("registryElementChanged".equals(e.getPropertyName())) {
                Proposal p;
                if ("proposalStatus".equals(e.getNewValue()) && "Withdrawn".equals((p = (Proposal)e.getOldValue()).getStatus())) {
                    Main.this.votePanel.listChanged(Main.this.gameRoot.getPlayedProposals().iterator());
                }
                return;
            }
            Main.this.mapView.clearVisualizers();
            Main.this.votePanel.listChanged(Main.this.gameRoot.getPlayedProposals().iterator());
            Main.this.controlPanel.revalidate();
            Iterator iter = Main.this.gameRoot.getPassedProposals().iterator();
            while (iter.hasNext()) {
                Proposal p = (Proposal)iter.next();
                if (Main.this.propViz.containsKey(p.getProposalID())) {
                    if (p.getFamily().startsWith("EndTurn")) continue;
                    Main.this.mapView.add((ProposalVisualizer)Main.this.propViz.get(p.getProposalID()));
                    continue;
                }
                Main.this.showViz.add(p.getProposalID());
                ProposalVisualizer pv = ProposalVisualizer.visualize(p, Main.this.showViz);
                Main.this.propViz.put(p.getProposalID(), pv);
                Main.this.mapView.add(pv);
            }
            Main.this.mapView.makeTableOfContents();
        }
    }
}

