/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane;

import dd.hurricane.Main;
import dd.net.ObserverClient;
import dd.net.TurnClient;
import dd.net.Venue;
import dd.ui.ChooseGameToObserve;
import dd.ui.DLUGUIHelper;
import java.util.List;
import javax.swing.JOptionPane;

public class Observer
extends Main {
    public void availableGames(String[] gameList) {
        if (this.chooseGame == null) {
            this.chooseGame = new ChooseGameToObserve(this, gameList);
        } else {
            this.chooseGame.setGameList(gameList);
        }
    }

    public void rejoinGame(String name, int requestedPlayer) {
        this.netClient.rejoinGame(name, requestedPlayer);
    }

    public void joinGame(String name, int requestedPlayer) {
        this.netClient.joinGame(name);
    }

    public void joinedGame() {
        if (this.chooseGame != null) {
            this.chooseGame.close();
        }
        this.chooseGame = null;
        this.netClient.rejoinGame(this.askUserName(), 0);
    }

    public void callForVote(String proposalID) {
    }

    public void startVotingTimer() {
    }

    public void setButtonStates() {
        this.opinionYesButton.setEnabled(false);
        this.opinionNoButton.setEnabled(false);
        this.opinionMaybeButton.setEnabled(false);
        this.opinionCancelButton.setEnabled(false);
        this.amendButton.setEnabled(false);
        this.retractButton.setEnabled(false);
    }

    public void plistRefreshed() {
    }

    public static void main(String[] args) {
        ObserverClient tc = null;
        Observer me = new Observer();
        String serverName = null;
        Observer.splash();
        if (args.length != 1) {
            if (serverName == null) {
                List venues = TurnClient.discoverVenues();
                if (venues.size() == 0) {
                    serverName = null;
                } else {
                    int i;
                    Object[] venueNames = new String[venues.size()];
                    for (i = 0; i < venues.size(); ++i) {
                        venueNames[i] = ((Venue)venues.get(i)).getName();
                    }
                    serverName = (String)JOptionPane.showInputDialog(null, "Choose a venue:", "Choose Venue", 1, null, venueNames, venueNames[0]);
                    for (i = 0; i < venues.size(); ++i) {
                        if (!((String)venueNames[i]).equals(serverName)) continue;
                        serverName = ((Venue)venues.get(i)).getAddress();
                    }
                }
            }
        } else {
            serverName = args[0];
        }
        if (serverName == null) {
            System.out.println("No running games available to observe.  Exiting.");
            System.exit(0);
        }
        try {
            Observer.cacheDlugImages();
            tc = new ObserverClient(me, serverName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        splash.setVisible(false);
        tc.setUI(new DLUGUIHelper(me));
        me.setNetClient(tc);
        me.makeUI();
        me.pauseUI("Waiting for other players...");
        me.netClient.listGames();
        try {
            while (me.netClient.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

