/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane;

import dd.hurricane.HurricaneManager;
import dd.hurricane.LanduseManager;
import dd.hurricane.Main;
import dd.hurricane.proposals.turn1.OpenSpace;
import dd.sim.Briefing;
import dd.sim.CostTable;
import dd.sim.GameRoot;
import dd.sim.GrowthManager;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.util.Logger;
import dd.util.StringUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Random;

public class Scenario
extends SimObject {
    private Briefing debrief = new Briefing();
    static /* synthetic */ Class class$dd$hurricane$Scenario;

    public Scenario() {
        this.setAttribute("name", "Hurricane Landfall");
        this.loadMap("coast.map");
        this.setAttribute("turn", 0.0f);
        this.setAttribute("econBonus", 0.0f);
        this.setAttribute("socialBonus", 0.0f);
        this.setBudget(0.0f, 0.0f);
        this.setAttribute("proposalNames", new ArrayList());
        this.setAttribute("numTurns", 3.0f);
    }

    public void loadMap(String fileName) {
        String path = "/resources/dlug/" + fileName;
        InputStream inStream = this.getClass().getResourceAsStream(path);
        if (inStream != null) {
            Map map = (Map)Map.readFromXML(new InputStreamReader(inStream));
            map.createLayer("proposals").setAttribute("passedProposals", new ArrayList());
            this.setMap(map);
        }
    }

    public String getIntro() {
        return (String)this.getObjectAttribute("intro");
    }

    public Briefing nextTurn(GameRoot root, Random rng) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        format.applyPattern("+0.00;-0,00");
        Briefing briefing = new Briefing();
        briefing.setAttribute("turn", this.getTurn());
        briefing.setAttribute("econExtra", this.getCurrentEconBudget());
        briefing.setAttribute("socialExtra", this.getCurrentSocialBudget());
        String[] metrics = Main.metrics;
        for (int i = 0; i < metrics.length; ++i) {
            briefing.setAttribute(metrics[i], root.getScore(metrics[i]));
        }
        String text = root.getTurnSummary();
        this.incrementAttribute("turn");
        String path = "/resources/dlug/briefings/turn" + this.getTurn() + "/";
        Layer proposalLayer = this.getMap().getLayer("proposals");
        Layer landuseLayer = this.getMap().getLayer("landuse");
        root.nextTurn();
        switch (this.getTurn()) {
            case 1: {
                this.setBudget(11.0f, 9.0f);
                this.checkpointScores(root);
                this.getMap().copyLayer("landuse", "landuseTurn1");
                text = StringUtils.readFile(path + "setting.html");
                briefing.addPage(text, "landuseTurn1");
                text = StringUtils.readFile(path + "roles.html");
                briefing.addPage(text, "landuseTurn1");
                text = StringUtils.readFile(path + "scenario.html");
                briefing.addPage(text, "landuseTurn1");
                this.debrief.addPage(text, "landuseTurn1");
                root.addNewProposal("OpenSpace");
                root.addNewProposal("Education");
                root.addNewProposal("Highway");
                root.addNewProposal("Sewers");
                root.addNewProposal("Retrofit");
                root.addNewProposal("Waterfront");
                root.addNewProposal("TreeTrimming");
                root.addNewProposal("EndTurn");
                root.createProposalsPage();
                text = StringUtils.readFile(path + "proposals.html");
                text = text + root.getProposalSummaries();
                text = text + "</body></html>";
                briefing.addPage(text, "landuseTurn1");
                this.debrief.addPage(text, "landuseTurn1");
                break;
            }
            case 2: {
                this.setBudget(12.0f, 10.0f);
                text = text + "</body></html>";
                briefing.addPage(text, "landuseTurn1");
                this.debrief.addPage(text, "landuseTurn1");
                text = "<h1>Development</h1>";
                text = text + "<p>Several years pass.  During this time, the town grows.</p>";
                text = text + this.grow(root, rng);
                this.checkpointScores(root);
                this.getMap().copyLayer("landuse", "landusePreHurricane");
                briefing.addPage(text, "landusePreHurricane");
                this.debrief.addPage(text, "landusePreHurricane");
                text = StringUtils.readFile(path + "disaster.html");
                briefing.addPage(text, "landusePreHurricane");
                HurricaneManager hm = new HurricaneManager(root, rng);
                hm.go();
                text = StringUtils.readFile(path + "scenario-head.html");
                text = text + StringUtils.readFile(path + "flooding-downtown.html");
                text = !proposalLayer.isSet("Waterfront") ? text + "  Many downtown businesses have incurred serious losses.</p>" : text + "</p>";
                root.addNewProposal("Downtown");
                root.addNewProposal("EOC");
                root.addNewProposal("Seawall");
                if (!proposalLayer.isSet("Highway")) {
                    text = text + StringUtils.readFile(path + "road-damage.html");
                    root.addNewProposal("Highway2");
                }
                if (!proposalLayer.isSet("RestrictSeptic") && !proposalLayer.isSet("WetlandOS")) {
                    landuseLayer.incrementAttribute("ecologyBonus", -0.05f);
                    text = text + StringUtils.readFile(path + "wetland-contamination.html");
                    root.addNewProposal("Monitor");
                }
                text = text + "<p><b>Destroyed Buildings.</b>";
                text = text + "  Heavy winds and storm surge severely damaged or destroyed ";
                text = text + "" + hm.getTotal() + " buildings, marked with a black X on the map.";
                if (!proposalLayer.isSet("Retrofit")) {
                    text = text + "  Older buildings were especialy hard-hit.";
                    root.addNewProposal("Historic");
                }
                text = text + hm.getSummary();
                root.addNewProposal("Buyout");
                root.addNewProposal("Code");
                if (!proposalLayer.isSet("Education")) {
                    root.addNewProposal("Education2");
                }
                root.addNewProposal("EndTurn2");
                root.createProposalsPage();
                text = text + StringUtils.readFile(path + "scenario-tail.html");
                this.checkpointScores(root);
                this.getMap().copyLayer("landuse", "landusePostHurricane");
                briefing.addPage(text, "landusePostHurricane");
                this.debrief.addPage(text, "landusePostHurricane");
                text = "<h1>Round 2 Proposals</h1>";
                text = text + root.getProposalSummaries();
                briefing.addPage(text, "landuse");
                this.debrief.addPage(text, "landusePostHurricane");
                break;
            }
            case 3: {
                String[] sites;
                int count;
                text = text + "</body></html>";
                this.getMap().copyLayer("landuse", "landusePostTurn2");
                briefing.addPage(text, "landusePostTurn2");
                this.debrief.addPage(text, "landusePostTurn2");
                LanduseManager.convert(root, rng, "destroyed", "none", 0.2);
                LanduseManager.rebuild(root, "landusePreHurricane");
                text = "<h1>Recovery</h1>";
                text = text + "After the hurricane, it doesn't take long ";
                text = text + "for damaged and destroyed buildings to be rebuilt.";
                text = text + "<p><hr><p>";
                text = text + "<h1>Development</h1>";
                text = text + "<p>After the recovery period is over, several more years pass and the town continues to grow.</p>";
                text = text + this.grow(root, rng);
                this.checkpointScores(root);
                this.getMap().copyLayer("landuse", "landusePreTrigger");
                briefing.addPage(text, "landusePreTrigger");
                this.debrief.addPage(text, "landusePreTrigger");
                this.getMap().copyLayer("landuse", "landusePostTrigger");
                text = StringUtils.readFile(path + "trigger.html");
                briefing.addPage(text, "landusePostTrigger");
                this.debrief.addPage(text, "landusePostTrigger");
                text = StringUtils.readFile(path + "scenario-head.html");
                int emod = 0;
                int smod = 0;
                boolean problemFlag = false;
                Layer probLayer = this.getMap().createLayer("problems");
                ArrayList<String> issues = new ArrayList<String>();
                probLayer.setAttribute("issues", issues);
                if (!(proposalLayer.isSet("Waterfront") || proposalLayer.isSet("Seawall") || proposalLayer.isSet("Downtown") || proposalLayer.isSet("Sewers") || proposalLayer.isSet("RetroWater") || proposalLayer.isSet("Buyout"))) {
                    issues.add("floodingDowntown");
                    text = text + StringUtils.readFile(path + "flooding-downtown.html");
                    problemFlag = true;
                    root.addNewProposal("Retrofit3");
                    if (!proposalLayer.isSet("EOC")) {
                        root.addNewProposal("EOC3");
                    }
                    root.addNewProposal("ImproveDrainage");
                    root.addNewProposal("FinancialAssistance");
                    root.addNewProposal("NFIP_CRS");
                    ++emod;
                }
                if (!proposalLayer.isSet("SewagePlant") && !proposalLayer.isSet("RestrictSeptic")) {
                    count = 0;
                    sites = OpenSpace.wetlandSites;
                    count = this.getMap().luCount("all", this.getMap().getCells(sites));
                    if (count >= 35) {
                        if (proposalLayer.isSet("Monitor")) {
                            text = text + StringUtils.readFile(path + "septic-monitor.html");
                            issues.add("septicWaterTableAverted");
                        } else {
                            text = text + StringUtils.readFile(path + "septic-watertable.html");
                            root.addNewProposal("WaterPurificationPlant");
                            root.addNewProposal("BoilWaterNotices");
                            root.addNewProposal("SepticEnforcement");
                            root.addNewProposal("PromoteTourism");
                            issues.add("septicWaterTable");
                            problemFlag = true;
                        }
                    }
                }
                if ((double)root.getScore("ecology") > 0.75 && !issues.contains("septicWaterTable")) {
                    if (proposalLayer.isSet("Monitor")) {
                        text = text + StringUtils.readFile(path + "bsv-monitor.html");
                        issues.add("blackSwanVirusAvertedMonitor");
                    } else if (proposalLayer.isSet("BSA")) {
                        text = text + StringUtils.readFile(path + "bsv-bsa.html");
                        issues.add("blackSwanVirusAvertedBSA");
                    } else {
                        text = text + StringUtils.readFile(path + "black-swan-virus.html");
                        issues.add("blackSwanVirus");
                        problemFlag = true;
                        root.addNewProposal("PublicAwarenessProgram");
                        root.addNewProposal("MosquitoControl");
                        root.addNewProposal("BreedingSiteReduction");
                        root.addNewProposal("Monitor3");
                    }
                }
                if (proposalLayer.isSet("Seawall")) {
                    if (proposalLayer.isSet("ShoreOS")) {
                        text = text + StringUtils.readFile(path + "beach-shoreos.html");
                        issues.add("beachLossAverted");
                    } else {
                        text = text + StringUtils.readFile(path + "beach-loss.html");
                        issues.add("beachLoss");
                        problemFlag = true;
                        root.addNewProposal("ShorelineArmoring");
                        root.addNewProposal("BeachRenourishment");
                        root.addNewProposal("UndercurrentStabilizers");
                        root.addNewProposal("BirdWatchingAds");
                        emod += 2;
                    }
                }
                count = 0;
                sites = new String[]{"<0,2>", "<0,3>", "<0,4>", "<0,5>", "<0,6>", "<1,3>", "<1,4>"};
                count = this.getMap().luCount("all", this.getMap().getCells(sites));
                if (count > 15) {
                    text = text + StringUtils.readFile(path + "industrial-runoff.html");
                    issues.add("industrialRunoff");
                    problemFlag = true;
                    root.addNewProposal("TaxBreaks");
                    root.addNewProposal("PollutionRegulations");
                    root.addNewProposal("RemediationAssistance");
                }
                Layer initLayer = this.getMap().getLayer("landuseTurn1");
                String[] luNames = Main.luNames;
                float[] counts = new float[luNames.length];
                float[] icounts = new float[luNames.length];
                for (int i = 0; i < luNames.length; ++i) {
                    counts[i] = this.getMap().luCount(luNames[i]);
                    icounts[i] = this.getMap().luCount(luNames[i], initLayer);
                }
                float[] ratio = new float[luNames.length];
                ratio[0] = counts[0] / icounts[0];
                float min = ratio[0];
                float max = ratio[0];
                int imin = 0;
                int imax = 0;
                for (int i = 0; i < luNames.length; ++i) {
                    ratio[i] = counts[i] / icounts[i];
                    if (ratio[i] < min) {
                        min = ratio[i];
                        imin = i;
                    }
                    if (ratio[i] > max) {
                        max = ratio[i];
                        imax = i;
                    }
                    this.getMap().setAttribute("ratio" + luNames[i], ratio[i]);
                }
                float imbalance = max / min;
                this.getMap().setAttribute("imbalance", imbalance);
                this.getMap().setAttribute("maxmin", luNames[imax] + "/" + luNames[imin]);
                if ((double)imbalance > 1.2) {
                    if (proposalLayer.isSet("Historic")) {
                        issues.add("imbalanceAvertedHistoric");
                    } else if (proposalLayer.isSet("MixedUse")) {
                        issues.add("imbalanceAvertedMixedUse");
                    } else {
                        String runawayLU = luNames[imax];
                        boolean highway = proposalLayer.isSet("Highway");
                        problemFlag = true;
                        root.addNewProposal("DevelopmentPlan");
                        if ("house".equals(runawayLU) || "condo".equals(runawayLU) && highway) {
                            text = text + StringUtils.readFile(path + "imbalance-bedroom.html");
                            issues.add("weakJobMarket");
                            root.addNewProposal("RaisePropertyTaxes");
                            root.addNewProposal("ReduceLicensingFees");
                            root.addNewProposal("SolicitIndustry");
                        }
                        if ("store".equals(runawayLU) || "hotel".equals(runawayLU) && highway) {
                            text = text + StringUtils.readFile(path + "imbalance-trap.html");
                            issues.add("overcommercialization");
                            root.addNewProposal("RestrictPermits");
                            root.addNewProposal("RelaxHousingRegulations");
                            root.addNewProposal("RaiseSalesTax");
                        }
                        if ("hotel".equals(runawayLU) && !highway || "condo".equals(runawayLU) && !highway) {
                            text = text + StringUtils.readFile(path + "imbalance-resort.html");
                            issues.add("soaringLandValues");
                            root.addNewProposal("LowerHousingStandards");
                            root.addNewProposal("VisitorUseFees");
                            root.addNewProposal("ZoneAffordableHousing");
                        }
                    }
                }
                if (!problemFlag) {
                    text = text + StringUtils.readFile(path + "casino.html");
                    issues.add("casino");
                    root.addNewProposal("AntiCasinoCampaign");
                    ++smod;
                }
                root.addNewProposal("Center");
                root.addNewProposal("Lab");
                if (root.getNewProposals().size() < 6 && !proposalLayer.isSet("Historic")) {
                    root.addNewProposal("Historic3");
                }
                if (root.getNewProposals().size() < 6 && !proposalLayer.isSet("Education") && !proposalLayer.isSet("Education2")) {
                    root.addNewProposal("Education3");
                }
                if (root.getNewProposals().size() < 6 && !proposalLayer.isSet("Highway") && !proposalLayer.isSet("Highway2")) {
                    root.addNewProposal("Highway3");
                }
                if (root.getNewProposals().size() < 6 && !proposalLayer.isSet("TreeTrimming")) {
                    root.addNewProposal("TreeTrimming3");
                }
                root.addNewProposal("EndTurn3");
                root.createProposalsPage();
                this.setBudget(7 + emod, 7 + smod);
                text = text + "</body></html>";
                briefing.addPage(text, "landusePostTrigger");
                this.debrief.addPage(text, "landusePostTrigger");
                text = "<h1>Round 3 Proposals</h1>";
                text = text + root.getProposalSummaries();
                briefing.addPage(text, "landuse");
                this.debrief.addPage(text, "landusePostTrigger");
                break;
            }
            default: {
                float mitigation;
                text = text + "</body></html>";
                this.getMap().copyLayer("landuse", "landusePostTurn3");
                briefing.addPage(text, "landusePostTurn3");
                this.debrief.addPage(text, "landusePostTurn3");
                this.checkpointScores(root);
                Layer probLayer = this.getMap().getLayer("problems");
                ArrayList issues = (ArrayList)probLayer.getObjectAttribute("issues");
                text = "<html><body>";
                text = text + "<h1>Resolution</h1>";
                text = text + "<p>As time passes, the effects of your responses to Round 3 problems become apparent.</p><ul>";
                if (issues.contains("casino")) {
                    text = text + "<li><b>Casino</b>: ";
                    text = probLayer.getAttribute("casino", 0.0f) > 0.0f ? text + StringUtils.readFile(path + "casino-solved.html") : text + StringUtils.readFile(path + "casino-unsolved.html");
                }
                int localHit = 0;
                if (issues.contains("floodingDowntown")) {
                    text = text + "<li><b>Flooding Downtown</b>: ";
                    mitigation = probLayer.getAttribute("floodingDowntown", 0.0f);
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "fd-solved.html");
                    } else if (mitigation >= 1.0f) {
                        text = proposalLayer.isSet("FinancialAssistance") ? text + StringUtils.readFile(path + "fd-partial-assist.html") : text + StringUtils.readFile(path + "fd-partial.html");
                        ++localHit;
                    } else {
                        text = text + StringUtils.readFile(path + "fd-unsolved.html");
                        localHit += 2;
                    }
                }
                if (issues.contains("industrialRunoff")) {
                    text = text + "<li><b>Industrial Runoff</b>: ";
                    mitigation = probLayer.getAttribute("industrialRunoff", 0.0f);
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "ir-solved.html");
                    } else if (mitigation >= 1.0f) {
                        text = text + StringUtils.readFile(path + "ir-partial.html");
                        ++localHit;
                    } else {
                        text = text + StringUtils.readFile(path + "ir-unsolved.html");
                        probLayer.setAttribute("industrialRunoffUnsolved", true);
                        localHit += 2;
                    }
                }
                int touristHit = 0;
                if (issues.contains("septicWaterTable")) {
                    text = text + "<li><b>Septic Watertable</b>: ";
                    mitigation = probLayer.getAttribute("septicWaterTable", 0.0f);
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "swt-solved.html");
                    } else if (mitigation >= 1.0f) {
                        text = proposalLayer.isSet("PromoteTourism") ? text + StringUtils.readFile(path + "swt-partial-ads.html") : text + StringUtils.readFile(path + "swt-partial.html");
                        ++touristHit;
                    } else {
                        text = text + StringUtils.readFile(path + "swt-unsolved.html");
                        touristHit += 2;
                    }
                }
                if (issues.contains("beachLoss")) {
                    text = text + "<li><b>Beach Loss</b>: ";
                    mitigation = probLayer.getAttribute("beachLoss", 0.0f);
                    if (mitigation >= 2.0f) {
                        text = proposalLayer.isSet("UndercurrentStabilizers") ? text + StringUtils.readFile(path + "bl-solved-ucs.html") : text + StringUtils.readFile(path + "bl-solved-no-ucs.html");
                    } else if (mitigation >= 1.0f) {
                        text = proposalLayer.isSet("BeachRenourishment") ? text + StringUtils.readFile(path + "bl-partial-nourish.html") : text + StringUtils.readFile(path + "bl-partial-ads.html");
                        ++touristHit;
                    } else {
                        text = text + StringUtils.readFile(path + "bl-unsolved.html");
                        touristHit += 2;
                    }
                }
                if (issues.contains("blackSwanVirus")) {
                    text = text + "<li><b>Black Swan Virus</b>: ";
                    mitigation = probLayer.getAttribute("blackSwanVirus", 0.0f);
                    if (proposalLayer.isSet("BreedingSiteReduction") && mitigation == 1.0f) {
                        probLayer.setAttribute("blackSwanVirus", 0.0f);
                        mitigation = 0.0f;
                    }
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "bsv-solved.html");
                    } else if (mitigation >= 1.0f) {
                        text = text + StringUtils.readFile(path + "bsv-partial.html");
                        ++touristHit;
                    } else {
                        text = text + StringUtils.readFile(path + "bsv-unsolved.html");
                        touristHit += 2;
                    }
                }
                if (proposalLayer.isSet("BirdWatchingAds") && proposalLayer.isSet("PromoteTourism")) {
                    ++touristHit;
                }
                if (proposalLayer.isSet("LowerHousingStandards") && !proposalLayer.isSet("DevelopmentPlan") && !proposalLayer.isSet("ZoneAffordableHousing") && !proposalLayer.isSet("VisitorUseFees")) {
                    ++localHit;
                }
                if (proposalLayer.isSet("VisitorUseFees")) {
                    ++touristHit;
                }
                if (proposalLayer.isSet("RestrictExistingPermits")) {
                    localHit = (int)((double)localHit + 0.5);
                }
                if (proposalLayer.isSet("SolicitIndustry")) {
                    touristHit = (int)((double)touristHit + 0.5);
                    if (probLayer.isSet("industrialRunoffUnsolved")) {
                        text = text + "<li><b>Industry Swap</b>: ";
                        localHit -= 2;
                        text = text + StringUtils.readFile(path + "industry-swapout.html");
                    }
                }
                if (proposalLayer.isSet("WaterPark")) {
                    touristHit = (int)((double)touristHit - 0.5);
                }
                if (proposalLayer.isSet("Lab")) {
                    --localHit;
                    --touristHit;
                }
                if (touristHit <= 1) {
                    // empty if block
                }
                if (touristHit > 1 && touristHit < 3) {
                    text = text + "<li><b>Tourism Weakened</b>: ";
                    text = text + StringUtils.readFile(path + "tourism-weakened.html");
                }
                if (touristHit >= 3) {
                    text = text + "<li><b>Tourism Lost</b>: ";
                    text = text + StringUtils.readFile(path + "tourism-lost.html");
                }
                if (localHit <= 1) {
                    // empty if block
                }
                if (localHit > 1 && localHit < 3) {
                    text = text + "<li><b>Local Economy Weakened</b>: ";
                    text = text + StringUtils.readFile(path + "local-weakened.html");
                }
                if (localHit >= 3) {
                    text = text + "<li><b>Local Economy Lost</b>: ";
                    text = text + StringUtils.readFile(path + "local-lost.html");
                }
                if (touristHit >= 3 && localHit >= 3) {
                    text = text + "<li><b>Total Collapse</b>: ";
                    text = text + StringUtils.readFile(path + "total-collapse.html");
                } else if (touristHit >= 2 && localHit >= 2) {
                    text = text + "<li><b>Downward Spiral</b>: ";
                    text = text + StringUtils.readFile(path + "downward-spiral.html");
                }
                if (issues.contains("overcommercialization")) {
                    text = text + "<li><b>Overcommercialization</b>: ";
                    mitigation = probLayer.getAttribute("overcommercialization", 0.0f);
                    if (touristHit > 0) {
                        mitigation = touristHit > 2 ? (mitigation += 2.0f) : (mitigation += 1.0f);
                        text = text + StringUtils.readFile(path + "th-cancels-oc.html");
                    }
                    if (proposalLayer.isSet("Center") && mitigation == 1.0f) {
                        probLayer.setAttribute("overcommercialization", 0.0f);
                        mitigation = 0.0f;
                    }
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "oc-solved.html");
                    } else if (mitigation >= 1.0f) {
                        LanduseManager.convert(root, rng, "condo", "hotel", 0.2);
                        LanduseManager.convert(root, rng, "house", "store", 0.25);
                        text = text + StringUtils.readFile(path + "oc-partial.html");
                    } else {
                        LanduseManager.convert(root, rng, "condo", "hotel", 0.5);
                        LanduseManager.convert(root, rng, "house", "store", 0.5);
                        text = text + StringUtils.readFile(path + "oc-unsolved.html");
                    }
                }
                if (issues.contains("weakJobMarket")) {
                    text = text + "<li><b>Weak Job Market</b>: ";
                    mitigation = probLayer.getAttribute("weakJobMarket", 0.0f);
                    if (proposalLayer.isSet("Center") && mitigation == 1.0f) {
                        probLayer.setAttribute("weakJobMarket", 0.0f);
                        mitigation = 0.0f;
                    }
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "wjm-solved.html");
                    } else if (mitigation >= 1.0f) {
                        LanduseManager.convert(root, rng, "hotel", "condo", 0.5);
                        LanduseManager.convert(root, rng, "store", "house", 0.5);
                        text = text + StringUtils.readFile(path + "wjm-partial.html");
                    } else {
                        LanduseManager.convert(root, rng, "hotel", "condo", 0.9);
                        LanduseManager.convert(root, rng, "store", "house", 0.9);
                        text = text + StringUtils.readFile(path + "wjm-unsolved.html");
                    }
                }
                if (issues.contains("soaringLandValues")) {
                    float disease;
                    text = text + "<li><b>Soaring Land Values</b>: ";
                    mitigation = probLayer.getAttribute("soaringLandValues", 0.0f);
                    if (issues.contains("blackSwanVirus") && (disease = probLayer.getAttribute("blackSwanVirus", 0.0f)) < 2.0f) {
                        mitigation += (float)(disease < 1.0f ? 2 : 1);
                        text = text + StringUtils.readFile(path + "bsv-cancels-slv.html");
                    }
                    if (issues.contains("septicWaterTable") && (disease = probLayer.getAttribute("septicWaterTable", 0.0f)) < 2.0f) {
                        mitigation += (float)(disease < 1.0f ? 2 : 1);
                        text = text + StringUtils.readFile(path + "swt-cancels-slv.html");
                    }
                    if (proposalLayer.isSet("Center") && mitigation == 1.0f) {
                        probLayer.setAttribute("soaringLandValues", 0.0f);
                        mitigation = 0.0f;
                    }
                    if (mitigation >= 2.0f) {
                        text = text + StringUtils.readFile(path + "slv-solved.html");
                    } else if (mitigation >= 1.0f) {
                        LanduseManager.convert(root, rng, "store", "hotel", 0.4);
                        LanduseManager.convert(root, rng, "house", "condo", 0.5);
                        text = text + StringUtils.readFile(path + "slv-partial.html");
                    } else {
                        LanduseManager.convert(root, rng, "store", "hotel", 0.8);
                        LanduseManager.convert(root, rng, "house", "condo", 0.9);
                        text = text + StringUtils.readFile(path + "slv-unsolved.html");
                    }
                }
                text = text + "</ul>";
                text = text + "</body></html>";
                this.getMap().copyLayer("landuse", "landuseEndOfGame");
                briefing.addPage(text, "landuseEndOfGame");
                this.debrief.addPage(text, "landuseEndOfGame");
                this.setBudget(0.0f, 0.0f);
                text = "<html><body>";
                text = text + "<h1>Game Over</h1>";
                text = text + "<big>Congratulations!  You've made it to the end of the game.</big>";
                text = text + "<p><table>";
                String[] m = Main.metrics;
                String[] mc = Main.metricsColors;
                for (int i = 0; i < m.length; ++i) {
                    float score = root.getScore(m[i]);
                    text = text + "<tr><td><font color=\"" + mc[i] + "\">" + m[i] + "</font></td>";
                    text = text + "<td>" + root.getScore(m[i]) + "</td></tr>";
                }
                text = text + "</table>";
                text = text + "<p>Here's how your city compares to the results of more than 10,000 simulated games:";
                double[] epercentiles = new double[]{0.0, 0.57, 0.6, 0.62, 0.65, 0.67, 0.69, 0.71, 0.73, 0.76, 0.88, 1.1};
                float score = root.getScore("ecology");
                for (int i = 0; i <= 10; ++i) {
                    if (!((double)score >= epercentiles[i]) || !((double)score < epercentiles[i + 1])) continue;
                    text = text + "<p>Your ecology score is in the " + i * 10 + "th percentile";
                }
                text = text + "<br>Average: 0.65  (high score is good, low score is bad)";
                double[] hpercentiles = new double[]{0.0, 0.31, 0.35, 0.38, 0.4, 0.42, 0.45, 0.48, 0.52, 0.58, 0.79, 1.1};
                score = root.getScore("hazard");
                for (int i = 0; i <= 10; ++i) {
                    if (!((double)score >= hpercentiles[i]) || !((double)score < hpercentiles[i + 1])) continue;
                    text = text + "<p>Your hazard score is in the " + i * 10 + "th percentile";
                }
                text = text + "<br>Average: 0.48 (high score is bad, low score is good)";
                text = text + "<p><hr>";
                text = text + "<p>Take some time to reflect on the outcome.  Are you satisfied with where you ended up?  Is it where you expected to be?";
                text = text + "<p>You can review the progress of the game on the pages following.";
                briefing.addPage(text, "landuse");
                text = StringUtils.readFile(path + "credits.html");
                briefing.addPage(text, "landuse");
                ArrayList texts = this.debrief.getText();
                ArrayList layers = this.debrief.getLayers();
                for (int i = 0; i < this.debrief.getCount(); ++i) {
                    briefing.addPage((String)texts.get(i), (String)layers.get(i));
                }
                briefing.setFinal(true);
                this.debrief = briefing;
            }
        }
        this.setAttribute("intro", briefing.getDigest());
        briefing.addGameRoot((GameRoot)root.duplicate());
        return briefing;
    }

    public Briefing getDebriefing() {
        return this.debrief;
    }

    private void checkpointScores(GameRoot root) {
        String[] m = Main.metrics;
        for (int i = 0; i < m.length; ++i) {
            this.setAttribute(m[i] + "OldScore", root.getScore(m[i]));
        }
    }

    private String grow(GameRoot root, Random rng) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        format.applyPattern("+0.00;-0,00");
        this.checkpointScores(root);
        GrowthManager gm = new GrowthManager(root, rng);
        gm.go();
        String s = "<p><b>Growth</b></p>Buildings added:";
        s = s + gm.getSummary();
        s = s + "<p>New buildings affect ecology and hazard scores:<ul>";
        s = s + "<li>Ecology: ";
        s = s + format.format(root.getScore("ecology") - this.getAttribute("ecologyOldScore", 0.0f));
        s = s + "</li>";
        s = s + "<li>Hazard: ";
        s = s + format.format(root.getScore("hazard") - this.getAttribute("hazardOldScore", 0.0f));
        s = s + "</li></ul></p>";
        s = s + "</body></html>";
        return s;
    }

    public int getTurn() {
        return (int)this.getAttribute("turn");
    }

    public int getNumTurns() {
        return (int)this.getAttribute("numTurns");
    }

    public String getName() {
        return (String)this.getObjectAttribute("name");
    }

    public String roleForPlayer(int turnNumber) {
        if (turnNumber > 4 || turnNumber < 1) {
            return "--";
        }
        return StringUtils.capitalize(Main.roleNames[turnNumber - 1]);
    }

    public float getBaseEconBudget() {
        return this.getAttribute("baseEconBudget", 0.0f);
    }

    public float getBaseSocialBudget() {
        return this.getAttribute("baseSocialBudget", 0.0f);
    }

    public float getCurrentEconBudget() {
        return this.getAttribute("currentEconBudget", 0.0f);
    }

    public void setCurrentEconBudget(int budget) {
        this.setAttribute("currentEconBudget", budget);
    }

    public float getCurrentSocialBudget() {
        return this.getAttribute("currentSocialBudget", 0.0f);
    }

    public void setCurrentSocialBudget(int budget) {
        this.setAttribute("currentSocialBudget", 0.0f);
    }

    public void setBudget(float econ, float social) {
        int econBonus = (int)this.getAttribute("econBonus", 0.0f);
        int socialBonus = (int)this.getAttribute("socialBonus", 0.0f);
        this.setAttribute("defaultEconBudget", econ);
        this.setAttribute("baseEconBudget", econ + (float)(econBonus += (int)this.getAttribute("econRemainder", 0.0f)));
        this.setAttribute("currentEconBudget", econ + (float)econBonus);
        this.setAttribute("defaultSocialBudget", social);
        this.setAttribute("baseSocialBudget", social + (float)(socialBonus += (int)this.getAttribute("socialRemainder", 0.0f)));
        this.setAttribute("currentSocialBudget", social + (float)socialBonus);
    }

    public void spendBudget(float econCost, float socialCost) {
        this.incrementAttribute("currentEconBudget", -econCost);
        this.incrementAttribute("currentSocialBudget", -socialCost);
    }

    public Map getMap() {
        return (Map)this.getObjectAttribute("map");
    }

    public void setMap(Map map) {
        this.setAttribute("map", map);
    }

    public static Proposal readProposal(String filename) {
        String path;
        InputStream inStream = (class$dd$hurricane$Scenario == null ? (class$dd$hurricane$Scenario = Scenario.class$("dd.hurricane.Scenario")) : class$dd$hurricane$Scenario).getResourceAsStream(path = "/resources/dlug/proposals/" + filename);
        if (inStream != null) {
            Proposal p = (Proposal)SimObject.readFromXML(new InputStreamReader(inStream));
            return p;
        }
        Logger.getDefaultLog().error(" GameSupport ERROR: Unable to load " + filename);
        return null;
    }

    public static CostTable readCostTable() {
        String path;
        InputStream inStream = (class$dd$hurricane$Scenario == null ? (class$dd$hurricane$Scenario = Scenario.class$("dd.hurricane.Scenario")) : class$dd$hurricane$Scenario).getResourceAsStream(path = "/resources/dlug/proposals/CostTable.xml");
        if (inStream != null) {
            CostTable ct = (CostTable)SimObject.readFromXML(new InputStreamReader(inStream));
            return ct;
        }
        Scenario.out(" GameSupport ERROR: Unable to load CostTable.xml");
        return null;
    }

    public static void main(String[] args) {
        Scenario me = new Scenario();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

