/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class Education
extends Proposal {
    public Education() {
        this.setTitle("Hazard Education Program");
        this.setFamily("Education");
        this.setDescription("Educate the public about natural hazards");
        this.setTurn(1);
        this.setAttribute("tocName", "Edu");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 6.0f);
        this.setAttribute("debriefingText", "An informed public is easier to work with on hazard issues. As a result, the political work budget in subsequent turns has been increased.  Increased awareness of hazard has a small dampening effect on the housing market.");
        ConfigParameter c = new ConfigParameter("Increase Budget", "boolean", "extra", "increaseBudget");
        c.setAttribute("legendIconDefault", "education.png");
        c.setAttribute("legendIcon", "education-extra.png");
        c.setAttribute("dEconCost", 2.0f);
        this.setAttribute("increaseBudget", false);
        this.addConfigParameter(c);
    }

    public Set getLegendIcons() {
        HashSet<String> s = new HashSet<String>();
        if (this.getAttribute("increaseBudget", 0.0f) != 0.0f) {
            s.add("education-extra.png");
        } else {
            s.add("education.png");
        }
        return s;
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        layer.incrementAttribute("house", -0.05f);
        if (this.getAttribute("increaseBudget", 0.0f) > 0.0f) {
            root.getScenario().incrementAttribute("socialBonus", 3.0f);
        } else {
            root.getScenario().incrementAttribute("socialBonus", 2.0f);
        }
    }
}

