/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.sim.GameRoot;
import dd.sim.Proposal;
import java.util.Random;

public class EndTurn
extends Proposal {
    public EndTurn() {
        this.setTitle("End Turn Now");
        this.setFamily("EndTurn");
        this.setDescription("Ends the round right away");
        this.setTurn(1);
        this.setAttribute("tocName", "EndTurn");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 0.0f);
    }

    public void enact(GameRoot root, Random rng) {
        int econ = (int)Math.floor(root.getScenario().getCurrentEconBudget() / 2.0f);
        int soc = (int)Math.floor(root.getScenario().getCurrentSocialBudget() / 2.0f);
        this.setAttribute("debriefingText", "You ended the round with budget remaining.  " + econ + " money and " + soc + " work will carry over to next rounds's budget.");
        super.enact(root);
        root.spendRemainingBudget();
    }
}

