/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class Highway
extends Proposal {
    public Highway() {
        this.setTitle("Highway Improvements");
        this.setFamily("Highway");
        this.setDescription("Widen and improve the highway");
        this.setTurn(1);
        this.setAttribute("tocName", "Hwy");
        this.setAttribute("mapIcon", "highway-improvement.png");
        this.setAttribute("baseEconCost", 6.0f);
        this.setAttribute("baseSocialCost", 1.0f);
        this.setAttribute("debriefingStart", "Since highway improvements reduce traffic, people can travel further in the same amount of time, encouraging growth, especially along the highway.");
        this.setAttribute("debriefingEnd", " ");
        ConfigParameter c = new ConfigParameter("Build Bridge", "boolean", "bridge", "buildBridge");
        c.setAttribute("mapIcon", "bridge.png");
        this.setAttribute("buildBridge", false);
        c.setAttribute("dEconCost", 4.0f);
        c.setAttribute("debriefingText", "A bridge to the mainland makes this effect even stronger.");
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        if (this.getAttribute("buildBridge", 0.0f) > 0.0f) {
            proplayer.setAttribute("Bridge", true);
            root.getScenario().getMap().setAttribute("transitImage", "highway-bridge.png");
            layer.incrementAttribute("growth", 0.6f);
            layer.incrementAttribute("condo", 0.3f);
        } else {
            root.getScenario().getMap().setAttribute("transitImage", "highway-improvement.png");
            layer.incrementAttribute("growth", 0.2f);
            layer.incrementAttribute("condo", 0.1f);
        }
    }
}

