/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.hurricane.LanduseManager;
import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class OpenSpace
extends Proposal {
    public static final String[] shoreSites = new String[]{"<4,8>", "<5,8>", "<6,8>", "<7,8>", "<8,8>", "<9,8>"};
    public static final String[] wetlandSites = new String[]{"<4,3>", "<4,4>", "<3,5>", "<4,5>", "<5,5>", "<6,5>", "<7,4>", "<8,4>"};

    public OpenSpace() {
        this.setTitle("Acquire Open Space");
        this.setFamily("OpenSpace");
        this.setDescription("Preserve undeveloped land");
        this.setTurn(1);
        this.setAttribute("tocName", "OpnSpc");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 0.0f);
        this.setAttribute("debriefingStart", "Protecting undeveloped land is good for the local ecology. Open space can also indirectly reduce hazard by keeping development out of hazardous areas.");
        ConfigParameter c = new ConfigParameter("Terrain Focus", "choice", "[description]", "terrainFocus");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<String> choiceIcons = new ArrayList<String>();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList debriefingTexts = new ArrayList();
        this.setAttribute("terrainFocus", "Shore");
        choices.add("Shore");
        choiceIcons.add("openspace-coast.png");
        choiceEconCost.add(new Integer(3));
        choiceSocialCost.add(new Integer(1));
        choices.add("Wetlands");
        choiceIcons.add("openspace-wetland.png");
        choiceEconCost.add(new Integer(2));
        choiceSocialCost.add(new Integer(2));
        choices.add("Both");
        choiceIcons.add("openspace-both.png");
        choiceEconCost.add(new Integer(5));
        choiceSocialCost.add(new Integer(3));
        c.setAttribute("choices", choices);
        c.setAttribute("choiceMapIcons", choiceIcons);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        this.addConfigParameter(c);
        c = new ConfigParameter("TDR", "boolean", "TDR", "TDR");
        this.setAttribute("TDR", false);
        c.setAttribute("legendIcon", "tdr.png");
        c.setAttribute("dEconCost", -2.0f);
        c.setAttribute("dSocialCost", 1.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Required", "boolean", "req'd", "required");
        this.setAttribute("required", false);
        c.setAttribute("dEconCost", 0.0f);
        c.setAttribute("dSocialCost", 2.0f);
        c.setAttribute("debriefingText", " ");
        this.addConfigParameter(c);
        this.setAttribute("debriefingEnd", " ");
    }

    public void enact(GameRoot root, Random rng) {
        double prob;
        super.enact(root);
        Map map = root.getScenario().getMap();
        Layer layer = map.getLayer("landuse");
        Layer proplayer = map.getLayer("proposals");
        ArrayList targets = new ArrayList();
        layer.incrementAttribute("condo", -0.05f);
        String focus = (String)this.getObjectAttribute("terrainFocus");
        if ("Shore".equals(focus) || "Both".equals(focus)) {
            proplayer.setAttribute("ShoreOS", true);
            targets.addAll(map.getCells(shoreSites));
        }
        if ("Wetlands".equals(focus) || "Both".equals(focus)) {
            proplayer.setAttribute("WetlandOS", true);
            targets.addAll(map.getCells(wetlandSites));
        }
        if (this.getAttribute("required", 0.0f) > 0.0f) {
            proplayer.setAttribute("RequiredOS", true);
            prob = 0.9;
        } else {
            prob = 0.5;
        }
        if ("TDR".equals(this.getObjectAttribute("acquisitionStrategy"))) {
            proplayer.setAttribute("TDR", true);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                MapCell cell = (MapCell)iter.next();
                cell.setAttribute("relocate", layer, "<2,7>");
            }
        }
        LanduseManager.convert(root, rng, targets, "none", "openspace", prob);
    }
}

