/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.hurricane.Main;
import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import dd.util.StringUtils;
import java.util.ArrayList;
import java.util.Random;

public class Retrofit
extends Proposal {
    public Retrofit() {
        this.setTitle("Retrofit Buildings");
        this.setFamily("Retrofit");
        this.setDescription("Reduce hazard vulnerability of older structures");
        this.setTurn(1);
        this.setAttribute("tocName", "Retro");
        this.setAttribute("legendIcon", "retrofit.png");
        this.setAttribute("baseEconCost", 2.0f);
        this.setAttribute("baseSocialCost", 2.0f);
        this.setAttribute("debriefingText", "Unlike other proposals, retrofitting reduces hazard directly, by making building less vulnerable.");
        ConfigParameter c = new ConfigParameter("Target Houses", "boolean", "house", "targetHouses");
        this.setAttribute("targetHouses", false);
        c.setAttribute("legendIcon", "retro-residential.png");
        c.setAttribute("dEconCost", 1.0f);
        c.setAttribute("dSocialCost", 1.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Target Stores", "boolean", "store", "targetLocalBusinesses");
        this.setAttribute("targetStores", false);
        c.setAttribute("legendIcon", "retro-commercial.png");
        c.setAttribute("dEconCost", 1.0f);
        c.setAttribute("dSocialCost", 1.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Target Hotels", "boolean", "hotel", "targetHotels");
        this.setAttribute("targetHotels", false);
        c.setAttribute("legendIcon", "retro-hotel.png");
        c.setAttribute("dEconCost", 1.0f);
        c.setAttribute("dSocialCost", 1.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Mitigated Hazard", "choice", "[description]", "mitigatedHazard");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<String> choiceIcons = new ArrayList<String>();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList debriefingTexts = new ArrayList();
        this.setAttribute("mitigatedHazard", "Wind");
        choices.add("Wind");
        choiceIcons.add("retro-wind.png");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(1));
        choices.add("Water");
        choiceIcons.add("retro-water.png");
        choiceEconCost.add(new Integer(2));
        choiceSocialCost.add(new Integer(2));
        choices.add("Both");
        choiceIcons.add("retro-both.png");
        choiceEconCost.add(new Integer(3));
        choiceSocialCost.add(new Integer(3));
        c.setAttribute("choices", choices);
        c.setAttribute("choiceLegendIcons", choiceIcons);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        this.addConfigParameter(c);
        c = new ConfigParameter("Low-Income Grants", "boolean", "grants", "lowIncomeGrants");
        this.setAttribute("lowIncomeGrants", false);
        c.setAttribute("legendIcon", "retro-grants.png");
        c.setAttribute("dEconCost", 2.0f);
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        String attribute;
        int i;
        super.enact(root);
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        Layer layer = root.getScenario().getMap().getLayer("hazard");
        String hazard = (String)this.getObjectAttribute("mitigatedHazard");
        String[] lu = Main.luNames;
        if (this.isSet("targetHouses")) {
            proplayer.setAttribute("RetroHouse", true);
        }
        if (this.isSet("targetHotels")) {
            proplayer.setAttribute("RetroHotel", true);
        }
        if (this.isSet("targetStores")) {
            proplayer.setAttribute("RetroStore", true);
        }
        if (this.isSet("lowIncomeGrants")) {
            proplayer.setAttribute("RetroGrants", true);
        }
        if ("Wind".equals(hazard) || "Both".equals(hazard)) {
            proplayer.setAttribute("RetroWind", true);
            for (i = 0; i < lu.length; ++i) {
                attribute = lu[i] + "WindVulnerability";
                layer.incrementAttribute(attribute, -0.05f);
                StringBuffer stringBuffer = new StringBuffer();
                if (this.getAttribute(stringBuffer.append("target").append(StringUtils.capitalize(lu[i])).append("s").toString(), 0.0f) > 0.0f) {
                    layer.incrementAttribute(attribute, -0.05f);
                }
                if (!this.isSet("lowIncomeGrants")) continue;
                layer.incrementAttribute(attribute, -0.05f);
            }
        }
        if ("Water".equals(hazard) || "Both".equals(hazard)) {
            proplayer.setAttribute("RetroWater", true);
            for (i = 0; i < lu.length; ++i) {
                attribute = lu[i] + "WaterVulnerability";
                layer.incrementAttribute(attribute, -0.05f);
                StringBuffer stringBuffer = new StringBuffer();
                if (this.getAttribute(stringBuffer.append("target").append(StringUtils.capitalize(lu[i])).append("s").toString(), 0.0f) > 0.0f) {
                    layer.incrementAttribute(attribute, -0.05f);
                }
                if (!this.isSet("lowIncomeGrants")) continue;
                layer.incrementAttribute(attribute, -0.05f);
            }
        }
    }
}

