/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class Sewers
extends Proposal {
    public Sewers() {
        this.setTitle("Municipal Sewer Reform");
        this.setFamily("Sewers");
        this.setDescription("Revise and update water and sewer policies");
        this.setTurn(1);
        this.setAttribute("tocName", "Sewers");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 2.0f);
        this.setAttribute("debriefingStart", "Sewer reform affects growth in a very indirect way, by discouraging development outside the provisioning area.");
        this.setAttribute("debriefingEnd", " ");
        ConfigParameter c = new ConfigParameter("Improve Facilities", "boolean", "plant", "improveFacilities");
        this.setAttribute("improveFacilities", false);
        c.setAttribute("mapIcon", "ws-facilities.png");
        c.setAttribute("dEconCost", 3.0f);
        c.setAttribute("debriefingText", "Improved facilities make the city more appealing to potential residents.");
        this.addConfigParameter(c);
        c = new ConfigParameter("Restrict Septic Tanks", "boolean", "septic", "restrictSeptic");
        this.setAttribute("restrictSeptic", false);
        c.setAttribute("legendIcon", "no-septic.png");
        c.setAttribute("dSocialCost", 2.0f);
        c.setAttribute("debriefingText", "Restricting septic tanks enhances the limiting effects of provisioning.");
        this.addConfigParameter(c);
        c = new ConfigParameter("Provisioning", "choice", "[description]", "provisioning");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<String> choiceIcons = new ArrayList<String>();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList<String> debriefingTexts = new ArrayList<String>();
        this.setAttribute("provisioning", "Status Quo");
        choices.add("Liberal");
        choiceIcons.add("ws-liberal.png");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(1));
        debriefingTexts.add("Liberal provisioning contributes to sprawl and commits the city to large future support costs.");
        choices.add("Status Quo");
        choiceIcons.add("ws-statusquo.png");
        choiceEconCost.add(new Integer(0));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add(" ");
        choices.add("Restrictive");
        choiceIcons.add("ws-restrictive.png");
        choiceEconCost.add(new Integer(0));
        choiceSocialCost.add(new Integer(3));
        debriefingTexts.add("Restrictive provisioning encourages urban infill.");
        c.setAttribute("choices", choices);
        c.setAttribute("choiceMapIcons", choiceIcons);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        c.setAttribute("debriefingTexts", debriefingTexts);
        this.addConfigParameter(c);
        this.setAttribute("debriefingEnd", " ");
    }

    public void enact(GameRoot root, Random rng) {
        MapCell cell;
        Iterator iter;
        ArrayList targets;
        String zone;
        super.enact(root);
        Map map = root.getScenario().getMap();
        Layer hazard = map.getLayer("hazard");
        hazard.incrementAttribute("waterExposureBonus", -0.1f);
        Layer layer = map.getLayer("landuse");
        layer.incrementAttribute("ecologyBonus", 0.1f);
        Layer proplayer = map.getLayer("proposals");
        if (this.getAttribute("improveFacilities", 0.0f) > 0.0f) {
            proplayer.setAttribute("SewagePlant", true);
            layer.incrementAttribute("condo", 0.1f);
            layer.incrementAttribute("house", 0.1f);
        }
        if ("Status Quo".equals(zone = (String)this.getObjectAttribute("provisioning"))) {
            // empty if block
        }
        if ("Liberal".equals(zone)) {
            root.getScenario().incrementAttribute("econBonus", -2.0f);
            targets = map.getCells(new String[]{"<4,2>", "<7,4>", "<8,4>", "<7,5>", "<8,5>", "<9,5>", "<8,6>", "<9,6>", "<9,7>", "<8,8>", "<9,8>"});
            iter = targets.iterator();
            while (iter.hasNext()) {
                cell = (MapCell)iter.next();
                cell.setAttribute("noSewer", layer, 0.0f);
            }
        }
        if ("Restrictive".equals(zone)) {
            targets = map.getCells(new String[]{"<3,3>", "<6,5>", "<6,6>", "<7,6>", "<6,7>", "<7,7>", "<8,7>", "<6,8>", "<7,8>"});
            iter = targets.iterator();
            while (iter.hasNext()) {
                cell = (MapCell)iter.next();
                cell.setAttribute("noSewer", layer, 1.0f);
            }
        }
        if (this.getAttribute("restrictSeptic", 0.0f) > 0.0f) {
            proplayer.setAttribute("RestrictSeptic", true);
            Iterator iter2 = map.getCells().iterator();
            while (iter2.hasNext()) {
                MapCell cell2 = (MapCell)iter2.next();
                if (!(cell2.getAttribute("noSewer", layer, 0.0f) > 0.0f)) continue;
                cell2.setAttribute("relocate", layer, "<2,7>");
            }
        }
    }
}

