/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn1;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class Waterfront
extends Proposal {
    public Waterfront() {
        this.setTitle("Revitalize Waterfront");
        this.setFamily("Waterfront");
        this.setDescription("Redevelop the industrial waterfront area");
        this.setTurn(1);
        this.setAttribute("tocName", "Wtrfnt");
        this.setAttribute("mapIcon", "waterfront-plaza.png");
        this.setAttribute("baseEconCost", 6.0f);
        this.setAttribute("baseSocialCost", 3.0f);
        this.setAttribute("debriefingText", "Revitalizing the downtown waterfront bolsters tourism and creates jobs, improving the local economy.");
        ConfigParameter c = new ConfigParameter("Public Facilities", "boolean", "pier", "publicFacilities");
        this.setAttribute("publicFacilities", false);
        c.setAttribute("mapIcon", "waterfront-pier.png");
        c.setAttribute("dEconCost", 2.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Relax Regulations", "boolean", "relax", "relaxRegulations");
        this.setAttribute("relaxRegulations", false);
        c.setAttribute("legendIcon", "relax-regs.png");
        c.setAttribute("dEconCost", -2.0f);
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        layer.incrementAttribute("hotel", 0.1f);
        layer.incrementAttribute("store", 0.1f);
        if (this.getAttribute("relaxRegulations", 0.0f) > 0.0f) {
            layer.incrementAttribute("growth", 0.05f);
            proplayer.setAttribute("DumbGrowth", true);
        }
        if (this.getAttribute("publicFacilities", 0.0f) > 0.0f) {
            proplayer.setAttribute("Pier", true);
            layer.incrementAttribute("hotel", 0.1f);
        } else {
            layer.incrementAttribute("store", 0.1f);
        }
    }
}

