/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn2;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Random;

public class Buyout
extends Proposal {
    public Buyout() {
        this.setTitle("Property Buyout");
        this.setFamily("Buyout");
        this.setDescription("Convert damaged property to open space");
        this.setTurn(2);
        this.setAttribute("tocName", "Buyout");
        this.setAttribute("baseEconCost", 8.0f);
        this.setAttribute("baseSocialCost", 3.0f);
        this.setAttribute("legendIcon", "buyout.png");
        this.setAttribute("debriefingStart", "Although it's unpopular with property owners, sometimes the best way to make a site safe is not to rebuild.");
        ConfigParameter c = new ConfigParameter("Condemn", "boolean", "condemn", "condemn");
        this.setAttribute("condemn", false);
        c.setAttribute("dEconCost", -2.0f);
        c.setAttribute("dSocialCost", 3.0f);
        c.setAttribute("debriefingText", " Condemning property makes land-use changes more affordable monetarily, but the ill-will generated can be long-lasting.");
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Map map = root.getScenario().getMap();
        Layer layer = map.getLayer("landuse");
        Layer hazard = map.getLayer("hazard");
        Layer proplayer = map.getLayer("proposals");
        Iterator iter = map.getCells().iterator();
        class Destroyed {
            public MapCell cell;
            public int site;
            public String type;
            public boolean openspace;
            public float damage;

            Destroyed() {
            }
        }
        ArrayList<Destroyed> sites = new ArrayList<Destroyed>();
        float wind = hazard.getAttribute("wind", 0.5f);
        if (this.isSet("condemn")) {
            proplayer.setAttribute("Condemn", true);
            root.getScenario().incrementAttribute("socialBonus", -1.0f);
        }
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            float water = cell.getAttribute("water", hazard, 0.0f);
            ArrayList lu = (ArrayList)map.getObjectAttribute("landuse", cell, "luArray");
            ArrayList oldLu = (ArrayList)map.getObjectAttribute("landusePreHurricane", cell, "luArray");
            for (int i = 0; i < lu.size(); ++i) {
                if (!"destroyed".equals(lu.get(i))) continue;
                Destroyed d = new Destroyed();
                d.cell = cell;
                d.site = i;
                d.type = (String)oldLu.get(i);
                d.openspace = cell.getAttribute("openspace", layer, 0.0f) > 0.0f;
                d.damage = wind * hazard.getAttribute(d.type + "WindVulnerability", 0.0f);
                d.damage += water * hazard.getAttribute(d.type + "WaterVulnerability", 0.0f);
                sites.add(d);
            }
        }
        Collections.shuffle(sites, rng);
        Collections.sort(sites, new Comparator(){

            public int compare(Object a, Object b) {
                Destroyed x = (Destroyed)a;
                Destroyed y = (Destroyed)b;
                if (x.damage == y.damage) {
                    if (x.openspace) {
                        return y.openspace ? 0 : 1;
                    }
                    return y.openspace ? -1 : 0;
                }
                return x.damage > y.damage ? 1 : -1;
            }
        });
        Collections.reverse(sites);
        int count = 20;
        for (int i = 0; count > 0 && i < sites.size(); ++i, --count) {
            Destroyed d = (Destroyed)sites.get(i);
            ((ArrayList)map.getObjectAttribute("landuse", d.cell, "luArray")).set(d.site, "openspace");
        }
    }
}

