/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn2;

import dd.hurricane.LanduseManager;
import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class Downtown
extends Proposal {
    public static final String[] downtownSites = new String[]{"<1,7>", "<2,6>", "<2,7>"};

    public Downtown() {
        this.setTitle("Rebuild Downtown");
        this.setFamily("Downtown");
        this.setDescription("Rebuild the town's urban core");
        this.setTurn(2);
        this.setAttribute("tocName", "Dntown");
        this.setAttribute("baseEconCost", 6.0f);
        this.setAttribute("baseSocialCost", 0.0f);
        this.setAttribute("mapIcon", "downtown.png");
        this.setAttribute("debriefingStart", "A slow post-disaster recovery can spell doom for many small businesses.  Rebuilding the town's economic core helps strengthen it against future disruptions.");
        ConfigParameter c = new ConfigParameter("Mixed-Use Redevelopment", "boolean", "mixed-use", "mixedUse");
        c.setAttribute("legendIcon", "downtown-mixed.png");
        this.setAttribute("mixedUse", false);
        c.setAttribute("dEconCost", 1.0f);
        c.setAttribute("dSocialCost", 4.0f);
        c.setAttribute("debriefingText", " Allowing mixed-use development has a significant effect on a town's character, and helps to maintain a diverse and healthy mix of landuses.");
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        if (this.getAttribute("mixedUse", 0.0f) > 0.0f) {
            proplayer.setAttribute("MixedUse", true);
        }
        Map map = root.getScenario().getMap();
        Layer layer = map.getLayer("landuse");
        ArrayList targets = map.getCells(downtownSites);
        LanduseManager.rebuild(root, "landusePreHurricane", targets);
        if (this.getAttribute("mixedUse", 0.0f) > 0.0f) {
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                MapCell cell = (MapCell)iter.next();
                cell.setAttribute("mixedUse", layer, 1.0f);
            }
        }
    }
}

