/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn2;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Random;

public class EOC
extends Proposal {
    public EOC() {
        this.setTitle("Improve EOC");
        this.setFamily("EOC");
        this.setDescription("Improve the Emergency Operations Center");
        this.setTurn(2);
        this.setAttribute("tocName", "EOC");
        this.setAttribute("baseEconCost", 1.0f);
        this.setAttribute("baseSocialCost", 1.0f);
        this.setAttribute("debriefingText", "The Emergency Operations Center is crucial to effective disaster managment, so protecting it makes the town safer.");
        ConfigParameter c = new ConfigParameter("Strategy", "choice", "[description]", "strategy");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<String> choiceIcons = new ArrayList<String>();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        this.setAttribute("strategy", "Relocate");
        choices.add("Relocate");
        choiceIcons.add("eoc-relocate.png");
        choiceEconCost.add(new Integer(3));
        choiceSocialCost.add(new Integer(1));
        choices.add("BSA");
        choiceIcons.add("eoc-bsa.png");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(4));
        c.setAttribute("choices", choices);
        c.setAttribute("choiceLegendIcons", choiceIcons);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer hazard = root.getScenario().getMap().getLayer("hazard");
        hazard.incrementAttribute("waterExposureBonus", -0.05f);
        hazard.incrementAttribute("wind", -0.05f);
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        String strategy = (String)this.getObjectAttribute("strategy");
        if ("BSA".equals(strategy)) {
            proplayer.setAttribute("BSA", true);
        }
    }
}

