/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn2;

import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class Seawall
extends Proposal {
    public Seawall() {
        this.setTitle("Build Seawall");
        this.setFamily("Seawall");
        this.setDescription("Protect the city with a seawall");
        this.setTurn(2);
        this.setAttribute("tocName", "Seawall");
        this.setAttribute("baseEconCost", 5.0f);
        this.setAttribute("baseSocialCost", 3.0f);
        this.setAttribute("debriefingText", "Although seawalls are generally effective at protecting buildings, they nearly always have unanticipated erosional consequences.");
        this.setAttribute("mapIcon", "seawall.png");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Map map = root.getScenario().getMap();
        Layer hazard = map.getLayer("hazard");
        ArrayList targets = map.getCells(new String[]{"<1,7>", "<1,8>", "<2,6>", "<2,8>"});
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            MapCell cell = (MapCell)iter.next();
            cell.setAttribute("water", hazard, 0.2f);
        }
    }
}

