/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class Center
extends Proposal {
    public Center() {
        this.setTitle("Community Center");
        this.setFamily("Center");
        this.setDescription("Build a shiny new community center.");
        this.setTurn(3);
        this.setAttribute("tocName", "ComCtr");
        this.setAttribute("baseEconCost", 4.0f);
        this.setAttribute("baseSocialCost", 2.0f);
        this.setAttribute("debriefingText", "Like most public amenities, a community center costs money but creates political goodwill.  Additions to the center that provide benefits to under-served groups help to counteract problems rooted in land-use imbalance.");
        ConfigParameter c = new ConfigParameter("Library", "boolean", "library", "library");
        this.setAttribute("library", false);
        c.setAttribute("dEconCost", 2.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Public Space", "boolean", "publicSpace", "publicSpace");
        this.setAttribute("publicSpace", false);
        c.setAttribute("dEconCost", 1.0f);
        c.setAttribute("dSocialCost", 1.0f);
        this.addConfigParameter(c);
        c = new ConfigParameter("Water Park", "boolean", "waterPark", "waterPark");
        this.setAttribute("waterPark", false);
        c.setAttribute("dEconCost", 2.0f);
        this.addConfigParameter(c);
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        Layer proplayer = root.getScenario().getMap().getLayer("proposals");
        Layer problayer = root.getScenario().getMap().getLayer("problems");
        root.getScenario().incrementAttribute("socialBonus", 1.0f);
        root.getScenario().incrementAttribute("econBonus", -1.0f);
        if (this.isSet("waterPark")) {
            proplayer.setAttribute("WaterPark", true);
            problayer.incrementAttribute("weakJobMarket", 1.0f);
        }
        if (this.isSet("publicSpace")) {
            proplayer.setAttribute("PublicSpace", true);
            problayer.incrementAttribute("soaringLandValues", 1.0f);
        }
        if (this.isSet("library")) {
            proplayer.setAttribute("Library", true);
            problayer.incrementAttribute("overcommercialization", 1.0f);
        }
    }
}

