/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.hurricane.LanduseManager;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class LowerHousingStandards
extends Proposal {
    public LowerHousingStandards() {
        this.setTitle("Lower Housing Standards");
        this.setFamily("LowerHousingStandards");
        this.setDescription("Allow less-fancy houses");
        this.setTurn(3);
        this.setAttribute("tocName", "LowStd");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 5.0f);
        this.setAttribute("debriefingText", "Rising land values create a lack of affordable housing; the creation of smaller dwellings with few amenities returns low-cost housing to the market, solving the problem -- at least for now.");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        root.getScenario().getMap().getLayer("problems").incrementAttribute("soaringLandValues", 2.0f);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        layer.incrementAttribute("house", 0.05f);
        layer.incrementAttribute("condo", -0.05f);
        LanduseManager.convert(root, rng, "condo", "house", 0.05);
        LanduseManager.convert(root, rng, "hotel", "house", 0.05);
    }
}

