/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Random;

public class MosquitoControl
extends Proposal {
    public MosquitoControl() {
        this.setTitle("Mosquito Control");
        this.setFamily("MosquitoControl");
        this.setDescription("Reduce mosquito population");
        this.setTurn(3);
        this.setAttribute("tocName", "MosCtl");
        this.setAttribute("baseEconCost", 2.0f);
        this.setAttribute("baseSocialCost", 0.0f);
        this.setAttribute("debriefingStart", "Reducing the mosquito population is effective in preventing outbreaks of blood-borne diseases.");
        ConfigParameter c = new ConfigParameter("Strategy", "choice", "[description]", "strategy");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList<String> debriefingTexts = new ArrayList<String>();
        this.setAttribute("strategy", "Insecticide Fogging");
        choices.add("Insecticide Fogging");
        choiceEconCost.add(new Integer(0));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add("Spraying with pesticides is an option that works, but it has undesirable ecological side-effects.");
        choices.add("Bio-larvicide");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add("Bio-larvicides are more expensive than fogging, but have no known side-effects.");
        c.setAttribute("choices", choices);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        c.setAttribute("debriefingTexts", debriefingTexts);
        this.addConfigParameter(c);
        this.setAttribute("debriefingEnd", "");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        root.getScenario().incrementAttribute("econBonus", -1.0f);
        String strategy = (String)this.getObjectAttribute("strategy");
        if ("Insecticide Fogging".equals(strategy)) {
            Layer layer = root.getScenario().getMap().getLayer("landuse");
            layer.incrementAttribute("ecologyBonus", -0.05f);
        }
        root.getScenario().getMap().getLayer("problems").incrementAttribute("blackSwanVirus", 1.0f);
    }
}

