/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class RaisePropertyTaxes
extends Proposal {
    public RaisePropertyTaxes() {
        this.setTitle("Raise Property Taxes");
        this.setFamily("RaisePropertyTaxes");
        this.setDescription("Slow growth with taxes");
        this.setTurn(3);
        this.setAttribute("tocName", "PropTax");
        this.setAttribute("baseEconCost", -1.0f);
        this.setAttribute("baseSocialCost", 4.0f);
        this.setAttribute("debriefingText", "Though it doesn't create more jobs, using taxes to slow housing growth does help to address the structural imbalances that lead to a weak job market.  Naturally, the extra money due to tax increases comes at the cost of political goodwill.");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        layer.incrementAttribute("house", -0.15f);
        layer.incrementAttribute("condo", -0.15f);
        root.getScenario().incrementAttribute("econBonus", 3.0f);
        root.getScenario().incrementAttribute("socialBonus", -3.0f);
        root.getScenario().getMap().getLayer("problems").incrementAttribute("weakJobMarket", 1.0f);
    }
}

