/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Proposal;
import java.util.Random;

public class RaiseSalesTax
extends Proposal {
    public RaiseSalesTax() {
        this.setTitle("Raise Sales Tax");
        this.setFamily("RaiseSalesTax");
        this.setDescription("Slow growth with taxes");
        this.setTurn(3);
        this.setAttribute("tocName", "SalesTx");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 3.0f);
        this.setAttribute("debriefingText", "Raising sales taxes slows economic growth and thereby helps to address the structural imbalances that lead to overcommercialization.  Though it provides extra funds to work with, they come at the expense of political goodwill.");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Layer layer = root.getScenario().getMap().getLayer("landuse");
        layer.incrementAttribute("hotel", -0.1f);
        layer.incrementAttribute("store", -0.1f);
        root.getScenario().incrementAttribute("econBonus", 2.0f);
        root.getScenario().incrementAttribute("socialBonus", -2.0f);
        root.getScenario().getMap().getLayer("problems").incrementAttribute("overcommercialization", 1.0f);
    }
}

