/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Random;

public class RemediationAssistance
extends Proposal {
    public RemediationAssistance() {
        this.setTitle("Remediation Assistance");
        this.setFamily("RemediationAssistance");
        this.setDescription("Help pay for cleanup");
        this.setTurn(3);
        this.setAttribute("tocName", "RemAsst");
        this.setAttribute("baseEconCost", 2.0f);
        this.setAttribute("baseSocialCost", 1.0f);
        this.setAttribute("debriefingStart", "");
        ConfigParameter c = new ConfigParameter("Assistance", "choice", "[description]", "assistance");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList choiceIcons = new ArrayList();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList<String> debriefingTexts = new ArrayList<String>();
        this.setAttribute("assistance", "Cleanup");
        choices.add("Cleanup");
        choiceEconCost.add(new Integer(2));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add("Helping with spill cleanup relieves the manufacturer of some of the economic burden of dealing with it, but does nothing to prevent the problem in the future.");
        choices.add("Drainage");
        choiceEconCost.add(new Integer(2));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add("Improving the industrial park's drainage system is costly, but prevents the runoff problem from recurring. Cleanup costs are still large.");
        choices.add("Both");
        choiceEconCost.add(new Integer(4));
        choiceSocialCost.add(new Integer(0));
        debriefingTexts.add("Although very expensive, helping the manufacturer both with cleanup and with a drainage system that will prevent future problems builds strong ties between town and industry.");
        c.setAttribute("choices", choices);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        c.setAttribute("debriefingTexts", debriefingTexts);
        this.addConfigParameter(c);
        this.setAttribute("debriefingEnd", "");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        String assistance = (String)this.getObjectAttribute("assistance");
        if ("Cleanup".equals(assistance) || "Drainage".equals(assistance)) {
            root.getScenario().getMap().getLayer("problems").incrementAttribute("industrialRunoff");
        } else {
            root.getScenario().getMap().getLayer("problems").incrementAttribute("industrialRunoff", 2.0f);
        }
    }
}

