/*
 * Decompiled with CFR 0.152.
 */
package dd.hurricane.proposals.turn3;

import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.Proposal;
import java.util.ArrayList;
import java.util.Random;

public class RestrictPermits
extends Proposal {
    public RestrictPermits() {
        this.setTitle("Restrict Permits");
        this.setFamily("RestrictPermits");
        this.setDescription("Limit business licences");
        this.setTurn(3);
        this.setAttribute("tocName", "NoPermit");
        this.setAttribute("baseEconCost", 0.0f);
        this.setAttribute("baseSocialCost", 2.0f);
        this.setAttribute("debriefingStart", "");
        ConfigParameter c = new ConfigParameter("Restrictions", "choice", "[description]", "restrictions");
        ArrayList<String> choices = new ArrayList<String>();
        ArrayList choiceIcons = new ArrayList();
        ArrayList<Integer> choiceEconCost = new ArrayList<Integer>();
        ArrayList<Integer> choiceSocialCost = new ArrayList<Integer>();
        ArrayList<String> debriefingTexts = new ArrayList<String>();
        this.setAttribute("restrictions", "New");
        choices.add("New");
        choiceEconCost.add(new Integer(0));
        choiceSocialCost.add(new Integer(1));
        debriefingTexts.add("Restricting development permits curbs commercial growth, stabilizing the imbalance that leads to overcommercialization.");
        choices.add("Existing");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(2));
        debriefingTexts.add("Applying limits to the existing sales tax permits improves the makeup of the town, but weakens the local economy somewhat.");
        choices.add("Both");
        choiceEconCost.add(new Integer(1));
        choiceSocialCost.add(new Integer(3));
        debriefingTexts.add("Restricting development permits curbs commercial growth, while applying limits to the existing sales tax permits adjusts the makeup of the town.  In combination, they rectify the imbalance that drives overcommercialization, but not without some weakening of the local economy.");
        c.setAttribute("choices", choices);
        c.setAttribute("choiceDECost", choiceEconCost);
        c.setAttribute("choiceDSCost", choiceSocialCost);
        c.setAttribute("debriefingTexts", debriefingTexts);
        this.addConfigParameter(c);
        this.setAttribute("debriefingEnd", "  This action also results in the loss of political capitol.");
    }

    public void enact(GameRoot root, Random rng) {
        super.enact(root);
        Map map = root.getScenario().getMap();
        Layer layer = map.getLayer("landuse");
        Layer propLayer = map.getLayer("proposals");
        String option = (String)this.getObjectAttribute("restrictions");
        if ("New".equals(option) || "Both".equals(option)) {
            layer.incrementAttribute("hotel", -0.1f);
            layer.incrementAttribute("store", -0.1f);
            root.getScenario().incrementAttribute("socialBonus", -1.0f);
            map.getLayer("problems").incrementAttribute("overcommercialization", 1.0f);
        }
        if ("Existing".equals(option) || "Both".equals(option)) {
            root.getScenario().incrementAttribute("socialBonus", -1.0f);
            map.getLayer("problems").incrementAttribute("overcommercialization", 1.0f);
            propLayer.setAttribute("RestrictExistingPermits", true);
        }
    }
}

