/*
 * Decompiled with CFR 0.152.
 */
package dd.net;

import dd.net.Client;
import dd.net.Handler;
import dd.net.NetServer;
import dd.net.TurnServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class GameServer {
    private List players;
    private HashMap actions;
    protected NetServer server;
    protected HashMap games;
    private String gameName;

    public GameServer(NetServer owner) {
        this.server = owner;
        this.actions = new HashMap();
        this.players = new ArrayList();
        this.games = new HashMap();
        this.gameName = "Lobby";
        this.setupDefaultActions();
    }

    public String getGameName() {
        return this.gameName;
    }

    public void setGameName(String name) {
        this.gameName = name;
    }

    public boolean isFull() {
        return false;
    }

    public void addGame(String gameName, GameServer game) {
        this.games.put(gameName, game);
    }

    public void addPlayer(Client c) {
        this.players.add(c);
    }

    public boolean reconnectPlayer(Client c, int turnNumber) {
        this.addPlayer(c);
        return true;
    }

    public void lostClient(Client c) {
    }

    public List getPlayers() {
        return new ArrayList();
    }

    public synchronized void broadcast(String message) {
        Iterator i = this.players.iterator();
        while (i.hasNext()) {
            Client c = (Client)i.next();
            c.sendMessage(message);
        }
    }

    public void addHandler(String commandName, Handler handler) {
        this.actions.put(commandName, handler);
    }

    public void setupDefaultActions() {
        this.addHandler("AYT", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.sendMessage("[yes]");
            }
        });
        this.addHandler("[yes]", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
            }
        });
        this.addHandler("[none]", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.sendMessage("AYT");
                try {
                    cl.getReader().readLine();
                }
                catch (IOException e) {
                    cl.stopRunning();
                }
            }
        });
        this.addHandler("bye", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.stopRunning();
            }
        });
        this.addHandler("bcast", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                GameServer.this.broadcast(m);
            }
        });
        this.addHandler("reconnect", new ReconnectHandler());
        this.addHandler("register", new RegisterHandler());
        this.addHandler("chat", new BroadcastHandler());
        this.addHandler("enableUI", new BroadcastHandler());
        this.addHandler("disableUI", new BroadcastHandler());
        this.addHandler("ListGames", new ListGamesHandler());
        this.addHandler("JoinGame", new JoinGameHandler());
        this.addHandler("ReJoinGame", new ReJoinGameHandler());
        this.addHandler("CreateNewGame", new CreateNewGameHandler());
        this.addHandler("quit", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                GameServer.this.broadcast("bye");
                GameServer.this.server.stopRunning();
            }
        });
        this.addHandler("_defaultHandler", new DefaultHandler());
    }

    public synchronized void handleMessage(String message, Client c) {
        StringTokenizer st = new StringTokenizer(message);
        if (st.hasMoreTokens()) {
            String commandWord = st.nextToken();
            int firstSpace = message.indexOf(32) + 1;
            message = firstSpace == 0 ? "" : message.substring(firstSpace);
            Handler h = (Handler)this.actions.get(commandWord);
            if (h == null) {
                h = (Handler)this.actions.get("_defaultHandler");
            }
            h.gotCommand(commandWord, message, c);
        }
    }

    class CreateNewGameHandler
    implements Handler {
        CreateNewGameHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            if (message.length() > 30 || message.indexOf(124) >= 0) {
                c.sendMessage("ErrorMessage That is not a valid game name");
                return;
            }
            if (GameServer.this.games.containsKey(message)) {
                c.sendMessage("ErrorMessage A game with that name already exists");
                return;
            }
            try {
                TurnServer game = new TurnServer(GameServer.this.server, false);
                game.setGameName(message);
                GameServer.this.games.put(message, game);
                c.setGame(game);
                game.addPlayer(c);
                c.sendMessage("JoinedGame");
            }
            catch (Exception e) {
                c.sendMessage("ErrorMessage Error starting game");
                e.printStackTrace();
            }
        }
    }

    class ReJoinGameHandler
    implements Handler {
        ReJoinGameHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            int turnNumber = Integer.parseInt(stok.nextToken());
            String gameName = stok.nextToken();
            GameServer game = (GameServer)GameServer.this.games.get(gameName);
            if (game == null) {
                c.sendMessage("ErrorMessage There is no such game");
                return;
            }
            if (game.reconnectPlayer(c, turnNumber)) {
                c.setGame(game);
            }
        }
    }

    class JoinGameHandler
    implements Handler {
        JoinGameHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            GameServer game = (GameServer)GameServer.this.games.get(message);
            if (game == null) {
                c.sendMessage("ErrorMessage There is no such game");
                return;
            }
            c.setGame(game);
            game.addPlayer(c);
            c.sendMessage("JoinedGame");
        }
    }

    class ListGamesHandler
    implements Handler {
        ListGamesHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringBuffer b = new StringBuffer();
            ArrayList gameList = new ArrayList(GameServer.this.games.keySet());
            Collections.sort(gameList);
            Iterator iter = gameList.iterator();
            int itemCount = 0;
            b.append('|');
            while (iter.hasNext()) {
                String gameName = (String)iter.next();
                ++itemCount;
                GameServer server = (GameServer)GameServer.this.games.get(gameName);
                b.append(server.getGameName());
                b.append('|');
                Iterator players = server.getPlayers().iterator();
                while (players.hasNext()) {
                    ++itemCount;
                    b.append(players.next());
                    b.append('|');
                }
            }
            c.sendMessage("GameList " + itemCount + b.toString());
        }
    }

    class RegisterHandler
    implements Handler {
        RegisterHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            GameServer.this.server.handleRegister(command, message, c);
        }
    }

    class ReconnectHandler
    implements Handler {
        ReconnectHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            GameServer.this.server.handleReconnect(command, message, c);
        }
    }

    class BroadcastHandler
    implements Handler {
        BroadcastHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            GameServer.this.broadcast(command + " " + message);
        }
    }

    class DefaultHandler
    implements Handler {
        DefaultHandler() {
        }

        public void gotCommand(String commandName, String message, Client client) {
            GameServer.this.server.log.warning("Unknown command: [" + commandName + "] message: [" + message + "] client: " + client);
        }
    }
}

