/*
 * Decompiled with CFR 0.152.
 */
package dd.net;

import dd.net.Client;
import dd.net.GameServer;
import dd.net.Handler;
import dd.net.Venue;
import dd.util.Chat;
import dd.util.Logger;
import dd.util.UI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NetClient
implements Runnable,
Client,
Chat {
    private Logger log = Logger.getDefaultLog();
    public static final long ALIVE_PERIOD = 10000L;
    public static final String DEFAULT_SERVER = "127.0.0.1";
    public static final String DISCOVERY_URL = "http://www.dd.ucar.edu/cgi/listVenues";
    private Map actions;
    private Thread commandThread;
    private Socket mainSocket;
    private Chat chatClient;
    protected UI uiClient;
    private String myName;
    private BufferedReader serverInput;
    private PrintWriter serverOutput;
    private int aytCount;
    private boolean running;
    private boolean clientRegistered = false;

    public NetClient() throws IOException {
        this(DEFAULT_SERVER);
    }

    public NetClient(String serverName) throws IOException {
        this(serverName, 9999);
    }

    public NetClient(String serverName, int port) throws IOException {
        this.mainSocket = new Socket(serverName, port);
        this.actions = new HashMap();
        this.setupDefaultActions();
        this.serverInput = new BufferedReader(new InputStreamReader(this.mainSocket.getInputStream()));
        this.serverOutput = new PrintWriter(this.mainSocket.getOutputStream());
        this.startRunning();
    }

    public void startRunning() {
        this.running = true;
        this.commandThread = new Thread(this);
        this.commandThread.start();
    }

    public void stopRunning() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getClientName() {
        return this.myName;
    }

    public void setClientName(String name) {
        this.sendMessage("register  [" + name + "]");
        this.myName = name;
        this.clientRegistered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block16: {
            while (this.running) {
                this.log.debug("Client main loop");
                String commandLine = this.serverInput.readLine();
                this.log.debug("Client got command: " + commandLine);
                if (commandLine == null) {
                    this.running = false;
                    continue;
                }
                this.handleMessage(commandLine);
            }
            Object var4_2 = null;
            try {
                this.log.log("Closing client");
                this.mainSocket.close();
                if (this.uiClient != null) {
                    this.uiClient.lostServer();
                }
                break block16;
            }
            catch (IOException ignored) {
                this.log.error(ignored.toString());
            }
            break block16;
            {
                catch (IOException e) {
                    this.log.error("Server read error: " + e);
                    Object var4_3 = null;
                    try {
                        this.log.log("Closing client");
                        this.mainSocket.close();
                        if (this.uiClient != null) {
                            this.uiClient.lostServer();
                        }
                        break block16;
                    }
                    catch (IOException ignored) {
                        this.log.error(ignored.toString());
                    }
                    break block16;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.log.error("Something awful happened: " + t);
                    Object var4_4 = null;
                    try {
                        this.log.log("Closing client");
                        this.mainSocket.close();
                        if (this.uiClient != null) {
                            this.uiClient.lostServer();
                        }
                        break block16;
                    }
                    catch (IOException ignored) {
                        this.log.error(ignored.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    this.log.log("Closing client");
                    this.mainSocket.close();
                    if (this.uiClient != null) {
                        this.uiClient.lostServer();
                    }
                }
                catch (IOException ignored) {
                    this.log.error(ignored.toString());
                }
                throw throwable;
            }
        }
    }

    public void handleMessage(String message) {
        StringTokenizer st = new StringTokenizer(message);
        if (st.hasMoreTokens()) {
            String commandWord = st.nextToken();
            int firstSpace = message.indexOf(32) + 1;
            message = firstSpace == 0 ? "" : message.substring(firstSpace);
            Handler h = (Handler)this.actions.get(commandWord);
            if (h == null) {
                h = (Handler)this.actions.get("_defaultHandler");
            }
            h.gotCommand(commandWord, message, this);
        }
    }

    public BufferedReader getReader() {
        return this.serverInput;
    }

    public void setChatClient(Chat client) {
        this.chatClient = client;
    }

    public void setUI(UI ui) {
        this.uiClient = ui;
    }

    public void setGame(GameServer g) {
    }

    public void sendChatMessage(String user, String message) {
        this.sendMessage("chat [" + user + "] " + message);
    }

    public void gotChatMessage(String user, String message) {
    }

    public synchronized void sendMessage(String message) {
        this.log.debug("sending message: " + message);
        this.serverOutput.println(message);
        this.serverOutput.flush();
    }

    public void addHandler(String commandName, Handler handler) {
        this.actions.put(commandName, handler);
    }

    public void setupDefaultActions() {
        this.addHandler("hello", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.setClientName("client" + m);
            }
        });
        this.addHandler("AYT", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.sendMessage("[yes]");
            }
        });
        this.addHandler("[yes]", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                NetClient.this.aytCount--;
            }
        });
        this.addHandler("bye", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                cl.stopRunning();
            }
        });
        this.addHandler("quit", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                System.exit(0);
            }
        });
        this.addHandler("disableUI", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                if (NetClient.this.uiClient != null) {
                    NetClient.this.uiClient.disableUI();
                }
            }
        });
        this.addHandler("enableUI", new Handler(){

            public void gotCommand(String c, String m, Client cl) {
                if (NetClient.this.uiClient != null) {
                    NetClient.this.uiClient.enableUI();
                }
            }
        });
        this.addHandler("chat", new ChatHandler());
        this.addHandler("_defaultHandler", new DefaultHandler());
    }

    public static List discoverVenues() {
        Logger log = Logger.getDefaultLog();
        ArrayList<Venue> v = new ArrayList<Venue>();
        try {
            String curLine;
            log.debug("Beginning server discovery");
            URL url = new URL(DISCOVERY_URL);
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((curLine = r.readLine()) != null) {
                if (curLine.equals("")) continue;
                StringTokenizer t = new StringTokenizer(curLine, "\t");
                String venueName = t.nextToken();
                String venueIP = t.nextToken();
                v.add(new Venue(venueName, venueIP));
            }
            r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return v;
    }

    public void waitUntilReady() {
        while (!this.clientRegistered) {
            Thread.yield();
        }
    }

    public static void main(String[] args) {
        try {
            NetClient nc = new NetClient();
            nc.sendMessage("AYT");
            nc.sendMessage("bcast message from client");
            nc.sendMessage("bye");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class ChatHandler
    implements Handler {
        ChatHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            int firstBracket = message.indexOf(91) + 1;
            int secondBracket = message.indexOf(93, firstBracket);
            String userName = message.substring(firstBracket, secondBracket);
            String chatMessage = message.substring(secondBracket + 1);
            if (NetClient.this.chatClient != null) {
                NetClient.this.chatClient.gotChatMessage(userName, chatMessage);
            }
        }
    }

    class DefaultHandler
    implements Handler {
        DefaultHandler() {
        }

        public void gotCommand(String commandName, String message, Client client) {
            NetClient.this.log.warning("Unknown command: [" + commandName + "] message: [" + message + "] client: " + client);
        }
    }
}

