/*
 * Decompiled with CFR 0.152.
 */
package dd.net;

import dd.net.Client;
import dd.net.GameServer;
import dd.util.Logger;
import dd.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NetServer
implements Runnable {
    public Logger log = Logger.getDefaultLog();
    public static final String DISCOVERY_URL = "http://www.dd.ucar.edu/cgi/venue";
    public static final int DEFAULT_PORT = 9999;
    private List clients;
    private HashMap clientMap;
    private HashMap defunctClientMap;
    private Thread acceptThread;
    private ServerSocket mainSocket;
    private boolean running;
    private boolean serverReady = false;
    private String venueName;
    private GameServer game;

    public NetServer() throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), 9999);
    }

    public NetServer(String serverName) throws IOException {
        this(serverName, 9999);
    }

    public NetServer(String serverName, int port) throws IOException {
        this.mainSocket = new ServerSocket(port);
        this.clients = new ArrayList();
        this.clientMap = new HashMap();
        this.defunctClientMap = new HashMap();
        this.running = true;
        this.acceptThread = new Thread(this);
        this.acceptThread.start();
    }

    public boolean registerVenue(String venueName) throws IOException {
        String url = "http://www.dd.ucar.edu/cgi/venue?gameName=" + venueName + "&gameIP=" + InetAddress.getLocalHost().getHostAddress() + "&action=start";
        this.venueName = venueName;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                NetServer.this.unregisterVenue();
            }
        }));
        URL u = new URL(StringUtils.encodeUrl(url));
        BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
        String lineOne = r.readLine();
        r.close();
        return lineOne.startsWith("OK");
    }

    public void unregisterVenue() {
        try {
            if (this.venueName == null) {
                return;
            }
            String url = "http://www.dd.ucar.edu/cgi/venue?gameName=" + this.venueName + "&gameIP=" + InetAddress.getLocalHost().getHostAddress() + "&action=stop";
            URL u = new URL(StringUtils.encodeUrl(url));
            BufferedReader r = new BufferedReader(new InputStreamReader(u.openStream()));
            String lineOne = r.readLine();
            r.close();
        }
        catch (IOException e) {
            this.log.warning("Error unregistering venue");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block11: {
            this.log.log("Starting server thread");
            while (this.running) {
                this.log.log("Server main loop");
                Socket connection = null;
                this.serverReady = true;
                this.mainSocket.setSoTimeout(10000);
                try {
                    connection = this.mainSocket.accept();
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                this.log.log("Server got client");
                ServerClient client = new ServerClient();
                client.clientSocket = connection;
                client.clientInput = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                client.clientOutput = new PrintWriter(connection.getOutputStream());
                this.addClient(client);
            }
            Object var5_5 = null;
            this.unregisterVenue();
            try {
                this.log.log("closing main socket");
                this.mainSocket.close();
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var5_6 = null;
                    this.unregisterVenue();
                    try {
                        this.log.log("closing main socket");
                        this.mainSocket.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.unregisterVenue();
                try {
                    this.log.log("closing main socket");
                    this.mainSocket.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized void addClient(ServerClient client) {
        this.log.log("About to start client");
        this.clients.add(client);
        client.setGame(this.game);
        if (this.game != null) {
            this.game.addPlayer(client);
        }
        client.startRunning();
    }

    public void setGame(GameServer g) {
        this.game = g;
    }

    public GameServer getLobby() {
        return this.game;
    }

    public synchronized void handleRegister(String command, String message, Client c) {
        String player = message.substring(message.indexOf(91) + 1, message.indexOf(93));
        if (c.getClientName() != null) {
            this.clientMap.remove(c.getClientName());
        }
        c.setClientName(player);
        this.clientMap.put(player, c);
    }

    public synchronized void handleReconnect(String command, String message, Client c) {
        String player = message.substring(message.indexOf(91) + 1, message.indexOf(93));
        Client oldClient = (Client)this.defunctClientMap.get(player);
        if (oldClient != null) {
            c.setClientName(oldClient.getClientName());
            this.clientMap.put(player, c);
        }
    }

    public synchronized void removeClient(Client client) {
        this.log.log("About to remove client");
        this.clients.remove(client);
        this.clientMap.remove(client.getClientName());
        if (client.getClientName() != null) {
            this.defunctClientMap.put(client.getClientName(), client);
        }
        client.stopRunning();
    }

    protected Iterator getClientNames() {
        return this.clientMap.keySet().iterator();
    }

    public Set getClients() {
        return new HashSet(this.clients);
    }

    public synchronized void broadcast(String message) {
        Iterator i = this.clients.iterator();
        while (i.hasNext()) {
            Client c = (Client)i.next();
            c.sendMessage(message);
        }
    }

    public synchronized void sendTo(String user, String message) {
        Client client = (Client)this.clientMap.get(user);
        if (client != null) {
            client.sendMessage(message);
        }
    }

    public synchronized boolean isReady() {
        return this.serverReady && this.game != null;
    }

    public void stopRunning() {
        this.unregisterVenue();
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public static void main(String[] args) {
        try {
            new NetServer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class ServerClient
    extends Thread
    implements Client {
        public Socket clientSocket;
        public GameServer game;
        public BufferedReader clientInput;
        public PrintWriter clientOutput;
        private boolean clientRunning;
        private String myName;

        ServerClient() {
        }

        public String getClientName() {
            return this.myName;
        }

        public void setClientName(String name) {
            this.myName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block19: {
                String commandLine = "";
                this.clientSocket.setSoTimeout(50000);
                this.sendMessage("hello " + this.hashCode());
                while (NetServer.this.running && this.clientRunning) {
                    try {
                        commandLine = "[ignore]";
                        commandLine = this.clientInput.readLine();
                    }
                    catch (SocketTimeoutException e) {
                        commandLine = this.myName == null ? "[ignore]" : "[none]";
                    }
                    NetServer.this.log.debug("Server got command: " + commandLine);
                    if (commandLine == null) {
                        this.clientRunning = false;
                        continue;
                    }
                    this.handleMessage(commandLine);
                }
                Object var4_5 = null;
                try {
                    NetServer.this.log.log("closing client");
                    this.clientSocket.close();
                }
                catch (IOException ignored) {
                    NetServer.this.log.error(ignored.toString());
                }
                if (this.game != null) {
                    this.game.lostClient(this);
                }
                NetServer.this.removeClient(this);
                {
                    break block19;
                    catch (IOException e) {
                        NetServer.this.log.error("Client read thread error: " + e);
                        e.printStackTrace();
                        Object var4_6 = null;
                        try {
                            NetServer.this.log.log("closing client");
                            this.clientSocket.close();
                        }
                        catch (IOException ignored) {
                            NetServer.this.log.error(ignored.toString());
                        }
                        if (this.game != null) {
                            this.game.lostClient(this);
                        }
                        NetServer.this.removeClient(this);
                        break block19;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        NetServer.this.log.error("Something awful happened: " + t);
                        Object var4_7 = null;
                        try {
                            NetServer.this.log.log("closing client");
                            this.clientSocket.close();
                        }
                        catch (IOException ignored) {
                            NetServer.this.log.error(ignored.toString());
                        }
                        if (this.game != null) {
                            this.game.lostClient(this);
                        }
                        NetServer.this.removeClient(this);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    try {
                        NetServer.this.log.log("closing client");
                        this.clientSocket.close();
                    }
                    catch (IOException ignored) {
                        NetServer.this.log.error(ignored.toString());
                    }
                    if (this.game != null) {
                        this.game.lostClient(this);
                    }
                    NetServer.this.removeClient(this);
                    throw throwable;
                }
            }
        }

        public void startRunning() {
            Thread t = new Thread(this);
            this.clientRunning = true;
            t.start();
        }

        public void stopRunning() {
            this.clientRunning = false;
        }

        public void setGame(GameServer g) {
            this.game = g;
        }

        public void handleMessage(String message) {
            if (this.game != null) {
                this.game.handleMessage(message, this);
            }
        }

        public void sendMessage(String message) {
            this.clientOutput.println(message);
            this.clientOutput.flush();
        }

        public BufferedReader getReader() {
            return this.clientInput;
        }
    }
}

