/*
 * Decompiled with CFR 0.152.
 */
package dd.net;

import dd.net.Client;
import dd.net.Handler;
import dd.net.NetClient;
import dd.sim.Briefing;
import dd.sim.GameRoot;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.util.DLUGUI;
import dd.util.DelimReader;
import dd.util.UI;
import java.util.StringTokenizer;

public class TurnClient
extends NetClient {
    protected String myPlayerID;
    private GameRoot root;

    public GameRoot getRoot() {
        return this.root;
    }

    public TurnClient(UI ui, String serverName) throws Exception {
        super(serverName);
        this.setUI(ui);
        this.root = new GameRoot();
    }

    public void setupDefaultActions() {
        super.setupDefaultActions();
        this.addHandler("GameList", new GameListHandler());
        this.addHandler("JoinedGame", new JoinedGameHandler());
        this.addHandler("YouArePlayer", new YouArePlayerHandler());
        this.addHandler("GameRoot", new GameRootHandler());
        this.addHandler("Briefing", new BriefingHandler());
        this.addHandler("Proposal", new ProposalHandler());
        this.addHandler("RandomProposal", new RandomProposalHandler());
        this.addHandler("Opinion", new OpinionHandler());
        this.addHandler("NotifyUser", new NotifyUserHandler());
        this.addHandler("ErrorMessage", new ErrorMessageHandler());
        this.addHandler("Done", new DoneHandler());
        this.addHandler("ResetVotingTimer", new ResetVotingTimerHandler());
        this.addHandler("Vote", new VoteHandler());
        this.addHandler("Outcome", new OutcomeHandler());
        this.addHandler("Phase", new PhaseHandler());
    }

    public void endBriefing() {
        this.sendMessage("Ready " + this.myPlayerID);
    }

    public void randomProposal() {
        this.sendMessage("RandomProposal");
    }

    public void listGames() {
        this.sendMessage("ListGames");
    }

    public void joinGame(String gameName) {
        this.sendMessage("JoinGame " + gameName);
    }

    public void rejoinGame(String gameName, int playerRequest) {
        this.sendMessage("ReJoinGame " + playerRequest + "|" + gameName);
    }

    public void joinGame(String playerName, int playerRequest) {
        this.sendMessage("JoinGame " + playerRequest + "|" + playerName);
    }

    public void createNewGame(String gameName) {
        this.sendMessage("CreateNewGame " + gameName);
    }

    public void withdraw(String proposalID) {
        this.sendMessage("Withdraw " + proposalID);
    }

    public void opinion(String proposalID, String reasoning) {
        this.sendMessage("Opinion " + this.myPlayerID + "|" + proposalID + "|" + reasoning);
    }

    public void amend(Proposal prop) {
        this.sendMessage("Amendment");
        this.sendMessage(prop.writeXML());
        this.sendMessage("**proposalDone**");
    }

    public void callForVote(String proposalID) {
        this.sendMessage("Call " + this.myPlayerID + "|" + proposalID);
    }

    public void vote(int vote) {
        this.sendMessage("Vote " + this.myPlayerID + "|" + vote);
    }

    public void votingTimerExpired() {
        this.sendMessage("VotingTimerExpired " + this.myPlayerID);
    }

    public void sendChatMessage(String user, String message) {
        this.sendMessage("chat [" + this.root.player(this.myPlayerID).getRole() + " (" + user + ")] " + message);
    }

    class PhaseHandler
    implements Handler {
        PhaseHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            String phase = stok.nextToken();
            TurnClient.this.root.setPhase(phase);
            TurnClient.this.root.resetPlayerStatus();
            if ("setup".equals(phase)) {
                ((DLUGUI)TurnClient.this.uiClient).beginSetupPhase();
                return;
            } else if ("negotiate".equals(phase)) {
                ((DLUGUI)TurnClient.this.uiClient).beginNegotiationPhase();
                return;
            } else {
                if ("vote".equals(phase)) {
                    Proposal prop = TurnClient.this.root.proposal(stok.nextToken());
                    TurnClient.this.root.setUpForVote(prop);
                    ((DLUGUI)TurnClient.this.uiClient).prepareForVotingOn(prop);
                    ((DLUGUI)TurnClient.this.uiClient).startVote();
                    String playerID = stok.nextToken();
                    if (!TurnClient.this.myPlayerID.equals(playerID)) return;
                }
                if ("done".equals(phase)) {
                    ((DLUGUI)TurnClient.this.uiClient).gameEnded();
                    return;
                } else {
                    TurnClient.this.root.warning("TurnClient has entered a mysterious and unknown phase!");
                }
            }
        }
    }

    class OutcomeHandler
    implements Handler {
        OutcomeHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            Proposal p = TurnClient.this.root.proposal(stok.nextToken());
            String status = stok.nextToken();
            String result = stok.nextToken();
            if (p == null) {
                p = new Proposal("Unknown proposal");
            }
            p.setStatus(status);
            if (status.equals("Played")) {
                p.resetVoteTally();
            }
            if (status.equals("Passed") || status.equals("Played") || status.equals("Failed")) {
                TurnClient.this.root.setUpForVote(null);
                ((DLUGUI)TurnClient.this.uiClient).endVote();
                ((DLUGUI)TurnClient.this.uiClient).notifyUser(result);
            }
            if (!"#".equals(result)) {
                ((DLUGUI)TurnClient.this.uiClient).gameMessage(p.getTitle() + ": " + result);
            }
        }
    }

    class VoteHandler
    implements Handler {
        VoteHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            Player player = TurnClient.this.root.player(stok.nextToken());
            int vote = Integer.parseInt(stok.nextToken());
            Proposal proposal = TurnClient.this.root.getUpForVote();
            TurnClient.this.root.castVote(player, proposal, vote);
        }
    }

    class ResetVotingTimerHandler
    implements Handler {
        ResetVotingTimerHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            TurnClient.this.root.resetPlayerStatus();
            ((DLUGUI)TurnClient.this.uiClient).startVotingTimer();
        }
    }

    class DoneHandler
    implements Handler {
        DoneHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            TurnClient.this.root.setPlayerStatus(message, "Done");
            ((DLUGUI)TurnClient.this.uiClient).doneNotify(TurnClient.this.root.player(message));
        }
    }

    class ErrorMessageHandler
    implements Handler {
        ErrorMessageHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            ((DLUGUI)TurnClient.this.uiClient).errorMessage(message);
        }
    }

    class NotifyUserHandler
    implements Handler {
        NotifyUserHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            ((DLUGUI)TurnClient.this.uiClient).unpauseUI();
            ((DLUGUI)TurnClient.this.uiClient).notifyUser(message);
            ((DLUGUI)TurnClient.this.uiClient).gameMessage(message);
        }
    }

    class OpinionHandler
    implements Handler {
        OpinionHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            String playerID = stok.nextToken();
            String proposalID = stok.nextToken();
            String reason = stok.nextToken();
            Player player = TurnClient.this.root.player(playerID);
            Proposal prop = TurnClient.this.root.proposal(proposalID);
            if (player == null || prop == null) {
                return;
            }
            prop.setPlayerOpinion(player, reason);
        }
    }

    class RandomProposalHandler
    implements Handler {
        RandomProposalHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            DelimReader r = new DelimReader(c.getReader(), "**proposalDone**");
            Proposal p = (Proposal)SimObject.readFromXML(r);
            p.setOwnerID(TurnClient.this.myPlayerID);
            TurnClient.this.amend(p);
        }
    }

    class ProposalHandler
    implements Handler {
        ProposalHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            DelimReader r = new DelimReader(c.getReader(), "**proposalDone**");
            Proposal p = (Proposal)SimObject.readFromXML(r);
            p.setProposalID(message);
            TurnClient.this.root.getProposalRegistry().put(message, p);
            if (p.getOwnerID().equals(TurnClient.this.myPlayerID)) {
                TurnClient.this.opinion(message, "I support this proposal");
            }
        }
    }

    class BriefingHandler
    implements Handler {
        BriefingHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            DelimReader r = new DelimReader(c.getReader(), "**briefingDone**");
            Briefing b = (Briefing)SimObject.readFromXML(r);
            TurnClient.this.root = b.getGameRoot();
            ((DLUGUI)TurnClient.this.uiClient).startBriefing(b);
            ((DLUGUI)TurnClient.this.uiClient).setRoot(TurnClient.this.root);
        }
    }

    class GameRootHandler
    implements Handler {
        GameRootHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            DelimReader r = new DelimReader(c.getReader(), "**gamerootDone**");
            TurnClient.this.root = (GameRoot)SimObject.readFromXML(r);
            ((DLUGUI)TurnClient.this.uiClient).setRoot(TurnClient.this.root);
        }
    }

    class YouArePlayerHandler
    implements Handler {
        YouArePlayerHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            ((DLUGUI)TurnClient.this.uiClient).setNumber(stok.nextToken());
            TurnClient.this.myPlayerID = stok.nextToken();
        }
    }

    class JoinedGameHandler
    implements Handler {
        JoinedGameHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            ((DLUGUI)TurnClient.this.uiClient).joinedGame();
        }
    }

    class GameListHandler
    implements Handler {
        GameListHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            int gameCount = Integer.parseInt(stok.nextToken());
            if (gameCount < 0) {
                gameCount = 0;
            }
            String[] games = new String[gameCount];
            for (int i = 0; i < gameCount; ++i) {
                games[i] = stok.nextToken();
            }
            ((DLUGUI)TurnClient.this.uiClient).availableGames(games);
        }
    }
}

