/*
 * Decompiled with CFR 0.152.
 */
package dd.net;

import dd.hurricane.Scenario;
import dd.net.Client;
import dd.net.GameServer;
import dd.net.Handler;
import dd.net.NetServer;
import dd.sim.Briefing;
import dd.sim.ConfigParameter;
import dd.sim.GameRoot;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.ui.AutoPlayer;
import dd.ui.Robot;
import dd.util.DelimReader;
import dd.util.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

public class TurnServer
extends GameServer {
    private Random rng;
    protected GameRoot root;
    private HashMap clientIDs;
    private static int nextID = 100;
    private int numPlayers;
    private Set donePlayers;
    private String callFamily;
    private boolean calling;
    private int calls;
    private ArrayList candidates;
    private static String saveDir;
    private int[][] voting;
    protected int gameSize;
    private boolean startingRobots;
    private boolean singlePlayerMode;
    private Briefing briefing;
    private static NetServer runningServer;
    private static TurnServer runningTurnServer;
    private static boolean runningServerSinglePlayer;
    private static String venueName;

    public static TurnServer startServer(boolean singlePlayer) {
        return TurnServer.startServer(singlePlayer, "VENUE");
    }

    public static TurnServer startServer(boolean singlePlayer, String venue) {
        runningServerSinglePlayer = singlePlayer;
        venueName = venue;
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    runningServer = new NetServer();
                    runningTurnServer = new TurnServer(runningServer, runningServerSinglePlayer);
                    if (runningServerSinglePlayer) {
                        runningServer.setGame(runningTurnServer);
                    } else {
                        runningServer.registerVenue(venueName);
                        runningServer.setGame(new GameServer(runningServer));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        });
        t.start();
        while (runningServer == null || !runningServer.isReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return runningTurnServer;
    }

    public TurnServer(NetServer owner, boolean singlePlayer) throws Exception {
        super(owner);
        if (singlePlayer) {
            this.singlePlayerMode = true;
            this.gameSize = 1;
        } else {
            this.singlePlayerMode = false;
            this.gameSize = 1;
        }
        this.startingRobots = false;
        this.calling = false;
        this.calls = 0;
        this.numPlayers = 0;
        this.rng = new Random();
        this.root = new GameRoot();
        this.donePlayers = new HashSet(4);
        this.clientIDs = new HashMap(4);
        this.candidates = new ArrayList();
    }

    public void loadGame(String fileName) {
        GameRoot r = (GameRoot)SimObject.readFromXML(fileName);
        Iterator iter = r.getPlayers().values().iterator();
        while (iter.hasNext()) {
            Player p = (Player)iter.next();
            p.setConnected(false);
        }
        this.setGameSize(r.getHumanPlayers());
        this.root = r;
    }

    public void setSaveDir(String dir) {
        saveDir = dir + "/";
    }

    public void setGameSize(int size) {
        this.gameSize = size;
    }

    public void createGame(String gameName, int humanPlayers, String fromFile) {
        try {
            TurnServer game = new TurnServer(this.server, false);
            game.setGameName(gameName);
            game.setGameSize(humanPlayers);
            this.server.getLobby().addGame(gameName, game);
            if (fromFile != null) {
                game.loadGame(fromFile);
            }
        }
        catch (Exception e) {
            this.server.log.error("Error starting game");
            e.printStackTrace();
        }
    }

    public List getPlayers() {
        Registry players = this.root.getPlayers();
        ArrayList<String> l = new ArrayList<String>();
        l.add("1. <Empty>");
        l.add("2. <Empty>");
        l.add("3. <Empty>");
        l.add("4. <Empty>");
        Iterator iter = players.values().iterator();
        while (iter.hasNext()) {
            Player player = (Player)iter.next();
            l.set(player.getTurnNumber() - 1, player.getTurnNumber() + ". " + player.getName());
        }
        return l;
    }

    public void lostClient(Client c) {
        super.lostClient(c);
        String pid = (String)this.clientIDs.get(c.getClientName());
        if (this.root != null) {
            Player p = this.root.player(pid);
            if (p == null) {
                this.root.warning("pid does not exist: " + pid);
            }
            p.disconnected();
        }
        this.phaseControl();
    }

    public boolean reconnectPlayer(Client c, int turnNumber) {
        super.reconnectPlayer(c, turnNumber);
        if (this.root != null) {
            if (turnNumber != 0) {
                String pid = "p" + turnNumber;
                Player p = this.root.player(pid);
                if (p == null) {
                    c.sendMessage("ErrorMessage There is no such player");
                    return false;
                }
                if (p.isConnected()) {
                    c.sendMessage("ErrorMesssage This user isn't disconnected");
                    return false;
                }
                p.setConnected(true);
                this.clientIDs.put(c.getClientName(), pid);
                c.sendMessage("YouArePlayer " + turnNumber + "|" + pid);
            }
            c.sendMessage("Phase setup");
            if ("setup".equals(this.root.getPhase())) {
                c.sendMessage("Briefing");
                c.sendMessage(this.briefing.writeXML());
                c.sendMessage("**briefingDone**");
            } else {
                c.sendMessage("GameRoot");
                c.sendMessage(this.root.writeXML());
                c.sendMessage("**gamerootDone**");
                c.sendMessage("Phase negotiate");
                this.phaseControl();
                c.sendMessage("Phase " + this.root.getPhase());
                if (this.root.getPhase().startsWith("vote")) {
                    c.sendMessage("ResetVotingTimer");
                }
            }
            return true;
        }
        return false;
    }

    public void setRNGSeed(int seed) {
        this.rng = new Random(seed);
    }

    public void setupDefaultActions() {
        super.setupDefaultActions();
        this.addHandler("JoinGame", new JoinGameHandler());
        this.addHandler("StartGameNow", new StartGameNowHandler());
        this.addHandler("Ready", new ReadyHandler());
        this.addHandler("Amendment", new AmendmentHandler());
        this.addHandler("RandomProposal", new RandomProposalHandler());
        this.addHandler("Opinion", new OpinionHandler());
        this.addHandler("Withdraw", new WithdrawHandler());
        this.addHandler("Call", new CallHandler());
        this.addHandler("Vote", new VoteHandler());
        this.addHandler("VotingTimerExpired", new VotingTimerExpiredHandler());
    }

    public static synchronized String nextID() {
        return "prop" + ++nextID;
    }

    public GameRoot getRoot() {
        return this.root;
    }

    public Proposal getRandomProposal() {
        Proposal p;
        boolean flag;
        ArrayList list = new ArrayList(this.root.getNewProposals());
        if (list.size() < 1) {
            return null;
        }
        do {
            p = (Proposal)list.get(this.rng.nextInt(list.size()));
        } while (flag = "End Turn Now".equals((p = (Proposal)p.duplicate()).getTitle()) && this.rng.nextBoolean());
        do {
            Iterator iter = p.getConfigParameters().iterator();
            while (iter.hasNext()) {
                ConfigParameter config = (ConfigParameter)iter.next();
                String type = config.getType();
                if ("boolean".equals(type)) {
                    p.configure(config, this.rng.nextBoolean());
                    continue;
                }
                if ("choice".equals(type)) {
                    ArrayList choices = (ArrayList)config.getObjectAttribute("choices");
                    p.configure(config, this.rng.nextInt(choices.size()));
                    continue;
                }
                this.root.warning("No configuration for ConfigParameter '" + config.getName() + "' of unknown type '" + type + "' when randomly configuring proposal " + p.getTitle());
            }
        } while (flag = this.root.currentlyTooCostly(p));
        return p;
    }

    public boolean isFull() {
        return this.numPlayers >= 4;
    }

    private void startRobots() {
        this.startingRobots = true;
        Thread parent = new Thread(){

            public void run() {
                Robot aPlayer = null;
                TurnServer.this.server.log.log("Starting robot thread");
                for (int threadsToStart = 4 - TurnServer.this.numPlayers; threadsToStart > 0; --threadsToStart) {
                    aPlayer = new AutoPlayer().run(TurnServer.this.getGameName());
                }
                while (aPlayer.isRunning()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Thread.yield();
                }
                TurnServer.this.server.log.log("Stopping robot thread");
            }
        };
        parent.start();
    }

    public void nextTurn() {
        Scenario s = this.root.getScenario();
        this.briefing = s.nextTurn(this.root, this.rng);
        this.broadcast("Briefing");
        this.broadcast(this.briefing.writeXML());
        this.broadcast("**briefingDone**");
        if (s.getTurn() > s.getNumTurns()) {
            if (saveDir != null) {
                Date d = new Date();
                this.briefing.writeXML(saveDir + "debrief." + this.getGameName() + "-" + d.getTime() + ".xml");
            }
            this.phase("done");
        }
    }

    public void build(Proposal p) {
        List list = this.root.getNewProposals();
        list.addAll(this.root.getFailedProposals());
        list = SimObject.filter((Collection)list, "proposalFamily", p.getFamily());
        for (int i = 0; i < list.size(); ++i) {
            Proposal p2 = (Proposal)list.get(i);
            p2.setStatus("Unpicked");
            this.broadcast("Outcome " + p2.getProposalID() + "|" + "Unpicked" + "|#");
        }
        p.enact(this.root, this.rng);
    }

    private void removeIllegalProposals(String family) {
        Proposal p;
        Iterator iter = this.root.getActiveProposals().iterator();
        while (iter.hasNext()) {
            p = (Proposal)iter.next();
            if ("Played".equals(p.getStatus()) && this.root.currentlyTooCostly(p)) {
                p.setStatus("Autofail");
                this.broadcast("Outcome " + p.getProposalID() + "|" + "Autofail" + "|No longer affordable");
            }
            if (p.getFamily().equals(family) && "New".equals(p.getStatus())) {
                List list = this.root.getFailedProposals();
                if ((list = SimObject.filter((Collection)list, "proposalFamily", p.getFamily())).size() >= 4) {
                    p.setStatus("Autofail");
                    this.broadcast("Outcome " + p.getProposalID() + "|" + "Autofail" + "|No players left who can propose it");
                    for (int i = 0; i < list.size(); ++i) {
                        Proposal q = (Proposal)list.get(i);
                        q.setStatus("Autofail");
                        this.broadcast("Outcome " + q.getProposalID() + "|" + "Autofail" + "|#");
                    }
                    continue;
                }
            }
            if (!this.root.alwaysTooCostly(p)) continue;
            p.setStatus("Autofail");
            this.broadcast("Outcome " + p.getProposalID() + "|" + "Autofail" + "|No longer affordable");
        }
        Collection props = this.root.getActiveProposals();
        if (props.size() < 3 && props.size() > 0 && (p = (Proposal)(iter = props.iterator()).next()).getFamily().startsWith("EndTurn")) {
            if (iter.hasNext()) {
                Proposal p2 = (Proposal)iter.next();
                if (p2.getFamily().startsWith("EndTurn")) {
                    p.setStatus("Autofail");
                    this.broadcast("Outcome " + p.getProposalID() + "|" + "Unpicked" + "|#End1");
                    p2.setStatus("Autofail");
                    this.broadcast("Outcome " + p2.getProposalID() + "|" + "Unpicked" + "|#End2");
                }
            } else {
                p.setStatus("Autofail");
                this.broadcast("Outcome " + p.getProposalID() + "|" + "Unpicked" + "|#");
            }
        }
    }

    public void phase(String phase) {
        this.donePlayers.clear();
        this.root.setPhase(phase);
        this.root.resetPlayerStatus();
        this.broadcast("Phase " + phase);
        if (phase.equals("setup")) {
            this.nextTurn();
        } else if (phase.equals("negotiate")) {
            this.phaseControl();
        } else if (phase.startsWith("vote")) {
            this.broadcast("ResetVotingTimer");
        } else if (phase.startsWith("done")) {
            this.broadcast("bye");
        }
    }

    public synchronized void phaseControl() {
        String phase = this.root.getPhase();
        Registry players = this.root.getConnectedPlayers();
        boolean allDone = ((Object)this.donePlayers).equals(players.keySet());
        Registry proposals = this.root.getProposalRegistry();
        if (!phase.equals("init")) {
            if (phase.equals("setup")) {
                if (allDone) {
                    this.phase("negotiate");
                }
            } else if (phase.equals("negotiate")) {
                if (saveDir != null) {
                    Date d = new Date();
                    this.root.writeXML(saveDir + this.getGameName() + "-" + d.getTime() + ".xml");
                }
            } else if (phase.startsWith("vote") && allDone) {
                this.resolveVote();
                if (this.root.getActiveProposals().isEmpty()) {
                    Iterator iter = this.root.getProposals().iterator();
                    while (iter.hasNext()) {
                        Proposal p = (Proposal)iter.next();
                        if (!"New".equals(p.getStatus()) && !"Played".equals(p.getStatus()) && !"Failed".equals(p.getStatus())) continue;
                        p.setStatus("Unpicked");
                    }
                    this.broadcast("NotifyUser Turn ends because no more proposals can be passed.");
                    this.phase("setup");
                } else {
                    this.phase("negotiate");
                }
            }
        }
    }

    public void resolveVote() {
        String result;
        String status;
        Proposal p = this.root.getUpForVote();
        int t = p.getVoteTally();
        if (t == 0) {
            status = "Played";
            result = "Proposal is tabled on a tie vote";
            p.resetVoteTally();
        } else if (t > 0) {
            status = "Passed";
            result = t > 1 ? "Proposal passes by " + t + " votes" : "Proposal passes by 1 vote";
        } else {
            status = "Failed";
            result = t < -1 ? "Proposal fails by " + -t + " votes" : "Proposal fails by 1 vote";
        }
        this.root.setUpForVote(null);
        p.setStatus(status);
        this.broadcast("Outcome " + p.getProposalID() + "|" + status + "|" + result);
        if ("Passed".equals(p.getStatus())) {
            this.build(p);
            this.broadcast("GameRoot");
            this.broadcast(this.root.writeXML());
            this.broadcast("**gamerootDone**");
        }
        this.removeIllegalProposals(p.getFamily());
    }

    public static void main(String[] args) {
        try {
            TurnServer.startServer(false);
            while (runningServer.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    class VotingTimerExpiredHandler
    implements Handler {
        VotingTimerExpiredHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            if (!TurnServer.this.root.getPhase().startsWith("vote")) {
                TurnServer.this.root.log("### Discarded out-of-sequence message: " + command + " " + message);
                return;
            }
            TurnServer.this.root.setPlayerStatus(message, "Done");
            TurnServer.this.broadcast("Done " + message);
            TurnServer.this.donePlayers.add(message);
            TurnServer.this.phaseControl();
        }
    }

    class VoteHandler
    implements Handler {
        VoteHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            Player player = TurnServer.this.root.player(stok.nextToken());
            int vote = Integer.parseInt(stok.nextToken());
            Proposal proposal = TurnServer.this.root.getUpForVote();
            if (!TurnServer.this.root.getPhase().startsWith("vote")) {
                TurnServer.this.root.log("### Discarded out-of-sequence message: Vote " + message);
                return;
            }
            if (Math.abs(vote) <= player.getFavors() + player.getVotes()) {
                TurnServer.this.root.castVote(player, proposal, vote);
                TurnServer.this.broadcast("Vote " + message);
                TurnServer.this.broadcast("ResetVotingTimer");
                TurnServer.this.donePlayers.clear();
            }
        }
    }

    class CallHandler
    implements Handler {
        CallHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            String playerID = stok.nextToken();
            if ("voting".equals(TurnServer.this.root.getPhase())) {
                c.sendMessage("NotifyUser There's already a vote in progress.");
                return;
            }
            if (!"negotiate".equals(TurnServer.this.root.getPhase())) {
                c.sendMessage("NotifyUser You can't call for a vote now.");
                return;
            }
            String pid = stok.nextToken();
            TurnServer.this.root.setUpForVote((Proposal)TurnServer.this.root.getProposalRegistry().get(pid));
            TurnServer.this.phase("vote|" + pid + "|" + playerID);
        }
    }

    class WithdrawHandler
    implements Handler {
        WithdrawHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            if (TurnServer.this.calling) {
                c.sendMessage("NotifyUser Withdraw failed because a call for vote is in progress.");
                return;
            }
            Proposal prop = TurnServer.this.root.proposal(message);
            prop.setStatus("Withdrawn");
            TurnServer.this.broadcast("Outcome " + message + "|" + "Withdrawn" + "|Withdrawn by " + TurnServer.this.root.getOwner(prop).getName());
            TurnServer.this.phaseControl();
        }
    }

    class OpinionHandler
    implements Handler {
        OpinionHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            StringTokenizer stok = new StringTokenizer(message, "|");
            String playerID = stok.nextToken();
            String proposalID = stok.nextToken();
            String pref = stok.nextToken();
            Proposal prop = TurnServer.this.root.proposal(proposalID);
            Player player = TurnServer.this.root.player(playerID);
            TurnServer.this.broadcast("Opinion " + message);
            if (prop == null || player == null) {
                return;
            }
            prop.setPlayerOpinion(player, pref);
        }
    }

    class RandomProposalHandler
    implements Handler {
        RandomProposalHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            Proposal p = TurnServer.this.getRandomProposal();
            if (p == null) {
                return;
            }
            c.sendMessage("RandomProposal");
            c.sendMessage(p.writeXML());
            c.sendMessage("**proposalDone**");
        }
    }

    class AmendmentHandler
    implements Handler {
        AmendmentHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            if (TurnServer.this.singlePlayerMode) {
                DelimReader r = new DelimReader(c.getReader(), "**proposalDone**");
                Registry proposals = TurnServer.this.root.getProposalRegistry();
                Proposal p = (Proposal)SimObject.readFromXML(r);
                p.setProposalID(TurnServer.nextID());
                p.setStatus("Played");
                proposals.put(p.getProposalID(), p);
                TurnServer.this.broadcast("Proposal " + p.getProposalID());
                TurnServer.this.broadcast(p.writeXML());
                TurnServer.this.broadcast("**proposalDone**");
                TurnServer.this.root.setPhase("vote");
                TurnServer.this.root.setUpForVote(p);
                TurnServer.this.donePlayers.addAll(TurnServer.this.root.getPlayers().keySet());
                if (!TurnServer.this.root.currentlyTooCostly(p)) {
                    TurnServer.this.root.castVote(Player.nobody(), p, 1);
                }
                TurnServer.this.phaseControl();
                return;
            }
            DelimReader r = new DelimReader(c.getReader(), "**proposalDone**");
            Proposal p = (Proposal)SimObject.readFromXML(r);
            if (TurnServer.this.root.getPhase().startsWith("vote")) {
                c.sendMessage("NotifyUser You can't make a proposal while a vote is in progress.");
                return;
            }
            if (!"negotiate".equals(TurnServer.this.root.getPhase())) {
                c.sendMessage("NotifyUser You cannot make proposals at this time.");
                return;
            }
            List list = TurnServer.this.root.getNewProposals();
            if (SimObject.filter((Collection)list, "proposalFamily", p.getFamily()).size() < 1) {
                c.sendMessage("NotifyUser This proposal has been resolved.");
                return;
            }
            list = TurnServer.this.root.getPlayedProposals();
            if ((list = SimObject.filter((Collection)list, "proposalFamily", p.getFamily())).size() > 0) {
                Proposal p1;
                String pid;
                if (list.size() != 1) {
                    TurnServer.this.root.warning("More than one version of " + p.getFamily() + " proposal in play; something's very wrong!");
                }
                if ((pid = (String)TurnServer.this.clientIDs.get(c.getClientName())).equals((p1 = (Proposal)list.iterator().next()).getOwnerID())) {
                    p1.setStatus("Withdrawn");
                    TurnServer.this.broadcast("Outcome " + p1.getProposalID() + "|" + "Withdrawn" + "|#|");
                } else {
                    c.sendMessage("NotifyUser A version of this proposal is already in play.");
                    return;
                }
            }
            Registry proposals = TurnServer.this.root.getProposalRegistry();
            p.setProposalID(TurnServer.nextID());
            p.setStatus("Played");
            proposals.put(p.getProposalID(), p);
            TurnServer.this.broadcast("Proposal " + p.getProposalID());
            TurnServer.this.broadcast(p.writeXML());
            TurnServer.this.broadcast("**proposalDone**");
        }
    }

    class ReadyHandler
    implements Handler {
        ReadyHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            TurnServer.this.donePlayers.add(message);
            TurnServer.this.phaseControl();
        }
    }

    class StartGameNowHandler
    implements Handler {
        StartGameNowHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            TurnServer.this.startRobots();
        }
    }

    class JoinGameHandler
    implements Handler {
        JoinGameHandler() {
        }

        public void gotCommand(String command, String message, Client c) {
            if (TurnServer.this.numPlayers >= 4) {
                c.sendMessage("ErrorMessage This game is full.");
                c.sendMessage("Phase done");
                return;
            }
            TurnServer.this.numPlayers++;
            StringTokenizer stok = new StringTokenizer(message, "|");
            int requestedTurnNumber = Integer.parseInt(stok.nextToken());
            String playerName = stok.nextToken();
            String pid = "p" + requestedTurnNumber;
            int roleNumber = -1;
            if (TurnServer.this.root.player(pid) != null) {
                for (int i = 1; i <= 4; ++i) {
                    pid = "p" + i;
                    if (TurnServer.this.root.player(pid) != null) continue;
                    roleNumber = i;
                    break;
                }
            } else {
                roleNumber = requestedTurnNumber;
            }
            TurnServer.this.clientIDs.put(c.getClientName(), pid);
            Player p = new Player(roleNumber, playerName);
            p.setRole(TurnServer.this.root.roleForPlayer(roleNumber));
            TurnServer.this.root.getPlayers().put(pid, p);
            c.sendMessage("YouArePlayer " + pid.substring(1) + "|" + pid);
            if (!TurnServer.this.startingRobots && !TurnServer.this.singlePlayerMode && TurnServer.this.numPlayers < 4 && TurnServer.this.numPlayers >= TurnServer.this.gameSize) {
                TurnServer.this.startRobots();
            }
            if (TurnServer.this.singlePlayerMode || TurnServer.this.numPlayers == 4) {
                TurnServer.this.root.setGameName(TurnServer.this.getGameName());
                TurnServer.this.root.setHumanPlayers(TurnServer.this.gameSize);
                TurnServer.this.setGameName(TurnServer.this.getGameName() + " (Full)");
                TurnServer.this.phase("setup");
            }
        }
    }
}

