/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.sim.GameRoot;
import dd.sim.Proposal;
import dd.sim.SimObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class CostTable
extends SimObject {
    public CostTable() {
        this.setAttribute("configSum", new ArrayList());
        this.setAttribute("family", new ArrayList());
        this.setAttribute("econCost", new ArrayList());
        this.setAttribute("socialCost", new ArrayList());
    }

    public ArrayList getAllConfigs(String family) {
        ArrayList result = new ArrayList();
        ArrayList flist = this.getFamily();
        ArrayList clist = this.getConfigSum();
        for (int i = 0; i < flist.size(); ++i) {
            if (!family.equals(flist.get(i))) continue;
            result.add(clist.get(i));
        }
        return result;
    }

    public int getEconCost(String family, String config) {
        ArrayList clist = this.getConfigSum();
        ArrayList flist = this.getFamily();
        for (int i = 0; i < flist.size(); ++i) {
            if (!family.equals(flist.get(i)) || !config.equals(clist.get(i))) continue;
            return CostTable.unbox(this.getEconCost().get(i));
        }
        return 0;
    }

    public int getSocialCost(String family, String config) {
        ArrayList clist = this.getConfigSum();
        ArrayList flist = this.getFamily();
        for (int i = 0; i < flist.size(); ++i) {
            if (!family.equals(flist.get(i)) || !config.equals(clist.get(i))) continue;
            return CostTable.unbox(this.getSocialCost().get(i));
        }
        return 0;
    }

    public boolean anyAffordable(String family, float econBudget, float socialBudget) {
        ArrayList flist = this.getFamily();
        ArrayList elist = this.getEconCost();
        ArrayList slist = this.getSocialCost();
        for (int i = 0; i < flist.size(); ++i) {
            if (!family.equals(flist.get(i)) || !((float)CostTable.unbox(elist.get(i)) <= econBudget) || !((float)CostTable.unbox(slist.get(i)) <= socialBudget)) continue;
            return true;
        }
        return false;
    }

    public void addEntry(String configSum, String family, int econCost, int socialCost) {
        this.getConfigSum().add(configSum);
        this.getFamily().add(family);
        this.getEconCost().add(new Integer(econCost));
        this.getSocialCost().add(new Integer(socialCost));
    }

    private ArrayList getConfigSum() {
        return (ArrayList)this.getObjectAttribute("configSum");
    }

    private ArrayList getFamily() {
        return (ArrayList)this.getObjectAttribute("family");
    }

    private ArrayList getEconCost() {
        return (ArrayList)this.getObjectAttribute("econCost");
    }

    private ArrayList getSocialCost() {
        return (ArrayList)this.getObjectAttribute("socialCost");
    }

    private static int unbox(Object o) {
        return (Integer)o;
    }

    private static ArrayList getProposalNames(GameRoot root) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = root.getNewProposals().iterator();
        while (iter.hasNext()) {
            list.add(((Proposal)iter.next()).getFamily());
        }
        return list;
    }

    public static void main(String[] args) {
        String combo3;
        int k;
        String combo2;
        int sc;
        int ec;
        int j;
        String combo;
        int i;
        GameRoot root = new GameRoot();
        root.getScenario().nextTurn(root, new Random());
        CostTable t = root.getCostTable();
        ArrayList families = CostTable.getProposalNames(root);
        ArrayList f = t.getFamily();
        ArrayList c = t.getConfigSum();
        ArrayList e = t.getEconCost();
        ArrayList s = t.getSocialCost();
        int n = f.size();
        int eb = 10;
        int sb = 8;
        int count4 = 0;
        int count3 = 0;
        int count2 = 0;
        int count1 = 0;
        int afford4 = 0;
        int afford3 = 0;
        int afford2 = 0;
        for (i = 0; i < n; ++i) {
            if (!families.contains(f.get(i))) continue;
            ++count1;
            combo = "" + f.get(i) + "-" + c.get(i);
            for (j = i + 1; j < n; ++j) {
                if (!families.contains(f.get(j)) || f.get(i).equals(f.get(j))) continue;
                ++count2;
                ec = CostTable.unbox(e.get(i)) + CostTable.unbox(e.get(j));
                sc = CostTable.unbox(s.get(i)) + CostTable.unbox(s.get(j));
                if (ec > eb || sc > sb) continue;
                ++afford2;
                combo2 = combo + " / " + f.get(j) + "-" + c.get(j);
                CostTable.out(combo2);
                for (k = j + 1; k < n; ++k) {
                    if (!families.contains(f.get(k)) || f.get(k).equals(f.get(i)) || f.get(k).equals(f.get(j))) continue;
                    ++count3;
                    if (ec + CostTable.unbox(e.get(k)) > eb || sc + CostTable.unbox(s.get(k)) > sb) continue;
                    ++afford3;
                    combo3 = combo2 + " / " + f.get(k) + "-" + c.get(k);
                    CostTable.out(combo3);
                }
            }
        }
        CostTable.out("\nTurn 1 Summary");
        CostTable.out("Total variations: " + count1);
        CostTable.out("Affordable pairings: " + afford2 + "/" + count2);
        CostTable.out("Affordable triplets: " + afford3 + "/" + count3);
        CostTable.out("\n\n");
        root.getScenario().nextTurn(root, new Random());
        families = CostTable.getProposalNames(root);
        count4 = 0;
        count3 = 0;
        count2 = 0;
        count1 = 0;
        afford4 = 0;
        afford3 = 0;
        afford2 = 0;
        for (i = 0; i < n; ++i) {
            if (!families.contains(f.get(i))) continue;
            ++count1;
            combo = "" + f.get(i) + "-" + c.get(i);
            for (j = i + 1; j < n; ++j) {
                if (!families.contains(f.get(j)) || f.get(i).equals(f.get(j))) continue;
                ++count2;
                ec = CostTable.unbox(e.get(i)) + CostTable.unbox(e.get(j));
                sc = CostTable.unbox(s.get(i)) + CostTable.unbox(s.get(j));
                if (ec > eb || sc > sb) continue;
                ++afford2;
                combo2 = combo + " / " + f.get(j) + "-" + c.get(j);
                CostTable.out(combo2);
                for (k = j + 1; k < n; ++k) {
                    if (!families.contains(f.get(k)) || f.get(k).equals(f.get(i)) || f.get(k).equals(f.get(j))) continue;
                    ++count3;
                    if (ec + CostTable.unbox(e.get(k)) > eb || sc + CostTable.unbox(s.get(k)) > sb) continue;
                    ++afford3;
                    combo3 = combo2 + " / " + f.get(k) + "-" + c.get(k);
                    CostTable.out(combo3);
                    for (int l = k + 1; l < n; ++l) {
                        if (!families.contains(f.get(l)) || f.get(l).equals(f.get(i)) || f.get(l).equals(f.get(j)) || f.get(l).equals(f.get(k))) continue;
                        ++count4;
                        if (ec + CostTable.unbox(e.get(l)) > eb || sc + CostTable.unbox(s.get(l)) > sb) continue;
                        ++afford4;
                        String combo4 = combo3 + " / " + f.get(l) + "-" + c.get(l);
                        CostTable.out(combo4);
                    }
                }
            }
        }
        CostTable.out("\nTurn 2 Summary");
        CostTable.out("Total variations: " + count1);
        CostTable.out("Affordable pairs: " + afford2 + "/" + count2);
        CostTable.out("Affordable tri's: " + afford3 + "/" + count3);
        CostTable.out("Affordable quads: " + afford4 + "/" + count4);
        CostTable.out("\n");
    }
}

