/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.hurricane.Main;
import dd.hurricane.Scenario;
import dd.hurricane.Tutorial;
import dd.net.TurnServer;
import dd.sim.CostTable;
import dd.sim.Layer;
import dd.sim.MapCell;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.util.Registry;
import dd.util.StringUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GameRoot
extends SimObject {
    public static CostTable getCostTable() {
        return Scenario.readCostTable();
    }

    public GameRoot() {
        this.setPhase("init");
        this.resetPlayerStatus();
        this.setAttribute("upForVote", "none");
        Registry proposals = new Registry();
        Registry players = new Registry();
        Scenario scenario = new Scenario();
        this.setAttribute("proposals", proposals);
        this.setAttribute("players", players);
        this.setAttribute("scenario", scenario);
    }

    public static GameRoot tutorial() {
        GameRoot r = new GameRoot();
        r.setAttribute("scenario", new Tutorial());
        return r;
    }

    public Collection getProposals() {
        return ((Registry)this.getObjectAttribute("proposals")).values();
    }

    public Registry getProposalRegistry() {
        return (Registry)this.getObjectAttribute("proposals");
    }

    public void setProposals(Registry proposals) {
        this.setAttribute("proposals", proposals);
    }

    public Registry getPlayers() {
        return (Registry)this.getObjectAttribute("players");
    }

    public void setGameName(String name) {
        this.setAttribute("gameName", name);
    }

    public String getGameName() {
        return (String)this.getObjectAttribute("gameName");
    }

    public void setHumanPlayers(int num) {
        this.setAttribute("humanPlayers", num);
    }

    public int getHumanPlayers() {
        return (int)this.getAttribute("humanPlayers", 0.0f);
    }

    public Registry getConnectedPlayers() {
        Registry r = new Registry();
        Iterator iter = this.getPlayers().values().iterator();
        while (iter.hasNext()) {
            Player p = (Player)iter.next();
            if (!p.isConnected()) continue;
            r.put(p.getPlayerID(), p);
        }
        return r;
    }

    public Scenario getScenario() {
        return (Scenario)this.getObjectAttribute("scenario");
    }

    public void nextTurn() {
        Iterator iter = this.getPlayers().values().iterator();
        while (iter.hasNext()) {
            Player p = (Player)iter.next();
            p.reset();
        }
    }

    public void addNewProposal(String family) {
        Proposal p = Scenario.readProposal(family + ".xml");
        p.setProposalID(TurnServer.nextID());
        this.getProposalRegistry().put(p.getProposalID(), p);
    }

    public void createProposalsPage() {
        String propPage = "<html><head><title>Proposals</title>";
        propPage = propPage + "</head>\n<body>\n<h1>Proposal Descriptions</h1>\n<ul>\n";
        Iterator iter = this.getNewProposals().iterator();
        while (iter.hasNext()) {
            Proposal p = (Proposal)iter.next();
            propPage = propPage + "<li><a href=\"" + p.getFamily() + ".html\">";
            propPage = propPage + p.getTitle();
            propPage = propPage + "</a></li>\n";
        }
        propPage = propPage + "</ul></body></html>";
        this.setAttribute("proposalsPage", propPage);
    }

    public String getProposalsPage() {
        return (String)this.getObjectAttribute("proposalsPage");
    }

    public String getProposalSummaries() {
        String result = "<ul>";
        Iterator iter = this.getNewProposals().iterator();
        while (iter.hasNext()) {
            Proposal p = (Proposal)iter.next();
            result = result + "<li><b>";
            result = result + p.getTitle();
            result = result + ":</b> ";
            result = result + p.getDescription();
        }
        result = result + "</ul>";
        return result;
    }

    public void castVote(Player player, Proposal proposal, int vote) {
        proposal.castVote(player.getPlayerID(), vote);
        player.spendVotes(Math.abs(vote));
    }

    public Player getOwner(Proposal prop) {
        String playerID = prop.getOwnerID();
        Player owner = (Player)this.getPlayers().get(playerID);
        if (owner != null) {
            return owner;
        }
        return Player.nobody();
    }

    public Proposal getUpForVote() {
        String pid = (String)this.getObjectAttribute("upForVote");
        if ("none".equals(pid)) {
            return null;
        }
        return (Proposal)this.getProposalRegistry().get(pid);
    }

    public void setUpForVote(Proposal p) {
        Iterator iter;
        Proposal wasUpForVote = this.getUpForVote();
        if (wasUpForVote != null) {
            iter = this.getPlayers().values().iterator();
            while (iter.hasNext()) {
                ((Player)iter.next()).setVotes(0);
            }
        }
        if (p == null) {
            this.setAttribute("upForVote", "none");
        } else {
            iter = this.getPlayers().values().iterator();
            while (iter.hasNext()) {
                ((Player)iter.next()).setVotes(1);
            }
            this.setAttribute("upForVote", p.getProposalID());
        }
    }

    public void spendRemainingBudget() {
        int remainder = (int)Math.floor(this.getScenario().getCurrentEconBudget() / 2.0f);
        this.getScenario().setCurrentEconBudget(0);
        this.getScenario().setAttribute("econRemainder", remainder);
        remainder = (int)Math.floor(this.getScenario().getCurrentSocialBudget() / 2.0f);
        this.getScenario().setCurrentSocialBudget(0);
        this.getScenario().setAttribute("socialRemainder", remainder);
    }

    public boolean alwaysTooCostly(Proposal prop) {
        Scenario s = this.getScenario();
        CostTable c = GameRoot.getCostTable();
        return !c.anyAffordable(prop.getFamily(), s.getCurrentEconBudget(), s.getCurrentSocialBudget());
    }

    public boolean currentlyTooCostly(Proposal prop) {
        Scenario s = this.getScenario();
        return prop.getEconCost() > s.getCurrentEconBudget() || prop.getSocialCost() > s.getCurrentSocialBudget();
    }

    public Proposal proposal(String pid) {
        return (Proposal)this.getProposalRegistry().get(pid);
    }

    public Player player(String pid) {
        if ("p0".equals(pid)) {
            return Player.nobody();
        }
        return (Player)this.getPlayers().get(pid);
    }

    public void setPhase(String phase) {
        this.setAttribute("phase", phase);
    }

    public String getPhase() {
        return (String)this.getObjectAttribute("phase");
    }

    public void setPlayerStatus(String pid, String status) {
        this.setAttribute(pid + "Status", status);
    }

    public void resetPlayerStatus() {
        for (int i = 1; i <= 4; ++i) {
            this.setPlayerStatus("p" + i, "Waiting...");
        }
    }

    public String getPlayerStatus(String pid) {
        Object status = this.getObjectAttribute(pid + "Status");
        if (status == null) {
            return "";
        }
        return (String)status;
    }

    public String roleForPlayer(int turnNumber) {
        return this.getScenario().roleForPlayer(turnNumber);
    }

    public float getScore(String metric) {
        Layer l = this.getScenario().getMap().getLayer("landuse");
        String[] lu = Main.luNames;
        if ("hazard".equals(metric)) {
            Layer haz = this.getScenario().getMap().getLayer("hazard");
            float windExposure = haz.getAttribute("wind", 0.5f);
            float waterExposureBonus = haz.getAttribute("waterExposureBonus", 0.0f);
            float[] vWind = new float[lu.length];
            float[] vWater = new float[lu.length];
            for (int i = 0; i < lu.length; ++i) {
                vWind[i] = haz.getAttribute(lu[i] + "WindVulnerability", 0.5f);
                vWater[i] = haz.getAttribute(lu[i] + "WaterVulnerability", 0.5f);
            }
            float total = 0.0f;
            float result = 0.0f;
            Iterator iter = this.getScenario().getMap().getCells().iterator();
            while (iter.hasNext()) {
                MapCell cell = (MapCell)iter.next();
                float waterExposure = cell.getAttribute("water", haz, 0.0f);
                if ((waterExposure += waterExposureBonus) < 0.0f) {
                    waterExposure = 0.0f;
                }
                for (int i = 0; i < lu.length; ++i) {
                    int n = this.getScenario().getMap().luCount(lu[i], cell);
                    float pWind = vWind[i] * windExposure;
                    float pWater = vWater[i] * waterExposure;
                    result += (float)n * (pWind + pWater - pWind * pWater);
                }
            }
            result /= 250.0f;
            if ((result = (float)((double)result - 0.2)) < 0.0f) {
                return 0.0f;
            }
            if (result > 1.0f) {
                return 1.0f;
            }
            return result;
        }
        if ("ecology".equals(metric)) {
            float total = 0.0f;
            float result = 0.0f;
            Iterator iter = this.getScenario().getMap().getCells().iterator();
            while (iter.hasNext()) {
                MapCell cell = (MapCell)iter.next();
                ArrayList a = (ArrayList)cell.getObjectAttribute("luArray", l);
                for (int i = 0; i < a.size(); ++i) {
                    total += 1.0f;
                    String use = (String)a.get(i);
                    if ("none".equals(use)) {
                        result += 1.0f;
                    }
                    if ("openspace".equals(use)) {
                        result = (float)((double)result + 1.5);
                    }
                    if (!"water".equals(use)) continue;
                    total -= 1.0f;
                }
            }
            result /= total;
            if ((result += l.getAttribute("ecologyBonus", 0.0f)) < 0.0f) {
                return 0.0f;
            }
            if (result > 1.0f) {
                return 1.0f;
            }
            return result;
        }
        for (int i = 0; i < lu.length; ++i) {
            if (!lu[i].equals(metric)) continue;
            float result = l.getAttribute(metric, 0.0f);
            result += l.getAttribute("growth", 0.0f);
            result = (GameRoot.tanh(result) + 1.0f) / 2.0f;
            return result;
        }
        return 0.5f;
    }

    public static float tanh(float x) {
        float z = (float)Math.exp(x);
        return (z - 1.0f / z) / (z + 1.0f / z);
    }

    public List getNewProposals() {
        return this.getStatusProposals("New");
    }

    public List getPlayedProposals() {
        return this.getStatusProposals("Played");
    }

    public List getPassedProposals() {
        return this.getStatusProposals("Passed");
    }

    public List getFailedProposals() {
        return this.getStatusProposals("Failed");
    }

    public List getStatusProposals(String status) {
        List list = SimObject.filter(this.getProposals(), "proposalStatus", status);
        Collections.sort(list);
        return list;
    }

    public List getCurrentProposals() {
        int i;
        List newlist = this.getNewProposals();
        List played = this.getPlayedProposals();
        ArrayList<Proposal> result = new ArrayList<Proposal>(played);
        HashSet<String> families = new HashSet<String>();
        for (i = 0; i < played.size(); ++i) {
            families.add(((Proposal)played.get(i)).getFamily());
        }
        for (i = 0; i < newlist.size(); ++i) {
            Proposal p = (Proposal)newlist.get(i);
            if (families.contains(p.getFamily())) continue;
            result.add(p);
        }
        Collections.sort(result);
        return result;
    }

    public List getInactiveProposals() {
        ArrayList<Proposal> l = new ArrayList<Proposal>();
        Iterator iter = this.getProposals().iterator();
        while (iter.hasNext()) {
            Proposal p = (Proposal)iter.next();
            if (p.isActive() || p.getStatus().equals("Withdrawn")) continue;
            l.add(p);
        }
        return l;
    }

    public Collection getActiveProposals() {
        List c1 = this.getPlayedProposals();
        List c2 = this.getNewProposals();
        c1.addAll(c2);
        return c1;
    }

    public String getTurnSummary() {
        Proposal p;
        Scenario scenario = this.getScenario();
        int t = scenario.getTurn();
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
        format.applyPattern("+0.00;-0,00");
        String s = "<html><head><title>Summary</title></head>\n<body>\n";
        s = s + "<h1>Round " + t + " Summary</h1>\n";
        s = s + "<p><b>Passed proposals</b></p>\n<ul>\n";
        Iterator iter = this.getPassedProposals().iterator();
        while (iter.hasNext()) {
            p = (Proposal)iter.next();
            if (p.getTurn() != t) continue;
            s = s + "<li>" + p.getTitle() + "</li>\n";
        }
        s = s + "</ul>\n";
        s = s + "<table><tr><th>Score changes</th></tr>";
        String[] m = Main.metrics;
        String[] mc = Main.metricsColors;
        for (int i = 0; i < m.length; ++i) {
            float delta = this.getScore(m[i]) - scenario.getAttribute(m[i] + "OldScore", 0.0f);
            s = s + "<tr><td><font color=\"" + mc[i] + "\">" + StringUtils.capitalize(m[i]) + "</font></td>";
            s = s + "<td>" + format.format(delta) + "</td></tr>";
        }
        s = s + "</table>";
        s = s + "<p><b>Discussion</b></p>\n<ul>\n";
        iter = this.getPassedProposals().iterator();
        while (iter.hasNext()) {
            p = (Proposal)iter.next();
            if (p.getTurn() != t) continue;
            s = s + "<li>" + p.getDebriefingText() + "</li>\n";
        }
        s = s + "</ul>\n";
        return s;
    }

    public static void main(String[] args) {
        try {
            new GameRoot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

