/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.hurricane.LanduseManager;
import dd.sim.GrowthManager;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import java.util.ArrayList;

public class GrowthAgent {
    private GrowthManager gm;
    private String lu;
    private MapCell loc;
    private Map map;

    public GrowthAgent(GrowthManager gm, String type, MapCell loc) {
        this.gm = gm;
        this.lu = type;
        this.loc = loc;
        this.map = gm.getRoot().getScenario().getMap();
    }

    public void go() {
        boolean moving = true;
        while (moving) {
            ArrayList table = (ArrayList)this.gm.getTables().get(this.loc);
            MapCell dest = (MapCell)table.get(this.gm.getRng().nextInt(table.size()));
            if (dest.equals(this.loc)) {
                Layer layer = this.map.getLayer("landuse");
                this.loc = dest;
                moving = false;
                this.settle();
                continue;
            }
            this.loc = dest;
        }
    }

    private void setRandomLU(MapCell cell, String newVal) {
        block3: {
            int j;
            String lu;
            Layer layer = this.map.getLayer("landuse");
            boolean mixed = cell.isSet("mixedUse", layer);
            ArrayList luArray = (ArrayList)this.map.getObjectAttribute("landuse", cell, "luArray");
            do {
                if (!"none".equals(lu = (String)luArray.get(j = this.gm.getRng().nextInt(luArray.size())))) continue;
                luArray.set(j, newVal);
                break block3;
            } while (!mixed || "mixed".equals(lu) || newVal.equals(lu));
            luArray.set(j, "mixed");
        }
        if (LanduseManager.isFull(this.map, this.loc, newVal)) {
            ArrayList table = (ArrayList)this.gm.getTables().get(this.loc);
            for (int i = table.size() - 1; i >= 0; --i) {
                if (!this.loc.equals(table.get(i))) continue;
                table.remove(i);
            }
        }
    }

    public void settle() {
        ArrayList luArray = (ArrayList)this.map.getObjectAttribute("landuse", this.loc, "luArray");
        if (LanduseManager.isFull(this.map, this.loc, this.lu)) {
            this.loc.debug("GrowthAgent attempted to settle in full cell: " + luArray);
        } else {
            this.setRandomLU(this.loc, this.lu);
        }
    }
}

