/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.hurricane.HurricaneHex;
import dd.hurricane.Main;
import dd.sim.GameRoot;
import dd.sim.GrowthAgent;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.ui.MapView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JFrame;

public class GrowthManager {
    private static MapView view;
    private GameRoot root;
    private Random rng;
    private HashMap tables;
    private ArrayList agents;
    private String summary;
    private int numMoveLinks;
    private int numBdyInLinks;
    private int numBdyOutLinks;
    private int numHighwayLinks;
    private int numChannelLinks;
    private int numBridgeLinks;
    private int sDropWeight;
    private int nsDropWeight;
    private boolean debug = false;
    static /* synthetic */ Class class$dd$hurricane$HurricaneHex;

    public GrowthManager(GameRoot root, Random rng) {
        this.root = root;
        this.rng = rng;
        this.tables = new HashMap();
        this.agents = new ArrayList();
        this.numMoveLinks = 10;
        this.numBdyInLinks = 20;
        this.numBdyOutLinks = 1;
        this.numHighwayLinks = 2;
        this.numChannelLinks = 2;
        this.numBridgeLinks = 8;
        this.sDropWeight = 1;
        this.nsDropWeight = 2;
    }

    public GameRoot getRoot() {
        return this.root;
    }

    public Random getRng() {
        return this.rng;
    }

    public HashMap getTables() {
        return this.tables;
    }

    public String getSummary() {
        return this.summary;
    }

    public void debug(MapCell cell) {
        if (this.debug) {
            view.drawArrow(cell.getName());
            view.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void go() {
        this.buildTables();
        this.spawnAgents();
        this.doAgents();
    }

    public void buildTables() {
        this.tables.clear();
        Map map = this.root.getScenario().getMap();
        Layer lulayer = map.getLayer("landuse");
        Layer proplayer = map.getLayer("proposals");
        Iterator iter = map.getCells().iterator();
        while (iter.hasNext()) {
            String channel;
            int count;
            ArrayList luArray;
            MapCell cell = (MapCell)iter.next();
            ArrayList<MapCell> list = new ArrayList<MapCell>();
            int outbound = 0;
            boolean noSewer = cell.getAttribute("noSewer", lulayer, 0.0f) > 0.0f;
            Iterator neighbors = cell.getNeighbors().iterator();
            while (neighbors.hasNext()) {
                int i;
                boolean nborNoSewer;
                MapCell nbor = (MapCell)neighbors.next();
                luArray = (ArrayList)nbor.getObjectAttribute("luArray", lulayer);
                boolean nodevFlag = true;
                Iterator luIter = luArray.iterator();
                while (luIter.hasNext()) {
                    String lu = (String)luIter.next();
                    if ("water".equals(lu) || "openspace".equals(lu) || "industrial".equals(lu)) continue;
                    nodevFlag = false;
                }
                if (nodevFlag) continue;
                boolean bl = nborNoSewer = nbor.getAttribute("noSewer", lulayer, 0.0f) > 0.0f;
                count = noSewer ? (nborNoSewer ? this.numMoveLinks : this.numBdyInLinks) : (nborNoSewer ? this.numBdyOutLinks : this.numMoveLinks);
                outbound += count;
                for (i = 0; i < count; ++i) {
                    list.add(nbor);
                }
                if (!(map.getAttribute("transit", nbor, "highway", 0.0f) > 0.0f)) continue;
                outbound += this.numHighwayLinks;
                for (i = 0; i < this.numHighwayLinks; ++i) {
                    list.add(nbor);
                }
            }
            String dest = (String)map.getObjectAttribute("landuse", cell, "relocate");
            if (dest != null) {
                MapCell target = map.cellAt(dest);
                outbound += this.numMoveLinks;
                for (int i = 0; i < this.numMoveLinks; ++i) {
                    list.add(target);
                }
            }
            if ((channel = (String)map.getObjectAttribute("transit", cell, "channel")) != null) {
                MapCell target = map.cellAt(channel);
                count = 0;
                count = proplayer.isSet("Bridge") ? this.numBridgeLinks : this.numChannelLinks;
                outbound += count;
                for (int i = 0; i < count; ++i) {
                    list.add(target);
                }
            }
            if ((luArray = (ArrayList)cell.getObjectAttribute("luArray", lulayer)).contains("none") || cell.isSet("mixedUse", lulayer)) {
                count = noSewer ? outbound * this.nsDropWeight : outbound * this.sDropWeight;
                if (proplayer.isSet("DumbGrowth") && count > 1) {
                    count /= 2;
                }
                for (int i = 0; i < count; ++i) {
                    list.add(cell);
                }
            }
            this.tables.put(cell, list);
        }
    }

    public void spawnAgents() {
        this.agents.clear();
        int[] added = new int[4];
        float[] growthRate = new float[4];
        Map map = this.root.getScenario().getMap();
        String[] luType = Main.luNames;
        Layer layer = map.getLayer("landuse");
        int total = 0;
        for (int i = 0; i < 4; ++i) {
            growthRate[i] = this.root.getScore(luType[i]);
        }
        Iterator citer = map.getCells().iterator();
        while (citer.hasNext()) {
            MapCell cell = (MapCell)citer.next();
            ArrayList list = (ArrayList)cell.getObjectAttribute("luArray", layer);
            for (int i = 0; i < list.size(); ++i) {
                String lu = (String)list.get(i);
                for (int j = 0; j < 4; ++j) {
                    if (!luType[j].equals(lu) || !(this.rng.nextFloat() < growthRate[j])) continue;
                    this.agents.add(new GrowthAgent(this, lu, cell));
                    int n = j;
                    added[n] = added[n] + 1;
                    ++total;
                }
            }
        }
        this.summary = "<ul>";
        for (int i = 0; i < 4; ++i) {
            this.summary = this.summary + "<li>" + added[i] + " " + luType[i] + "s</li>";
        }
        this.summary = this.summary + "</ul> Total: " + total;
    }

    public void doAgents() {
        Collections.shuffle(this.agents, this.rng);
        for (int i = 0; i < this.agents.size(); ++i) {
            GrowthAgent a = (GrowthAgent)this.agents.get(i);
            a.go();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Growth Debug");
        GameRoot root = new GameRoot();
        Map m = root.getScenario().getMap();
        Random rng = new Random(2222L);
        HurricaneHex.debug = true;
        view = new MapView(m, class$dd$hurricane$HurricaneHex == null ? (class$dd$hurricane$HurricaneHex = GrowthManager.class$("dd.hurricane.HurricaneHex")) : class$dd$hurricane$HurricaneHex);
        f.getContentPane().add(view);
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        GrowthManager gm = new GrowthManager(root, rng);
        gm.go();
        view.repaint();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

