/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.sim.MapCell;
import dd.sim.SimObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Layer
extends SimObject {
    private MapCell[][] cells;
    private String name;

    public Layer() {
        this.name = "UNNAMED LAYER";
    }

    public Layer(String layerName) {
        this.name = layerName;
    }

    public String getName() {
        return this.name;
    }

    protected void setCells(MapCell[][] mapCells) {
        this.cells = mapCells;
    }

    public float getAttribute(String attributeName, MapCell cell) {
        return cell.getAttribute(attributeName, this);
    }

    public Object getObjectAttribute(String attributeName, MapCell cell) {
        return cell.getObjectAttribute(attributeName, this);
    }

    public MapCell cellWithMinValue(String attributeName) {
        MapCell targetCell = this.cells[0][0];
        float minSoFar = targetCell.getAttribute(attributeName, this);
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                float val;
                if (this.cells[i][j] == null || !((val = this.cells[i][j].getAttribute(attributeName, this)) < minSoFar)) continue;
                minSoFar = val;
                targetCell = this.cells[i][j];
            }
        }
        return targetCell;
    }

    public MapCell cellWithMaxValue(String attributeName) {
        MapCell targetCell = this.cells[0][0];
        float maxSoFar = targetCell.getAttribute(attributeName, this);
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                float val;
                if (this.cells[i][j] == null || !((val = this.cells[i][j].getAttribute(attributeName, this)) > maxSoFar)) continue;
                maxSoFar = val;
                targetCell = this.cells[i][j];
            }
        }
        return targetCell;
    }

    public MapCell cellWithMinValue(String attributeName, Collection cells) {
        Iterator cellIter = cells.iterator();
        if (!cellIter.hasNext()) {
            return null;
        }
        MapCell targetCell = (MapCell)cellIter.next();
        float minSoFar = targetCell.getAttribute(attributeName, this);
        while (cellIter.hasNext()) {
            MapCell currentCell = (MapCell)cellIter.next();
            float val = currentCell.getAttribute(attributeName, this);
            if ((double)val == -99.99 || !(val < minSoFar)) continue;
            minSoFar = val;
            targetCell = currentCell;
        }
        return targetCell;
    }

    public MapCell cellWithMaxValue(String attributeName, Collection cells) {
        Iterator cellIter = cells.iterator();
        if (!cellIter.hasNext()) {
            return null;
        }
        MapCell targetCell = (MapCell)cellIter.next();
        float maxSoFar = targetCell.getAttribute(attributeName, this);
        while (cellIter.hasNext()) {
            MapCell currentCell = (MapCell)cellIter.next();
            float val = currentCell.getAttribute(attributeName, this);
            if ((double)val == -99.99 || !(val > maxSoFar)) continue;
            maxSoFar = val;
            targetCell = currentCell;
        }
        return targetCell;
    }

    public Collection cellsWithValuesInRange(String attributeName, float minValue, float maxValue) {
        ArrayList<MapCell> list = new ArrayList<MapCell>();
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                float val = this.cells[i][j].getAttribute(attributeName, this, -99.99f);
                if ((double)val == -99.99 || !(val >= minValue) || !(val <= maxValue)) continue;
                list.add(this.cells[i][j]);
            }
        }
        return list;
    }

    public MapCell cellWithValue(String attributeName, int value) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                if (value != (int)this.cells[i][j].getAttribute(attributeName, this, value + 1)) continue;
                return this.cells[i][j];
            }
        }
        return null;
    }
}

