/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.hurricane.Main;
import dd.sim.Layer;
import dd.sim.MapCell;
import dd.sim.SimObject;
import dd.util.HexCoordinate;
import dd.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Map
extends SimObject {
    private MapCell[][] cells;
    private Collection cachedList;
    private HashMap layers;
    private int mapWidth;
    private int mapHeight;
    public static final String EUCLIDEAN = "euclidean";
    public static final String CELL = "cell";

    public Map() {
        this.makeMap(20, 5);
        this.makeLayers();
    }

    public Map(int rows, int columns) {
        this.makeMap(rows, columns);
        this.makeLayers();
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    private void makeMap(int rows, int columns) {
        this.mapWidth = columns;
        this.mapHeight = rows;
        this.cells = new MapCell[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                this.cells[i][j] = new MapCell(this, i, j);
                this.cells[i][j].setX((double)j * 1.5);
                this.cells[i][j].setY((double)(rows - i) * Math.sqrt(3.0) - (double)(j & 1) * Math.sqrt(3.0) / 2.0);
            }
        }
        this.makeCache();
    }

    public void makeCache() {
        this.cachedList = new ArrayList(this.mapWidth * this.mapHeight);
        for (int i = 0; i < this.mapHeight; ++i) {
            for (int j = 0; j < this.mapWidth; ++j) {
                this.cachedList.add(this.cells[i][j]);
            }
        }
    }

    private void makeLayers() {
        this.layers = new HashMap();
    }

    public Layer createLayer(String layerName) {
        if (this.getLayer(layerName) != null) {
            return this.getLayer(layerName);
        }
        Layer l = new Layer(layerName);
        this.addLayer(l);
        return l;
    }

    public void copyLayer(String sourceLayerName, String targetLayerName) {
        String key;
        Layer source = this.createLayer(sourceLayerName);
        Layer target = this.createLayer(targetLayerName);
        Iterator attributes = source.getAttributes().keySet().iterator();
        while (attributes.hasNext()) {
            key = (String)attributes.next();
            target.setAttribute(key, StringUtils.duplicate(source.getObjectAttribute(key)));
        }
        for (int i = 0; i < this.mapHeight; ++i) {
            for (int j = 0; j < this.mapWidth; ++j) {
                attributes = this.cells[i][j].getLayerAttributes(source).keySet().iterator();
                while (attributes.hasNext()) {
                    key = (String)attributes.next();
                    this.cells[i][j].setAttribute(key, target, StringUtils.duplicate(this.cells[i][j].getObjectAttribute(key, source)));
                }
            }
        }
    }

    public void addLayer(Layer layer) {
        this.layers.put(layer.getName(), layer);
        layer.setCells(this.cells);
        for (int i = 0; i < this.mapHeight; ++i) {
            for (int j = 0; j < this.mapWidth; ++j) {
                this.cells[i][j].addLayer(layer);
            }
        }
    }

    public Collection getCells() {
        return this.cachedList;
    }

    public Collection getLayers() {
        return this.layers.values();
    }

    public MapCell cellAt(int row, int column) {
        if (row < 0 || column < 0 || row >= this.mapHeight || column >= this.mapWidth) {
            return null;
        }
        return this.cells[row][column];
    }

    public MapCell cellAt(String cellName) {
        StringTokenizer st = new StringTokenizer(cellName, "<, >");
        int row = Integer.parseInt(st.nextToken());
        int col = Integer.parseInt(st.nextToken());
        return this.cellAt(row, col);
    }

    public ArrayList getCells(String[] sites) {
        ArrayList<MapCell> list = new ArrayList<MapCell>();
        for (int i = 0; i < sites.length; ++i) {
            list.add(this.cellAt(sites[i]));
        }
        return list;
    }

    public void setCellAt(int row, int column, MapCell cell) {
        this.cells[row][column] = cell;
    }

    public MapCell northOf(MapCell cell) {
        return this.cellAt(cell.getRow() - 1, cell.getColumn());
    }

    public MapCell southOf(MapCell cell) {
        return this.cellAt(cell.getRow() + 1, cell.getColumn());
    }

    public MapCell northEastOf(MapCell cell) {
        if ((cell.getColumn() & 1) == 0) {
            return this.cellAt(cell.getRow() - 1, cell.getColumn() + 1);
        }
        return this.cellAt(cell.getRow(), cell.getColumn() + 1);
    }

    public MapCell northWestOf(MapCell cell) {
        if ((cell.getColumn() & 1) == 0) {
            return this.cellAt(cell.getRow() - 1, cell.getColumn() - 1);
        }
        return this.cellAt(cell.getRow(), cell.getColumn() - 1);
    }

    public MapCell southEastOf(MapCell cell) {
        if ((cell.getColumn() & 1) == 0) {
            return this.cellAt(cell.getRow(), cell.getColumn() + 1);
        }
        return this.cellAt(cell.getRow() + 1, cell.getColumn() + 1);
    }

    public MapCell southWestOf(MapCell cell) {
        if ((cell.getColumn() & 1) == 0) {
            return this.cellAt(cell.getRow(), cell.getColumn() - 1);
        }
        return this.cellAt(cell.getRow() + 1, cell.getColumn() - 1);
    }

    public Collection getNeighbors(MapCell cell) {
        ArrayList<MapCell> l = new ArrayList<MapCell>(6);
        if (this.northOf(cell) != null) {
            l.add(this.northOf(cell));
        }
        if (this.southOf(cell) != null) {
            l.add(this.southOf(cell));
        }
        if (this.northEastOf(cell) != null) {
            l.add(this.northEastOf(cell));
        }
        if (this.northWestOf(cell) != null) {
            l.add(this.northWestOf(cell));
        }
        if (this.southEastOf(cell) != null) {
            l.add(this.southEastOf(cell));
        }
        if (this.southWestOf(cell) != null) {
            l.add(this.southWestOf(cell));
        }
        return l;
    }

    public double eDistanceBetweenCells(MapCell cell1, MapCell cell2) {
        double dx = cell1.getX() - cell2.getX();
        double dy = cell1.getY() - cell2.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int cDistanceBetweenCells(MapCell cell1, MapCell cell2) {
        HexCoordinate c1 = new HexCoordinate(cell1);
        HexCoordinate c2 = new HexCoordinate(cell2);
        return HexCoordinate.distance(c1, c2);
    }

    public double distanceBetweenCells(MapCell cell1, MapCell cell2, String type) {
        if (type.equals(EUCLIDEAN)) {
            return this.eDistanceBetweenCells(cell1, cell2);
        }
        if (type.equals(CELL)) {
            return this.cDistanceBetweenCells(cell1, cell2);
        }
        return 0.0;
    }

    public Collection cellsWithin(MapCell cell, int distance) {
        return new ArrayList();
    }

    public Layer getLayer(String layerName) {
        return (Layer)this.layers.get(layerName);
    }

    public float getAttribute(String layerName, MapCell cell, String attributeName) {
        return cell.getAttribute(attributeName, this.getLayer(layerName));
    }

    public float getAttribute(String layerName, MapCell cell, String attributeName, float defaultValue) {
        return cell.getAttribute(attributeName, this.getLayer(layerName), defaultValue);
    }

    public Object getObjectAttribute(String layerName, MapCell cell, String attributeName) {
        return cell.getObjectAttribute(attributeName, this.getLayer(layerName));
    }

    public void setAttribute(String layerName, MapCell cell, String attributeName, float value) {
        cell.setAttribute(attributeName, this.getLayer(layerName), value);
    }

    public int luCount(String landuse, Layer layer) {
        return this.luCount(landuse, this.getCells(), layer);
    }

    public int luCount(String landuse, Collection c, Layer layer) {
        int result = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            result += this.luCount(landuse, (MapCell)iter.next(), layer);
        }
        return result;
    }

    public int luCount(String landuse, MapCell cell, Layer layer) {
        int result = 0;
        if ("all".equals(landuse)) {
            String[] lu = Main.luNames;
            for (int i = 0; i < lu.length; ++i) {
                result += this.luCount(lu[i], cell, layer);
            }
        } else {
            ArrayList a = (ArrayList)cell.getObjectAttribute("luArray", layer);
            for (int i = 0; i < a.size(); ++i) {
                String use = (String)a.get(i);
                if (!landuse.equals(use)) continue;
                ++result;
            }
        }
        return result;
    }

    public int luCount(String landuse) {
        return this.luCount(landuse, this.getLayer("landuse"));
    }

    public int luCount(String landuse, Collection c) {
        return this.luCount(landuse, c, this.getLayer("landuse"));
    }

    public int luCount(String landuse, MapCell cell) {
        return this.luCount(landuse, cell, this.getLayer("landuse"));
    }

    public static void main(String[] args) {
        Map mm = (Map)SimObject.readFromXML("dlug.xml");
        mm.writeXML("m.xml");
    }
}

