/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.SimObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MapCell
extends SimObject {
    private Map map;
    private int row;
    private int column;
    private double x;
    private double y;
    private Collection cachedNeighbors;

    public MapCell(Map map, int row, int column) {
        this.map = map;
        this.row = row;
        this.column = column;
    }

    public String getName() {
        return "<" + this.row + ", " + this.column + ">";
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public MapCell north() {
        return this.map.northOf(this);
    }

    public MapCell south() {
        return this.map.southOf(this);
    }

    public MapCell northEast() {
        return this.map.northEastOf(this);
    }

    public MapCell southEast() {
        return this.map.southEastOf(this);
    }

    public MapCell northWest() {
        return this.map.northWestOf(this);
    }

    public MapCell southWest() {
        return this.map.southWestOf(this);
    }

    public Collection getNeighbors() {
        if (this.cachedNeighbors == null) {
            this.cachedNeighbors = this.map.getNeighbors(this);
        }
        return this.cachedNeighbors;
    }

    public double eDistanceTo(MapCell anotherCell) {
        return this.map.eDistanceBetweenCells(this, anotherCell);
    }

    public double cDistanceTo(MapCell anotherCell) {
        return this.map.cDistanceBetweenCells(this, anotherCell);
    }

    public Collection cellsWithin(int distance) {
        return this.map.cellsWithin(this, distance);
    }

    public void addLayer(Layer layer) {
        if (this.attributes.get(layer) == null) {
            this.attributes.put(layer, new HashMap());
        }
    }

    public Collection getLayers() {
        ArrayList c = new ArrayList(this.attributes.size());
        Iterator iter = this.attributes.keySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Layer)) continue;
            c.add(o);
        }
        return c;
    }

    public java.util.Map getLayerAttributes(Layer layer) {
        return (java.util.Map)this.attributes.get(layer);
    }

    public boolean hasAttribute(String attributeName, Layer layer) {
        return this.getObjectAttribute(attributeName, layer) != null;
    }

    public float getAttribute(String attributeName, Layer layer) {
        Float retVal = (Float)this.getObjectAttribute(attributeName, layer);
        if (retVal == null) {
            throw new NoSuchElementException(attributeName);
        }
        return retVal.floatValue();
    }

    public List attributesInRange(Layer layer, float minValue, float maxValue) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = this.getLayerAttributes(layer).keySet().iterator();
        while (iter.hasNext()) {
            String currentAttribute = (String)iter.next();
            float attrValue = this.getAttribute(currentAttribute, layer);
            if (!(attrValue >= minValue) || !(attrValue <= maxValue)) continue;
            list.add(currentAttribute);
        }
        return list;
    }

    public float getAttribute(String attributeName, Layer layer, float defaultValue) {
        Float retVal = (Float)this.getObjectAttribute(attributeName, layer);
        if (retVal == null) {
            return defaultValue;
        }
        return retVal.floatValue();
    }

    public boolean isSet(String attributeName, Layer layer) {
        return this.getAttribute(attributeName, layer, 0.0f) != 0.0f;
    }

    public Object getObjectAttribute(String attributeName, Layer layer) {
        java.util.Map attrValues = (java.util.Map)this.attributes.get(layer);
        if (attrValues == null) {
            return null;
        }
        return attrValues.get(attributeName);
    }

    public void setAttribute(String attributeName, Layer layer, float value) {
        this.setAttribute(attributeName, layer, new Float(value));
    }

    public void setAttribute(String attributeName, Layer layer, Object value) {
        java.util.Map attrValues = (java.util.Map)this.attributes.get(layer);
        if (attrValues != null) {
            Object old = attrValues.get(attributeName);
            attrValues.put(attributeName, value);
            this.firePropertyChange(attributeName, old, value);
        }
    }

    public String printName() {
        return this.toString();
    }

    public String toString() {
        return "<" + this.row + ", " + this.column + ">";
    }
}

