/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.sim.SimObject;
import java.util.HashMap;

public class Player
extends SimObject
implements Comparable {
    private static HashMap players;
    private static final Player nobody;

    public static Player nobody() {
        return nobody;
    }

    public Player() {
        this.setAttribute("_playerID", "p0");
        this.setName("nobody");
        this.setAttribute("favors", 0.0f);
        this.setAttribute("votes", 0.0f);
        this.setAttribute("connected", 1.0f);
        this.setGlobalAttribute("favorsPerTurn", new Integer(6));
    }

    public Player(int turnNumber, String name) {
        this.setAttribute("_playerID", "p" + turnNumber);
        this.setAttribute("turnNumber", turnNumber);
        this.setAttribute("playerName", name);
        this.setAttribute("connected", 1.0f);
        this.reset();
    }

    public boolean isConnected() {
        return this.getAttribute("connected", 0.0f) == 1.0f;
    }

    public void disconnected() {
        this.setAttribute("connected", 0.0f);
    }

    public void setConnected(boolean connected) {
        this.setAttribute("connected", connected ? 1 : 0);
    }

    public String getName() {
        String name = (String)this.getObjectAttribute("playerName");
        if (!this.isConnected()) {
            name = name + " (*)";
        }
        return name;
    }

    public void setName(String name) {
        this.setAttribute("playerName", name);
    }

    public String getRole() {
        return (String)this.getObjectAttribute("playerRole");
    }

    public void setRole(String role) {
        this.setAttribute("playerRole", role);
    }

    public String getPlayerID() {
        return (String)this.getObjectAttribute("_playerID");
    }

    public int getTurnNumber() {
        return (int)this.getAttribute("turnNumber");
    }

    public int getFavorsPerTurn() {
        return (Integer)this.getGlobalAttribute("favorsPerTurn");
    }

    public void reset() {
        if (this == nobody) {
            return;
        }
        this.setAttribute("favors", this.getFavorsPerTurn());
        this.setAttribute("votes", 1.0f);
    }

    public void setVotes(int votes) {
        this.setAttribute("votes", 1.0f);
    }

    public int getVotes() {
        if (this == nobody) {
            return 0;
        }
        return (int)this.getAttribute("votes", 0.0f);
    }

    public int getFavors() {
        if (this == nobody) {
            return 0;
        }
        return (int)this.getAttribute("favors", 0.0f);
    }

    public void spendVotes(int votes) {
        while (votes > 0 && this.getVotes() > 0) {
            this.incrementAttribute("votes", -1.0f);
            --votes;
        }
        while (votes > 0) {
            this.incrementAttribute("favors", -1.0f);
            --votes;
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Player) {
            return this.getPlayerID().equals(((Player)other).getPlayerID());
        }
        return false;
    }

    public int compareTo(Object o) {
        Player other = (Player)o;
        if (this.getTurnNumber() < other.getTurnNumber()) {
            return -1;
        }
        if (this.getTurnNumber() > other.getTurnNumber()) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        Player p1 = new Player(1, "Joe Baggadonuts");
        p1.writeXML("joe.xml");
        Player p2 = (Player)SimObject.readFromXML("joe.xml");
        p2.log(p2.getName());
    }

    static {
        nobody = new Player();
    }
}

