/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.sim.ConfigParameter;
import dd.sim.CostTable;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Player;
import dd.sim.SimObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class Proposal
extends SimObject
implements Comparable {
    public static final String STATUS_KEY = "proposalStatus";
    public static final String STATUS_NEW = "New";
    public static final String STATUS_PLAYED = "Played";
    public static final String STATUS_PASSED = "Passed";
    public static final String STATUS_FAILED = "Failed";
    public static final String STATUS_WITHDRAWN = "Withdrawn";
    public static final String STATUS_UNPICKED = "Unpicked";
    public static final String STATUS_AUTOFAIL = "Autofail";
    public static final String STATUS_INFORMATIONAL = "Info";
    public static final String SUPPORT_PHRASE = "I support this proposal";
    public static final String OPPOSE_PHRASE = "I do not support this proposal";
    public static final String MAYBE_PHRASE = "I will support this proposal if...";
    public static CostTable costTable = GameRoot.getCostTable();
    public static final String SUPPORT = "SUPPORT";
    public static final String OPPOSE = "OPPOSE";

    public Proposal() {
        this.setStatus(STATUS_NEW);
        this.setOwnerID(Player.nobody().getPlayerID());
        this.setAttribute("configParameters", new ArrayList());
    }

    public Proposal(String title) {
        this();
        this.setTitle(title);
        this.setStatus(STATUS_INFORMATIONAL);
    }

    public boolean isActive() {
        return this.getStatus().equals(STATUS_NEW) || this.getStatus().equals(STATUS_PLAYED);
    }

    public String getTitle() {
        return (String)this.getObjectAttribute("proposalTitle");
    }

    public void setTitle(String title) {
        this.setAttribute("proposalTitle", title);
    }

    public int getTurn() {
        return (int)this.getAttribute("turn", 0.0f);
    }

    public void setTurn(int t) {
        this.setAttribute("turn", t);
    }

    public ArrayList getConfigParameters() {
        return (ArrayList)this.getObjectAttribute("configParameters");
    }

    public void addConfigParameter(ConfigParameter parameter) {
        ArrayList a = this.getConfigParameters();
        a.add(parameter);
    }

    public String getDescription() {
        return (String)this.getObjectAttribute("proposalDescription");
    }

    public void setDescription(String description) {
        this.setAttribute("proposalDescription", description);
    }

    public boolean ownedBy(Player p) {
        return p.getPlayerID().equals(this.getOwnerID());
    }

    public String getOwnerID() {
        return (String)this.getObjectAttribute("proposalOwnerID");
    }

    public void setOwnerID(String ownerID) {
        this.setAttribute("proposalOwnerID", ownerID);
    }

    public String getProposalID() {
        return (String)this.getObjectAttribute("proposalID");
    }

    public void setProposalID(String id) {
        this.setAttribute("proposalID", id);
    }

    private void setSocialCost(float cost) {
        this.setAttribute("proposalSocialCost", cost);
    }

    private void setEconCost(float cost) {
        this.setAttribute("proposalEconCost", cost);
    }

    public float getEconCost() {
        return this.getAttribute("proposalEconCost", 0.0f);
    }

    public float getSocialCost() {
        return this.getAttribute("proposalSocialCost", 0.0f);
    }

    public String getDebriefingText() {
        if (this.getObjectAttribute("debriefingText") != null) {
            return (String)this.getObjectAttribute("debriefingText");
        }
        StringBuffer s = new StringBuffer();
        Object val = this.getObjectAttribute("debriefingStart");
        if (val != null) {
            s.append(val);
            s.append("  ");
        }
        Iterator iter = this.getConfigParameters().iterator();
        while (iter.hasNext()) {
            ConfigParameter config = (ConfigParameter)iter.next();
            if (config.getType().equals("boolean")) {
                if (this.getAttribute(config.getPropertyName(), 0.0f) != 0.0f) {
                    s.append(config.getDebriefingText());
                }
            } else {
                s.append(config.getDebriefingText(this.getObjectAttribute(config.getPropertyName())));
            }
            s.append("  ");
        }
        val = this.getObjectAttribute("debriefingEnd");
        if (val != null) {
            s.append(val);
            s.append("  ");
        }
        return s.toString();
    }

    public Set getLegendIcons() {
        HashSet<Object> s = new HashSet<Object>();
        Iterator iter = this.getConfigParameters().iterator();
        if (this.getObjectAttribute("legendIcon") != null) {
            s.add(this.getObjectAttribute("legendIcon"));
        }
        while (iter.hasNext()) {
            ConfigParameter config = (ConfigParameter)iter.next();
            if (config.getType().equals("boolean") && this.getAttribute(config.getPropertyName(), 0.0f) != 0.0f && config.getObjectAttribute("legendIcon") != null) {
                s.add(config.getObjectAttribute("legendIcon"));
            }
            if (!config.getType().equals("choice") || config.getObjectAttribute("choiceLegendIcons") == null || this.getObjectAttribute(config.getPropertyName()) == null) continue;
            String val = (String)this.getObjectAttribute(config.getPropertyName());
            Iterator choices = ((List)config.getObjectAttribute("choices")).iterator();
            Iterator icons = ((List)config.getObjectAttribute("choiceLegendIcons")).iterator();
            while (choices.hasNext()) {
                if (val.equals(choices.next())) {
                    s.add(icons.next());
                    continue;
                }
                icons.next();
            }
        }
        return s;
    }

    public Set getMapIcons() {
        HashSet<Object> s = new HashSet<Object>();
        Iterator iter = this.getConfigParameters().iterator();
        if (this.getObjectAttribute("mapIcon") != null) {
            s.add(this.getObjectAttribute("mapIcon"));
        }
        while (iter.hasNext()) {
            ConfigParameter config = (ConfigParameter)iter.next();
            if (config.getType().equals("boolean") && this.getAttribute(config.getPropertyName(), 0.0f) != 0.0f && config.getObjectAttribute("mapIcon") != null) {
                s.add(config.getObjectAttribute("mapIcon"));
            }
            if (!config.getType().equals("choice") || config.getObjectAttribute("choiceMapIcons") == null || this.getObjectAttribute(config.getPropertyName()) == null) continue;
            String val = (String)this.getObjectAttribute(config.getPropertyName());
            Iterator choices = ((List)config.getObjectAttribute("choices")).iterator();
            Iterator icons = ((List)config.getObjectAttribute("choiceMapIcons")).iterator();
            while (choices.hasNext()) {
                if (val.equals(choices.next())) {
                    s.add(icons.next());
                    continue;
                }
                icons.next();
            }
        }
        return s;
    }

    public void calculateCosts() {
        int eCost = 0;
        int sCost = 0;
        Iterator configParameters = this.getConfigParameters().iterator();
        while (configParameters.hasNext()) {
            ConfigParameter config = (ConfigParameter)configParameters.next();
            if (config.getType().equals("boolean") && this.getAttribute(config.getPropertyName(), 0.0f) != 0.0f) {
                eCost += (int)config.getAttribute("dEconCost", 0.0f);
                sCost += (int)config.getAttribute("dSocialCost", 0.0f);
            }
            if (!config.getType().equals("choice")) continue;
            String val = (String)this.getObjectAttribute(config.getPropertyName());
            Iterator choices = ((List)config.getObjectAttribute("choices")).iterator();
            Iterator eCosts = ((List)config.getObjectAttribute("choiceDECost")).iterator();
            Iterator sCosts = ((List)config.getObjectAttribute("choiceDSCost")).iterator();
            if (val == null) {
                val = "";
            }
            while (choices.hasNext()) {
                if (val.equals(choices.next())) {
                    eCost += ((Integer)eCosts.next()).intValue();
                    sCost += ((Integer)sCosts.next()).intValue();
                    continue;
                }
                eCosts.next();
                sCosts.next();
            }
        }
        this.setEconCost((float)eCost + this.getAttribute("baseEconCost", 0.0f));
        this.setSocialCost((float)sCost + this.getAttribute("baseSocialCost", 0.0f));
    }

    public void configure(ConfigParameter c, boolean val) {
        this.setAttribute(c.getPropertyName(), val);
        this.resetCosts();
    }

    public void configure(ConfigParameter c, int index) {
        List list = (List)c.getObjectAttribute("choices");
        this.setAttribute(c.getPropertyName(), list.get(index));
        this.resetCosts();
    }

    public void configure(ConfigParameter c, String val) {
        this.setAttribute(c.getPropertyName(), val);
        this.resetCosts();
    }

    private void resetCosts() {
        String f = this.getFamily();
        String c = this.getConfigSum();
        this.setEconCost(costTable.getEconCost(f, c));
        this.setSocialCost(costTable.getSocialCost(f, c));
    }

    public String getConfigSum() {
        String sum = "c";
        Iterator iter = this.getConfigParameters().iterator();
        while (iter.hasNext()) {
            ConfigParameter c = (ConfigParameter)iter.next();
            if ("boolean".equals(c.getType())) {
                sum = this.getAttribute(c.getPropertyName(), 0.0f) != 0.0f ? sum + "Y" : sum + "N";
            }
            if (!"choice".equals(c.getType())) continue;
            String val = (String)this.getObjectAttribute(c.getPropertyName());
            if (val == null) {
                sum = sum + "-1";
                continue;
            }
            List choices = (List)c.getObjectAttribute("choices");
            sum = sum + choices.indexOf(val);
        }
        return sum;
    }

    public void configureFromSum(String configSum) {
        char[] c = configSum.toCharArray();
        if (c[0] != 'c') {
            this.error("invalid configuration string.  Proposal not configured.");
            return;
        }
        ArrayList p = this.getConfigParameters();
        if (p.size() != c.length - 1) {
            this.error("configSum length doesn't match number of configParameters.  Proposal not configured.");
            return;
        }
        for (int i = 0; i < p.size(); ++i) {
            ConfigParameter cp = (ConfigParameter)p.get(i);
            if (cp.getType().equals("boolean")) {
                if (c[i + 1] == 'Y') {
                    this.configure(cp, true);
                } else if (c[i + 1] == 'N') {
                    this.configure(cp, false);
                } else {
                    this.error("parameter " + (i + 1) + " has wrong type.  Proposal only partially configured.");
                    return;
                }
            }
            if (!cp.getType().equals("choice")) continue;
            int index = c[i + 1] - 48;
            if (index < 0 || index > 9) {
                this.error("invalid index for parameter " + (i + 1) + ".  Proposal only partially configured.");
                return;
            }
            this.configure(cp, index);
        }
    }

    public List enumerateConfigurations() {
        int i;
        ArrayList<SimObject> list1 = new ArrayList<SimObject>();
        ArrayList<Proposal> list2 = new ArrayList<Proposal>();
        ArrayList clist = this.getConfigParameters();
        list1.add(this.duplicate());
        for (i = 0; i < clist.size(); ++i) {
            list2.clear();
            ConfigParameter c = (ConfigParameter)clist.get(i);
            for (int j = 0; j < list1.size(); ++j) {
                Proposal p2;
                Proposal p1 = (Proposal)list1.get(j);
                if (c.getType().equals("boolean")) {
                    p2 = (Proposal)p1.duplicate();
                    p2.setAttribute(c.getPropertyName(), true);
                    list2.add(p2);
                    p2 = (Proposal)p1.duplicate();
                    p2.setAttribute(c.getPropertyName(), false);
                    list2.add(p2);
                }
                if (!c.getType().equals("choice")) continue;
                ArrayList choices = (ArrayList)c.getObjectAttribute("choices");
                for (int k = 0; k < choices.size(); ++k) {
                    p2 = (Proposal)p1.duplicate();
                    p2.setAttribute(c.getPropertyName(), (String)choices.get(k));
                    list2.add(p2);
                }
            }
            list1.clear();
            list1.addAll(list2);
        }
        for (i = 0; i < list1.size(); ++i) {
            ((Proposal)list1.get(i)).calculateCosts();
        }
        return list1;
    }

    public String getFamily() {
        return (String)this.getObjectAttribute("proposalFamily");
    }

    public void setFamily(String family) {
        this.setAttribute("proposalFamily", family);
    }

    public String getAbbrev() {
        String result = this.getFamily();
        result = result + ":";
        result = result + this.getConfigSum();
        return result;
    }

    public boolean isDuplicate(Proposal p) {
        if (p == null) {
            return false;
        }
        if (!this.getFamily().equals(p.getFamily())) {
            return false;
        }
        Iterator iter = this.getConfigParameters().iterator();
        while (iter.hasNext()) {
            ConfigParameter c = (ConfigParameter)iter.next();
            String name = c.getPropertyName();
            Object property = this.getObjectAttribute(name);
            if (!(property != null ? !property.equals(p.getObjectAttribute(name)) : p.getObjectAttribute(name) != null)) continue;
            return false;
        }
        return true;
    }

    public void enact(GameRoot root) {
        root.getScenario().spendBudget(this.getEconCost(), this.getSocialCost());
        Layer proposals = root.getScenario().getMap().getLayer("proposals");
        proposals.setAttribute(this.getFamily(), true);
        String s = this.getFamily() + " " + this.getConfigSum();
        ((ArrayList)proposals.getObjectAttribute("passedProposals")).add(s);
    }

    public void enact(GameRoot root, Random rng) {
        this.enact(root);
    }

    public String getPlayerOpinion(Player player) {
        return (String)this.getObjectAttribute("proposalSupportFor" + player.getPlayerID());
    }

    public String getPlayerOpinion(Player player, String defaultValue) {
        String r = this.getPlayerOpinion(player);
        if (r == null) {
            return defaultValue;
        }
        return r;
    }

    public void setPlayerOpinion(Player player, String pref) {
        this.setAttribute("proposalSupportFor" + player.getPlayerID(), pref);
    }

    public SimObject duplicate() {
        Proposal p = (Proposal)super.duplicate();
        Iterator<Object> iter = p.getAttributes().keySet().iterator();
        ArrayList<String> propsToRemove = new ArrayList<String>();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            if (!propName.startsWith("proposalSupportFor")) continue;
            propsToRemove.add(propName);
        }
        iter = propsToRemove.iterator();
        while (iter.hasNext()) {
            p.getAttributes().remove(iter.next());
        }
        return p;
    }

    public int getPlayerVotesFor(Player player) {
        return (int)this.getAttribute("proposalVoteFor" + player.getPlayerID(), 0.0f);
    }

    public int getPlayerVotesAgainst(Player player) {
        return (int)this.getAttribute("proposalVoteAgainst" + player.getPlayerID(), 0.0f);
    }

    public void castVote(String playerID, int newVote) {
        if (newVote < 0) {
            this.incrementAttribute("totalVotesAgainst", -newVote);
            this.incrementAttribute("proposalVoteAgainst" + playerID, -newVote);
        } else {
            this.incrementAttribute("totalVotesFor", newVote);
            this.incrementAttribute("proposalVoteFor" + playerID, newVote);
        }
    }

    public int getVotesFor() {
        return (int)this.getAttribute("totalVotesFor", 0.0f);
    }

    public int getVotesAgainst() {
        return (int)this.getAttribute("totalVotesAgainst", 0.0f);
    }

    public void resetVoteTally() {
        this.setAttribute("totalVotesFor", 0.0f);
        this.setAttribute("totalVotesAgainst", 0.0f);
        for (int i = 1; i <= 4; ++i) {
            String pid = "p" + i;
            this.setAttribute("proposalVoteFor" + pid, 0.0f);
            this.setAttribute("proposalVoteAgainst" + pid, 0.0f);
        }
    }

    public int getVoteTally() {
        return (int)this.getAttribute("totalVotesFor", 0.0f) - (int)this.getAttribute("totalVotesAgainst", 0.0f);
    }

    public String getStatus() {
        return (String)this.getObjectAttribute(STATUS_KEY);
    }

    public void setStatus(String status) {
        this.setAttribute(STATUS_KEY, status);
    }

    public int compareTo(Object o) {
        Proposal p1 = this;
        Proposal p2 = (Proposal)o;
        if ("End Turn Now".equals(p1.getTitle())) {
            if ("End Turn Now".equals(p2.getTitle())) {
                return 0;
            }
            return 1;
        }
        if ("End Turn Now".equals(p2.getTitle())) {
            return -1;
        }
        return p1.getTitle().compareTo(p2.getTitle());
    }

    public static void main(String[] args) {
        String file = "../contrib/dlug/proposals/Retrofit.xml";
        Proposal p = (Proposal)SimObject.readFromXML(file);
    }
}

