/*
 * Decompiled with CFR 0.152.
 */
package dd.sim;

import dd.util.Logger;
import dd.util.SimXMLReader;
import dd.util.SimXMLWriter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class SimObject
implements Serializable {
    protected HashMap attributes;
    private PropertyChangeSupport listeners;
    private Logger log;
    private static HashMap globalAttributes;

    public static List filter(Collection simObjects, String name, double value) {
        ArrayList<SimObject> l = new ArrayList<SimObject>(simObjects.size());
        Iterator iter = simObjects.iterator();
        while (iter.hasNext()) {
            SimObject o = (SimObject)iter.next();
            if ((double)o.getAttribute(name) != value) continue;
            l.add(o);
        }
        return l;
    }

    public static List filter(Collection simObjects, String name, Object value) {
        ArrayList<SimObject> l = new ArrayList<SimObject>(simObjects.size());
        Iterator iter = simObjects.iterator();
        while (iter.hasNext()) {
            SimObject o = (SimObject)iter.next();
            if (!value.equals(o.getObjectAttribute(name))) continue;
            l.add(o);
        }
        return l;
    }

    public SimObject() {
        if (globalAttributes == null) {
            globalAttributes = new HashMap();
        }
        this.attributes = new HashMap();
        this.listeners = new PropertyChangeSupport(this);
        this.log = Logger.getDefaultLog();
    }

    protected static void out(String message) {
        Logger.getDefaultLog().log(message);
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap attributes) {
        this.attributes = attributes;
    }

    public Object getGlobalAttribute(String attributeName) {
        return globalAttributes.get(attributeName);
    }

    public void setGlobalAttribute(String attributeName, Object value) {
        globalAttributes.put(attributeName, value);
    }

    public float getAttribute(String attributeName) {
        Number retVal = (Number)this.getObjectAttribute(attributeName);
        if (retVal == null) {
            throw new NoSuchElementException(attributeName);
        }
        return retVal.floatValue();
    }

    public float getAttribute(String attributeName, float defaultValue) {
        Float retVal = (Float)this.getObjectAttribute(attributeName);
        if (retVal == null) {
            return defaultValue;
        }
        return retVal.floatValue();
    }

    public Object getObjectAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public Object getObjectAttribute(String attributeName, Object defaultValue) {
        Object retVal = this.attributes.get(attributeName);
        if (retVal == null) {
            return defaultValue;
        }
        return retVal;
    }

    public void setAttribute(String attributeName, float value) {
        this.setAttribute(attributeName, new Float(value));
    }

    public void setAttribute(String attributeName, boolean value) {
        this.setAttribute(attributeName, value ? 1.0f : 0.0f);
    }

    public void setAttribute(String attributeName, Object value) {
        Object old = this.attributes.get(attributeName);
        this.attributes.put(attributeName, value);
        this.firePropertyChange(attributeName, old, value);
    }

    public void removeAttribute(String attributeName) {
        this.attributes.remove(attributeName);
    }

    public boolean isSet(String attributeName) {
        return this.getAttribute(attributeName, 0.0f) != 0.0f;
    }

    public void incrementAttribute(String attributeName) {
        this.incrementAttribute(attributeName, 1.0f);
    }

    public void incrementAttribute(String attributeName, float delta) {
        this.setAttribute(attributeName, this.getAttribute(attributeName, 0.0f) + delta);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void debug(String debugMessage) {
        this.log.debug(this.toString() + ": " + debugMessage);
    }

    public void log(String logMessage) {
        this.log.log(this.toString() + ": " + logMessage);
    }

    public void warning(String warningMessage) {
        this.log.warning(this.toString() + ": " + warningMessage);
    }

    public void error(String errorMessage) {
        this.log.error(this.toString() + ": " + errorMessage);
    }

    public void fatal(String errorMessage) {
        this.log.error(this.toString() + " FATAL: " + errorMessage);
        System.exit(1);
    }

    public static SimObject readFromXML(String fileName) {
        SimXMLReader reader = new SimXMLReader(fileName);
        return reader.read();
    }

    public static SimObject readFromXML(Reader reader) {
        SimXMLReader simReader = new SimXMLReader(reader);
        return simReader.read();
    }

    public void writeXML(String fileName) {
        SimXMLWriter writer = new SimXMLWriter(this);
        writer.write(fileName);
    }

    public String writeXML() {
        SimXMLWriter writer = new SimXMLWriter(this);
        return writer.write();
    }

    public String writeText() {
        StringBuffer s = new StringBuffer(4000);
        Iterator iter = this.getAttributes().keySet().iterator();
        s.append(this.getClass().getName());
        s.append('\n');
        while (iter.hasNext()) {
            Object key = iter.next();
            s.append(key.toString());
            s.append(' ');
            s.append(this.getObjectAttribute((String)key).toString());
            s.append('\n');
        }
        s.append("end\n");
        return s.toString();
    }

    public SimObject duplicate() {
        return SimObject.readFromXML(new StringReader(this.writeXML()));
    }
}

