/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AttributeEditor
implements PropertyChangeListener {
    static final String[] cols = new String[]{"Attribute", "Value"};
    private Map attributes;
    private JComponent ui;
    private MapTableModel tableModel;
    private JTable table;
    static /* synthetic */ Class class$java$lang$String;

    public AttributeEditor(Map nameValuePairs) {
        this.attributes = nameValuePairs;
        this.tableModel = new MapTableModel(this.attributes);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.tableModel != null) {
            this.tableModel.setMap(this.attributes);
            this.tableModel.fireTableDataChanged();
        }
    }

    public void setAttributes(Map m) {
        this.attributes = m;
        this.propertyChange(null);
    }

    public JComponent makeUI() {
        this.ui = Box.createVerticalBox();
        this.table = new JTable(this.tableModel);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
        JButton addButton = new JButton("Add Attribute");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(AttributeEditor.this.ui, (Object)"Attribute Name:");
                if (s != null && AttributeEditor.this.attributes.get(s) == null) {
                    AttributeEditor.this.attributes.put(s, new Float(0.0f));
                    AttributeEditor.this.tableModel.fireTableDataChanged();
                }
            }
        });
        JButton removeButton = new JButton("Remove Attribute");
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AttributeEditor.this.table.getSelectedRow() != -1) {
                    String attrName = (String)AttributeEditor.this.tableModel.getValueAt(AttributeEditor.this.table.getSelectedRow(), 0);
                    AttributeEditor.this.attributes.remove(attrName);
                    AttributeEditor.this.tableModel.fireTableDataChanged();
                }
            }
        });
        this.ui.add(scrollPane);
        this.ui.add(addButton);
        this.ui.add(removeButton);
        return this.ui;
    }

    public static void main(String[] args) {
        HashMap<String, Float> m = new HashMap<String, Float>();
        m.put("one", new Float(1.0f));
        m.put("second_value", new Float(2.0f));
        m.put("yellow", new Float(0.22f));
        m.put("anotherValue", new Float(72.2));
        for (int i = 0; i < 100; ++i) {
        }
        JFrame f = new JFrame("Attribute Test");
        AttributeEditor e = new AttributeEditor(m);
        f.getContentPane().add(e.makeUI());
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MapTableModel
    extends AbstractTableModel {
        private Map myMap;
        private Object[] keys;

        public MapTableModel(Map map) {
            this.myMap = map;
            this.keys = map.keySet().toArray(new Object[0]);
        }

        public void setMap(Map map) {
            this.myMap = map;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            this.keys = this.myMap.keySet().toArray(new Object[0]);
            return this.myMap.size();
        }

        public String getColumnName(int columnIndex) {
            return cols[columnIndex];
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.keys[row];
            }
            if (column == 1) {
                return this.myMap.get(this.keys[row]);
            }
            return null;
        }

        public Class getColumnClass(int column) {
            return class$java$lang$String == null ? (class$java$lang$String = AttributeEditor.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.myMap.put(this.keys[rowIndex], aValue);
        }
    }
}

