/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.GameRoot;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.ui.Robot;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;

public class AutoPlayer
extends Robot {
    private GameRoot root;
    private Proposal myProposal;
    private Proposal votingProposal;
    private boolean didAmendment = false;

    public void briefingEnded() {
        this.didAmendment = false;
        this.log.debug("AutoPlayer briefingEnded");
        this.tc.endBriefing();
    }

    public Player getPlayer(int turnNumber) {
        List s = SimObject.filter(this.root.getPlayers().values(), "turnNumber", turnNumber);
        if (s.size() > 1) {
            throw new IllegalStateException("player registry returned " + s.size() + " players with turnNumber of " + turnNumber);
        }
        if (s.size() < 1) {
            return Player.nobody();
        }
        return (Player)s.iterator().next();
    }

    public Player getCurrentPlayer() {
        return this.getPlayer(this.turnNumber);
    }

    public void setRoot(GameRoot r) {
        this.log.debug("AutoPlayer setRoot");
        this.root = r;
        this.log = this.root.getScenario().getMap();
        this.root.getProposalRegistry().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if ("registryElementAdded".equals(e.getPropertyName())) {
                    AutoPlayer.this.expressOpinions();
                }
            }
        });
    }

    public void beginNegotiationPhase() {
        this.log.debug("AutoPlayer beginNegotiationPhase");
        if (!this.didAmendment) {
            this.tc.randomProposal();
        }
        this.didAmendment = true;
    }

    private void expressOpinions() {
        Player me = this.getCurrentPlayer();
        Iterator possibleProposals = this.root.getPlayedProposals().iterator();
        while (possibleProposals.hasNext()) {
            Proposal p = (Proposal)possibleProposals.next();
            if (!p.getPlayerOpinion(me, "unset").equals("unset") || !p.ownedBy(this.getCurrentPlayer())) continue;
            this.tc.opinion(p.getProposalID(), "I support this proposal");
        }
    }

    public void prepareForVotingOn(Proposal proposal) {
        this.log.debug("AutoPlayer prepareForVotingOn: " + proposal);
        this.votingProposal = proposal;
    }

    public void startVote() {
        this.log.debug("AutoPlayer startVote");
        if (this.votingProposal.ownedBy(this.getCurrentPlayer())) {
            this.tc.vote(1);
        } else {
            this.tc.vote(Math.random() > 0.5 ? 1 : -1);
        }
    }
}

