/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.Player;
import dd.sim.Proposal;
import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import dd.ui.ProposalView;
import dd.util.CountdownTimer;
import dd.util.TimedAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BallotPanel
extends JPanel
implements PropertyChangeListener {
    private Box[] forVotes;
    private Box[] againstVotes;
    private GUIEvents dlug;
    private boolean voted;
    private boolean unlock;
    private JLabel votesFor;
    private JLabel votesAgainst;
    private JLabel currentStanding;
    private JLabel timeLeft;
    private Proposal proposal;
    JButton voteForButton;
    JButton voteAgainstButton;
    JButton unlockButton;
    TimedAction voteCountdown;

    public BallotPanel(GUIEvents dlugui) {
        this.dlug = dlugui;
        this.forVotes = new Box[4];
        this.againstVotes = new Box[4];
        this.voted = false;
        this.unlock = false;
    }

    public void prepareForVotingOn(Proposal p) {
        Box vBox = Box.createVerticalBox();
        this.removeAll();
        this.voted = false;
        this.unlock = false;
        if (p == null) {
            return;
        }
        this.voteCountdown = new TimedAction("Vote Countdown", 120){

            public void timerTick(CountdownTimer timer) {
                BallotPanel.this.timeLeft.setText(Integer.toString(timer.getTimeRemaining()));
            }

            public void doDefaultAction() {
                BallotPanel.this.dlug.votingTimerExpired();
            }
        };
        this.proposal = p;
        this.proposal.addPropertyChangeListener(this);
        ProposalView pView = new ProposalView(this.dlug);
        pView.setProposal(this.proposal);
        pView.makeSummaryView();
        pView.setBorder(BorderFactory.createTitledBorder("Proposal"));
        vBox.add(pView);
        JPanel votePanel = new JPanel(new GridBagLayout());
        votePanel.setBorder(BorderFactory.createTitledBorder("Vote"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        votePanel.add((Component)new JLabel("FOR"), gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        votePanel.add((Component)new JLabel("AGAINST"), gbc);
        this.voteForButton = new JButton(GameSupport.getImage("yes.png"));
        this.voteForButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BallotPanel.this.dlug.castVote(BallotPanel.this.proposal, 1);
                BallotPanel.this.voted = true;
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 1;
        votePanel.add((Component)this.voteForButton, gbc);
        this.voteAgainstButton = new JButton(GameSupport.getImage("no.png"));
        this.voteAgainstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BallotPanel.this.dlug.castVote(BallotPanel.this.proposal, -1);
                BallotPanel.this.voted = true;
            }
        });
        gbc.gridx = 2;
        gbc.gridy = 1;
        votePanel.add((Component)this.voteAgainstButton, gbc);
        this.votesFor = new JLabel("0");
        gbc.gridx = 0;
        gbc.gridy = 2;
        votePanel.add((Component)this.votesFor, gbc);
        this.votesAgainst = new JLabel("0");
        gbc.gridx = 2;
        gbc.gridy = 2;
        votePanel.add((Component)this.votesAgainst, gbc);
        this.currentStanding = new JLabel("FAIL");
        gbc.gridx = 1;
        gbc.gridy = 2;
        votePanel.add((Component)this.currentStanding, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        votePanel.add((Component)new JLabel(" "), gbc);
        for (int i = 0; i < 4; ++i) {
            gbc.gridy = i + 4;
            Player player = this.dlug.getPlayer(i + 1);
            JLabel name = new JLabel(player.getName());
            name.setForeground(this.dlug.getColor(player));
            gbc.gridx = 1;
            votePanel.add((Component)name, gbc);
            gbc.fill = 2;
            this.forVotes[i] = Box.createHorizontalBox();
            gbc.gridx = 0;
            votePanel.add((Component)this.forVotes[i], gbc);
            this.againstVotes[i] = Box.createHorizontalBox();
            gbc.gridx = 2;
            votePanel.add((Component)this.againstVotes[i], gbc);
            gbc.fill = 0;
        }
        vBox.add(votePanel);
        vBox.add(Box.createVerticalStrut(5));
        this.unlockButton = new JButton("Extra Votes");
        this.unlockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BallotPanel.this.unlock = true;
                BallotPanel.this.updateButtons();
            }
        });
        this.unlockButton.setEnabled(false);
        Box hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Use favors:  "));
        hBox.add(this.unlockButton);
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(10));
        hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Time Left: "));
        this.timeLeft = new JLabel(" ");
        hBox.add(this.timeLeft);
        hBox.add(Box.createHorizontalGlue());
        JButton dismissButton = new JButton("Done");
        dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BallotPanel.this.voteCountdown != null) {
                    BallotPanel.this.voteCountdown.pause();
                    BallotPanel.this.timeLeft.setText("0");
                }
                BallotPanel.this.dlug.votingTimerExpired();
            }
        });
        hBox.add(dismissButton);
        vBox.add(hBox);
        this.add(vBox);
    }

    public void startVotingTimer() {
        this.voteCountdown.reset();
        this.voteCountdown.start();
    }

    private void updateButtons() {
        if (!this.voted || this.unlock) {
            this.voteForButton.setEnabled(true);
            this.voteAgainstButton.setEnabled(true);
        } else {
            this.voteForButton.setEnabled(false);
            this.voteAgainstButton.setEnabled(false);
        }
        if (this.voted && !this.unlock) {
            this.unlockButton.setEnabled(true);
        } else {
            this.unlockButton.setEnabled(false);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Toolkit.getDefaultToolkit().beep();
                BallotPanel.this.updateButtons();
                if (BallotPanel.this.proposal.getVoteTally() > 0) {
                    BallotPanel.this.currentStanding.setText("PASS");
                } else if (BallotPanel.this.proposal.getVoteTally() < 0) {
                    BallotPanel.this.currentStanding.setText("FAIL");
                } else {
                    BallotPanel.this.currentStanding.setText("TIED");
                }
                BallotPanel.this.votesFor.setText("" + BallotPanel.this.proposal.getVotesFor());
                BallotPanel.this.votesAgainst.setText("" + BallotPanel.this.proposal.getVotesAgainst());
                for (int i = 0; i < 4; ++i) {
                    int j;
                    Player p = BallotPanel.this.dlug.getPlayer(i + 1);
                    BallotPanel.this.forVotes[i].removeAll();
                    BallotPanel.this.forVotes[i].add(Box.createHorizontalGlue());
                    for (j = 0; j < BallotPanel.this.proposal.getPlayerVotesFor(p); ++j) {
                        BallotPanel.this.forVotes[i].add(new JLabel(GameSupport.getImage("yes.png")));
                    }
                    BallotPanel.this.forVotes[i].add(Box.createHorizontalGlue());
                    BallotPanel.this.againstVotes[i].removeAll();
                    BallotPanel.this.againstVotes[i].add(Box.createHorizontalGlue());
                    for (j = 0; j < BallotPanel.this.proposal.getPlayerVotesAgainst(p); ++j) {
                        BallotPanel.this.againstVotes[i].add(new JLabel(GameSupport.getImage("no.png")));
                    }
                    BallotPanel.this.againstVotes[i].add(Box.createHorizontalGlue());
                }
            }
        });
    }
}

