/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.Briefing;
import dd.ui.GUIEvents;
import dd.ui.MapView;
import dd.ui.ProposalVisualizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class BriefingPanel
extends JPanel {
    private MapView mapView;
    private JTextPane textPane;
    private JLabel instructionLabel;
    private JLabel pageLabel;
    private Briefing briefing;
    private GUIEvents dlugui;
    private int page;
    private boolean done;
    private JButton nextButton;
    private JButton prevButton;
    private JButton doneButton;
    private JButton quitButton;

    public BriefingPanel(GUIEvents dlugui, MapView mapView) {
        this.setLayout(new BorderLayout());
        this.dlugui = dlugui;
        this.mapView = mapView;
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        scrollPane.setVerticalScrollBarPolicy(22);
        this.add((Component)scrollPane, "Center");
        Box hBox = Box.createHorizontalBox();
        this.add((Component)hBox, "South");
        this.prevButton = new JButton("<");
        hBox.add(this.prevButton);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BriefingPanel.this.prevPage();
            }
        });
        this.prevButton.setEnabled(false);
        hBox.add(Box.createHorizontalStrut(5));
        this.pageLabel = new JLabel(" ");
        hBox.add(this.pageLabel);
        hBox.add(Box.createHorizontalStrut(5));
        this.nextButton = new JButton(">");
        hBox.add(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BriefingPanel.this.nextPage();
            }
        });
        this.doneButton = new JButton("Done");
        hBox.add(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BriefingPanel.this.done();
            }
        });
        this.doneButton.setEnabled(false);
        hBox.add(Box.createHorizontalStrut(10));
        this.instructionLabel = new JLabel(" ");
        hBox.add(this.instructionLabel);
        this.quitButton = new JButton("Quit");
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.quitButton);
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.quitButton.setEnabled(false);
        this.quitButton.setVisible(false);
    }

    public void done() {
        this.doneButton.setEnabled(false);
        this.done = true;
        this.instructionLabel.setText("Waiting for other players...");
        this.dlugui.briefingEnded();
    }

    public void clear() {
        this.page = 0;
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.doneButton.setEnabled(false);
        this.instructionLabel.setText("");
        this.pageLabel.setText("");
        this.textPane.setContentType("text/html");
        this.textPane.setText("Waiting for server...");
        this.textPane.setCaretPosition(0);
    }

    public void setBriefing(Briefing b) {
        this.page = -1;
        this.done = false;
        this.briefing = b;
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(true);
        this.doneButton.setEnabled(false);
        this.instructionLabel.setText("");
        if (this.briefing.getFinal()) {
            this.doneButton.setVisible(false);
        }
        Pattern p = Pattern.compile("___ZZZ([^!]*)!!!");
        ArrayList text = b.getText();
        for (int i = 0; i < text.size(); ++i) {
            String s = (String)text.get(i);
            Matcher m = p.matcher(s);
            while (m.find()) {
                String url = m.group(1);
                String transformedUrl = this.getClass().getResource(url).toString();
                s = m.replaceFirst(transformedUrl);
                m = p.matcher(s);
            }
            text.set(i, s);
        }
        this.mapView.clearVisualizers();
        HashMap propViz = this.dlugui.getPropViz();
        Iterator iter = propViz.values().iterator();
        while (iter.hasNext()) {
            ProposalVisualizer pv = (ProposalVisualizer)iter.next();
            if (pv.proposal.getFamily().startsWith("EndTurn")) continue;
            this.mapView.add(pv);
        }
        this.mapView.makeTableOfContents();
        this.mapView.setMap(b.getGameRoot().getScenario().getMap());
        this.nextPage();
    }

    public void prevPage() {
        if (this.page < 1) {
            return;
        }
        --this.page;
        this.pageLabel.setText("" + (this.page + 1) + "/" + this.briefing.getText().size());
        this.nextButton.setEnabled(true);
        if (this.page == 0) {
            this.prevButton.setEnabled(false);
        }
        this.textPane.setContentType("text/html");
        this.textPane.setText((String)this.briefing.getText().get(this.page));
        this.mapView.setCurrentLayer((String)this.briefing.getLayers().get(this.page));
        this.textPane.setCaretPosition(0);
    }

    public void nextPage() {
        ++this.page;
        this.pageLabel.setText("" + (this.page + 1) + "/" + this.briefing.getText().size());
        if (this.page > 0) {
            this.prevButton.setEnabled(true);
        }
        if (this.page == this.briefing.getText().size() - 1) {
            if (!this.briefing.getFinal() && !this.done) {
                this.instructionLabel.setText("Click \"Done\" to begin turn");
                this.doneButton.setEnabled(true);
            }
            this.nextButton.setEnabled(false);
        }
        this.textPane.setContentType("text/html");
        this.textPane.setText((String)this.briefing.getText().get(this.page));
        this.mapView.setCurrentLayer((String)this.briefing.getLayers().get(this.page));
        this.textPane.setCaretPosition(0);
    }

    public void gameOver() {
        this.quitButton.setEnabled(true);
        this.quitButton.setVisible(true);
    }
}

