/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.net.NetClient;
import dd.sim.Player;
import dd.ui.GUIEvents;
import dd.util.Chat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ChatPanel
extends JPanel
implements Chat {
    private JTextPane chatLog;
    private JTextArea textInput;
    private Style userNameStyle;
    private Style messageStyle;
    private Style gameStyle;
    private Document chatDoc;
    private String myUserName;
    private Chat chatServer;
    private HashMap userStyles;
    private JLabel[] role;
    private JLabel[] player;
    private GUIEvents dlug;
    public static final String START_MESSAGE = "Chat Transcript\n\n";

    public ChatPanel() {
        this.myUserName = "**UNKNOWN**";
        this.chatServer = null;
        this.userStyles = new HashMap();
        this.makeUI();
    }

    public ChatPanel(String userName, Chat connectionToServer) {
        this.myUserName = userName;
        this.chatServer = connectionToServer;
        this.userStyles = new HashMap();
        this.makeUI();
    }

    public void setGUIEventTarget(GUIEvents parent) {
        this.dlug = parent;
    }

    public void setUserName(String userName) {
        this.myUserName = userName;
    }

    public void updateUsers() {
        this.setUserName(this.dlug.getCurrentPlayer().getName());
        for (int i = 0; i < 4; ++i) {
            Player p = this.dlug.getPlayer(i + 1);
            Color c = this.dlug.getColor(i + 1);
            String r = p.getRole();
            if (r == null) {
                r = "--";
            }
            this.addStyle(r + " (" + p.getName() + ")", c);
        }
    }

    public void makeUI() {
        this.setLayout(new BorderLayout());
        this.chatLog = new JTextPane();
        this.chatLog.setText(START_MESSAGE);
        this.chatLog.setEditable(false);
        this.chatDoc = this.chatLog.getDocument();
        JScrollPane scrollPane = new JScrollPane(this.chatLog);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setPreferredSize(new Dimension(200, 150));
        scrollPane.setBorder(BorderFactory.createTitledBorder("Chat"));
        this.makeDefaultStyles();
        this.add((Component)scrollPane, "Center");
        this.textInput = new JTextArea();
        this.textInput.setLineWrap(true);
        this.textInput.setWrapStyleWord(true);
        this.textInput.setRows(6);
        this.textInput.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "send");
        InputMap im = this.textInput.getInputMap(0);
        im.put(KeyStroke.getKeyStroke("ENTER"), "send");
        ActionMap am = this.textInput.getActionMap();
        am.put("send", new AbstractAction("send"){

            public void actionPerformed(ActionEvent evt) {
                Document d = ChatPanel.this.textInput.getDocument();
                try {
                    if (ChatPanel.this.chatServer != null) {
                        ChatPanel.this.chatServer.sendChatMessage(ChatPanel.this.myUserName, d.getText(0, d.getLength()));
                    }
                    d.remove(0, d.getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
        this.textInput.setActionMap(am);
        this.textInput.setBorder(BorderFactory.createTitledBorder("Input"));
        Box bottom = Box.createVerticalBox();
        bottom.add(this.textInput);
        bottom.add(new JLabel("Press 'Enter' to send."));
        this.add((Component)bottom, "South");
    }

    public void makeDefaultStyles() {
        Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(defStyle, "SansSerif");
        this.userNameStyle = this.chatLog.addStyle("userName", defStyle);
        StyleConstants.setBold(this.userNameStyle, true);
        this.messageStyle = this.chatLog.addStyle("message", defStyle);
        this.gameStyle = this.chatLog.addStyle("game", this.userNameStyle);
        StyleConstants.setForeground(this.gameStyle, new Color(96, 96, 96));
    }

    public void addStyle(String user, Color userColor) {
        Style userStyle = this.chatLog.addStyle("user" + user, this.messageStyle);
        StyleConstants.setForeground(userStyle, userColor);
        StyleConstants.setBold(userStyle, true);
        this.userStyles.put(user, userStyle);
    }

    public void gotChatMessage(String user, String message) {
        Style s = this.userNameStyle;
        message = message + "\n";
        try {
            s = (Style)this.userStyles.get(user);
            if (s == null) {
                s = this.gameStyle;
            }
            if (this.dlug != null) {
                this.dlug.gotUserMessage(StyleConstants.getForeground(s));
            }
            this.chatDoc.insertString(this.chatDoc.getLength(), user + ":  ", s);
            s = this.messageStyle;
            this.chatDoc.insertString(this.chatDoc.getLength(), message, s);
            this.chatLog.setCaretPosition(this.chatDoc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void sendChatMessage(String user, String message) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Chat debug");
        frame.setDefaultCloseOperation(3);
        try {
            NetClient netConnection = new NetClient();
            ChatPanel me = new ChatPanel("Debug User", netConnection);
            netConnection.setChatClient(me);
            frame.getContentPane().add(me);
            frame.pack();
            frame.setVisible(true);
        }
        catch (IOException e) {
            System.exit(1);
        }
    }
}

