/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ChooseGame {
    protected String[] games;
    protected JTree gameTree;
    protected JFrame f;
    protected GUIEvents dlug;
    protected Timer refreshList;
    protected DefaultTreeModel gameTreeModel;
    protected DefaultMutableTreeNode top;

    public ChooseGame(GUIEvents target, String[] games) {
        this.dlug = target;
        this.f = new JFrame("DD Game Chooser");
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel("Available games:"));
        this.top = new DefaultMutableTreeNode("Games");
        this.gameTreeModel = new DefaultTreeModel(this.top);
        this.gameTree = new JTree(this.gameTreeModel);
        this.gameTree.getSelectionModel().setSelectionMode(1);
        this.gameTree.setCellRenderer(new PlayerLabel());
        JScrollPane p = new JScrollPane(this.gameTree);
        p.setPreferredSize(new Dimension(100, 150));
        vBox.add(p);
        JButton joinButton = new JButton("Join");
        joinButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChooseGame.this.doJoinButton();
            }
        });
        vBox.add(joinButton);
        this.refreshList = new Timer(4000, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseGame.this.dlug.refreshGameList();
            }
        });
        this.refreshList.start();
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        vBox.add(quitButton);
        this.f.getContentPane().add(vBox);
        this.f.setDefaultCloseOperation(3);
        this.f.pack();
        this.f.setVisible(true);
        GameSupport.centerWindow(this.f);
        this.dlug.refreshGameList();
    }

    public void doJoinButton() {
        boolean reconnecting = false;
        TreePath path = this.gameTree.getSelectionPath();
        if (path == null || path.getPathCount() != 3) {
            JOptionPane.showMessageDialog(this.f, "Double click on a game and click on a role you wish to join.");
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
        String userName = (String)n.getUserObject();
        if (userName.indexOf(42) != -1) {
            userName = userName.substring(3, userName.indexOf(40) - 1);
            int retVal = JOptionPane.showConfirmDialog(this.f, "Do you want to reconnect to this game as user \"" + userName + "\"?", "Reconnect", 0);
            if (retVal != 0) {
                return;
            }
            reconnecting = true;
        }
        String gameName = (String)((DefaultMutableTreeNode)n.getParent()).getUserObject();
        int playerIndex = n.getParent().getIndex(n);
        if (reconnecting) {
            if (gameName.indexOf(40) >= 0) {
                gameName = gameName.substring(0, gameName.indexOf(40) - 1);
            }
            this.dlug.rejoinGame(gameName, playerIndex + 1);
        } else if (gameName.indexOf(40) >= 0) {
            JOptionPane.showMessageDialog(null, "That game is full");
        } else {
            this.dlug.joinGame(gameName, playerIndex + 1);
        }
    }

    public void setGameList(String[] gameList) {
        if (this.top.isLeaf()) {
            for (int i = 0; i < gameList.length; i += 5) {
                DefaultMutableTreeNode game = new DefaultMutableTreeNode(gameList[i]);
                game.add(new DefaultMutableTreeNode(gameList[i + 1]));
                game.add(new DefaultMutableTreeNode(gameList[i + 2]));
                game.add(new DefaultMutableTreeNode(gameList[i + 3]));
                game.add(new DefaultMutableTreeNode(gameList[i + 4]));
                this.top.add(game);
            }
            this.gameTreeModel.nodeStructureChanged(this.top);
        } else {
            Enumeration<TreeNode> e = this.top.depthFirstEnumeration();
            for (int i = 0; i < gameList.length; i += 5) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                if (!n.getUserObject().equals(gameList[i + 1])) {
                    n.setUserObject(gameList[i + 1]);
                    this.gameTreeModel.nodeChanged(n);
                }
                if (!(n = (DefaultMutableTreeNode)e.nextElement()).getUserObject().equals(gameList[i + 2])) {
                    n.setUserObject(gameList[i + 2]);
                    this.gameTreeModel.nodeChanged(n);
                }
                if (!(n = (DefaultMutableTreeNode)e.nextElement()).getUserObject().equals(gameList[i + 3])) {
                    n.setUserObject(gameList[i + 3]);
                    this.gameTreeModel.nodeChanged(n);
                }
                if (!(n = (DefaultMutableTreeNode)e.nextElement()).getUserObject().equals(gameList[i + 4])) {
                    n.setUserObject(gameList[i + 4]);
                    this.gameTreeModel.nodeChanged(n);
                }
                if ((n = (DefaultMutableTreeNode)e.nextElement()).getUserObject().equals(gameList[i])) continue;
                n.setUserObject(gameList[i]);
                this.gameTreeModel.nodeChanged(n);
            }
        }
    }

    public void close() {
        this.refreshList.stop();
        this.refreshList = null;
        this.f.setVisible(false);
    }

    private class PlayerLabel
    extends DefaultTreeCellRenderer {
        private PlayerLabel() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            String theName = (String)((DefaultMutableTreeNode)value).getUserObject();
            if (theName.length() > 3 && theName.charAt(1) == '.' && Character.isDigit(theName.charAt(0))) {
                int playerNum = theName.charAt(0) - 48;
                this.setForeground(ChooseGame.this.dlug.getColor(playerNum));
            }
            return this;
        }
    }
}

