/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.ui.GUIEvents;
import dd.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;

public class HelpPanel
extends JPanel
implements HyperlinkListener {
    private GUIEvents dlug;
    private JTextPane pane;
    private JScrollPane scrollPane;
    private ArrayList pageHistory;
    private int historyIndex;
    private JButton nextButton;
    private JButton prevButton;
    private JButton homeButton;

    public HelpPanel(GUIEvents dlugui) {
        this.dlug = dlugui;
        this.setLayout(new BorderLayout());
        this.pageHistory = new ArrayList();
        Box hBox = Box.createHorizontalBox();
        this.prevButton = new JButton("Back");
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpPanel.this.doPreviousButton();
            }
        });
        this.nextButton = new JButton("Next");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpPanel.this.doNextButton();
            }
        });
        this.homeButton = new JButton("Home");
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpPanel.this.doHomeButton();
            }
        });
        hBox.add(this.prevButton);
        hBox.add(this.nextButton);
        hBox.add(this.homeButton);
        this.pane = new JTextPane();
        this.scrollPane = new JScrollPane(this.pane);
        this.add((Component)hBox, "North");
        this.add((Component)this.scrollPane, "Center");
        this.pane.addHyperlinkListener(this);
        this.pane.setEditable(false);
        try {
            this.pane.setPage(this.getClass().getResource("/resources/dlug/help.html"));
        }
        catch (IOException e) {
            Logger.getDefaultLog().error("Error loading help file");
        }
        this.pageHistory.add(this.pane.getDocument());
        this.historyIndex = 0;
        this.updateButtons();
    }

    private void updateHistory() {
        if (this.pane.getDocument() == this.pageHistory.get(this.historyIndex)) {
            return;
        }
        this.pageHistory.subList(this.historyIndex + 1, this.pageHistory.size()).clear();
        this.pageHistory.add(this.pane.getDocument());
        this.historyIndex = this.pageHistory.size() - 1;
    }

    private void updateButtons() {
        this.prevButton.setEnabled(this.historyIndex > 0);
        this.nextButton.setEnabled(this.historyIndex < this.pageHistory.size() - 1);
    }

    private void doPreviousButton() {
        if (this.historyIndex < 1) {
            return;
        }
        --this.historyIndex;
        this.pane.setDocument((Document)this.pageHistory.get(this.historyIndex));
        this.updateButtons();
    }

    private void doNextButton() {
        if (this.historyIndex >= this.pageHistory.size() - 1) {
            return;
        }
        ++this.historyIndex;
        this.pane.setDocument((Document)this.pageHistory.get(this.historyIndex));
        this.updateButtons();
    }

    public void doHomeButton() {
        this.pane.setDocument((Document)this.pageHistory.get(0));
        this.updateHistory();
        this.updateButtons();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        JTextPane text = (JTextPane)e.getSource();
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                text.setDocument(text.getEditorKit().createDefaultDocument());
                if (e.getURL().toString().endsWith("scenario.html")) {
                    text.setText(this.dlug.getRoot().getScenario().getIntro());
                    ((HTMLDocument)text.getDocument()).setBase(e.getURL());
                } else if (e.getURL().toString().endsWith("proposals.html")) {
                    text.setText(this.dlug.getRoot().getProposalsPage());
                    ((HTMLDocument)text.getDocument()).setBase(e.getURL());
                } else {
                    text.setPage(e.getURL());
                }
            }
            catch (IOException ex) {
                Logger.getDefaultLog().error("Error loading help file");
            }
            text.setCaretPosition(0);
            this.updateHistory();
            this.updateButtons();
        }
    }

    public void setPage(String location) {
        try {
            this.pane.setPage(this.getClass().getResource(location));
        }
        catch (IOException e) {
            Logger.getDefaultLog().error("Error loading help file");
        }
        this.updateHistory();
        this.updateButtons();
    }

    public void setPageHTML(String htmlContent) {
        this.pane.setText(htmlContent);
    }
}

