/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.MapCell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HexView
implements PropertyChangeListener {
    protected Polygon defaultShape;
    private int[] xPoints;
    private int[] yPoints;
    private static Color[] pulseColorRamp;
    protected ImageIcon[] icons;
    private Color myColor;
    private Color myHilite;
    protected MapCell myCell;
    protected int xPosition;
    protected int yPosition;
    protected int width;
    protected int height;
    private JComponent parent;
    private float pulse;
    private float pulseStep;
    private boolean pulsing;
    protected boolean hilite;
    private boolean filled;
    public static boolean fillHexes;

    public HexView() {
        double xScaleFactor = (double)this.defaultCellWidth() / 24.0;
        double yScaleFactor = (double)this.defaultCellHeight() / 28.0;
        this.icons = null;
        this.parent = new JLabel("none");
        this.pulsing = false;
        this.pulseStep = 0.2f;
        if (pulseColorRamp == null) {
            pulseColorRamp = new Color[256];
            for (int i = 0; i < 256; ++i) {
                HexView.pulseColorRamp[i] = new Color(i, 0, 0);
            }
        }
        this.xPoints = new int[6];
        this.xPoints[0] = (int)(xScaleFactor * 32.0);
        this.xPoints[1] = (int)(xScaleFactor * 24.0);
        this.xPoints[2] = (int)(xScaleFactor * 8.0);
        this.xPoints[3] = (int)(xScaleFactor * 0.0);
        this.xPoints[4] = (int)(xScaleFactor * 8.0);
        this.xPoints[5] = (int)(xScaleFactor * 24.0);
        this.yPoints = new int[6];
        this.yPoints[0] = (int)(yScaleFactor * 14.0);
        this.yPoints[1] = (int)(yScaleFactor * 28.0);
        this.yPoints[2] = (int)(yScaleFactor * 28.0);
        this.yPoints[3] = (int)(yScaleFactor * 14.0);
        this.yPoints[4] = (int)(yScaleFactor * 0.0);
        this.yPoints[5] = (int)(yScaleFactor * 0.0);
        this.defaultShape = new Polygon(this.xPoints, this.yPoints, 6);
        this.myColor = Color.white;
        this.myHilite = Color.cyan;
        this.setSize((int)(xScaleFactor * 32.0), (int)(yScaleFactor * 28.0));
    }

    public Point getVertex(int vertexNum) {
        return new Point(this.xPosition + this.xPoints[vertexNum], this.yPosition + this.yPoints[vertexNum]);
    }

    public Point bottomCenter() {
        return new Point(this.xPosition + this.width / 2, this.yPosition + this.height);
    }

    public Point center() {
        return new Point(this.xPosition + this.width / 2, this.yPosition + this.height / 2);
    }

    public void hilite() {
        this.hilite = true;
    }

    public void unhilite() {
        this.hilite = false;
    }

    public void pulse() {
        this.pulsing = true;
    }

    public void unpulse() {
        this.pulsing = false;
    }

    public void clear() {
        this.unpulse();
        this.unhilite();
        this.icons = null;
    }

    public void setCell(MapCell cell) {
        if (this.myCell != null) {
            this.myCell.removePropertyChangeListener(this);
        }
        this.myCell = cell;
        cell.addPropertyChangeListener(this);
    }

    public void addIcon(ImageIcon i) {
        if (i == null) {
            return;
        }
        if (this.icons == null) {
            this.icons = new ImageIcon[1];
            this.icons[0] = i;
        } else {
            ImageIcon[] newArray = new ImageIcon[this.icons.length + 1];
            for (int count = 0; count < this.icons.length; ++count) {
                newArray[count] = this.icons[count];
            }
            newArray[count] = i;
            this.icons = newArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeIcon(ImageIcon i) {
        if (i == null) {
            return;
        }
        if (this.icons == null) {
            return;
        }
        if (this.icons.length == 1) {
            if (i != this.icons[0]) return;
            this.icons = null;
            return;
        } else {
            int index;
            boolean found = false;
            ImageIcon[] newArray = new ImageIcon[this.icons.length - 1];
            for (index = 0; !found && index < this.icons.length; ++index) {
                if (this.icons[index] == i) {
                    found = true;
                    continue;
                }
                newArray[index] = this.icons[index];
            }
            if (!found) return;
            while (index < this.icons.length) {
                newArray[index - 1] = this.icons[index];
                ++index;
            }
            this.icons = newArray;
        }
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setMyColor(Color color) {
        this.myColor = color;
        this.filled = this.myColor != null;
    }

    public void setParent(JComponent component) {
        this.parent = component;
    }

    public JComponent getParent() {
        return this.parent;
    }

    public boolean contains(int xLoc, int yLoc) {
        return this.defaultShape.contains(xLoc, yLoc);
    }

    public int defaultCellWidth() {
        return 24;
    }

    public int defaultCellHeight() {
        return 28;
    }

    public MapCell getCell() {
        return this.myCell;
    }

    public void setLocation(int xLoc, int yLoc) {
        this.defaultShape.translate(xLoc - this.xPosition, yLoc - this.yPosition);
        this.xPosition = xLoc;
        this.yPosition = yLoc;
    }

    public void paint(Graphics g) {
        if (this.hilite) {
            g.setColor(this.myHilite);
        } else {
            g.setColor(this.myColor);
        }
        if (this.filled && fillHexes) {
            g.fillPolygon(this.defaultShape);
        }
        if (this.pulsing) {
            g.setColor(pulseColorRamp[(int)(this.pulse * 255.0f)]);
            g.fillPolygon(this.defaultShape);
            this.pulse += this.pulseStep;
            if (this.pulse < 0.0f) {
                this.pulse = 0.0f;
                this.pulseStep = -this.pulseStep;
            }
            if (this.pulse > 1.0f) {
                this.pulse = 1.0f;
                this.pulseStep = -this.pulseStep;
            }
        }
        g.setColor(Color.black);
        g.drawPolygon(this.defaultShape);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.cellContentsChanged();
    }

    public void cellContentsChanged() {
        this.parent.repaint();
    }
}

