/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Main;
import dd.hurricane.Scenario;
import dd.ui.GUIEvents;
import dd.ui.MessagePanel;
import dd.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InfoPanel
extends JPanel {
    private GUIEvents dlug;
    private JLabel turn;
    private ScoreBar[] score;
    private ScoreBar ecobar;
    private ScoreBar hazbar;
    private MessagePanel messagePanel;

    public InfoPanel(GUIEvents dlug) {
        this.dlug = dlug;
        this.setLayout(new BorderLayout());
        this.score = new ScoreBar[4];
        Box outer = Box.createVerticalBox();
        this.add((Component)outer, "Center");
        Box top = Box.createHorizontalBox();
        top.add(new JLabel(dlug.getRoot().getScenario().getName() + " Scenario"));
        this.turn = new JLabel();
        top.add(this.turn);
        top = Box.createHorizontalBox();
        top.setBorder(BorderFactory.createTitledBorder("Info"));
        this.add((Component)outer, "North");
        outer.add(Box.createVerticalStrut(15));
        Box scoreBox = Box.createVerticalBox();
        outer.add(scoreBox);
        scoreBox.add(Box.createHorizontalStrut(365));
        scoreBox.setBorder(BorderFactory.createTitledBorder("Scores"));
        Box hBox = Box.createHorizontalBox();
        Box left = Box.createVerticalBox();
        Box right = Box.createVerticalBox();
        hBox.add(left);
        hBox.add(right);
        scoreBox.add(hBox);
        for (int i = 0; i < 4; ++i) {
            String metric = Main.luNames[i];
            left.add(new JLabel(StringUtils.capitalize(metric) + " Growth"));
            hBox = Box.createHorizontalBox();
            right.add(hBox);
            hBox.add(new JLabel(" "));
            this.score[i] = new ScoreBar(dlug, metric);
            hBox.add(this.score[i]);
        }
        left.add(new JLabel("Ecology"));
        hBox = Box.createHorizontalBox();
        right.add(hBox);
        hBox.add(new JLabel(" "));
        this.ecobar = new ScoreBar(dlug, "ecology");
        hBox.add(this.ecobar);
        left.add(new JLabel("Hazard"));
        hBox = Box.createHorizontalBox();
        right.add(hBox);
        hBox.add(new JLabel(" "));
        this.hazbar = new ScoreBar(dlug, "hazard");
        hBox.add(this.hazbar);
        left.add(new JLabel("Scale:"));
        hBox = Box.createHorizontalBox();
        right.add(hBox);
        hBox.add(new JLabel("0"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(new JLabel("0.5"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(new JLabel("1"));
        outer.add(Box.createVerticalGlue());
        this.messagePanel = new MessagePanel();
        outer.add(this.messagePanel);
    }

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    public void rootChanged() {
        for (int i = 0; i < 4; ++i) {
            this.score[i].update();
        }
        this.ecobar.update();
        this.hazbar.update();
        this.repopulate();
    }

    public void repopulate() {
        Scenario s = this.dlug.getRoot().getScenario();
        this.turn.setText("  Turn " + s.getTurn());
        this.validate();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Score");
        f.getContentPane().add(new InfoPanel(new Main()));
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    class ScoreBar
    extends JComponent {
        private GUIEvents dlug;
        public Color color;
        private Color oldcolor;
        private float value;
        private float oldval;
        private String metric;

        public ScoreBar(GUIEvents dlug, String metric) {
            this.dlug = dlug;
            this.value = 0.0f;
            this.oldval = 0.0f;
            this.metric = metric;
            this.color = Main.getColor(metric);
            this.oldcolor = new Color(255, 255, 255, 128);
        }

        public void paint(Graphics g) {
            if ("hazard".equals(this.metric) || "ecology".equals(this.metric)) {
                Color c2;
                Color c1;
                Graphics2D g2d = (Graphics2D)g;
                if ("hazard".equals(this.metric)) {
                    c1 = Color.yellow;
                    c2 = Color.red;
                } else {
                    c1 = new Color(0.37f, 0.22f, 0.22f);
                    c2 = new Color(0.0f, 0.83f, 0.0f);
                }
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, c1, this.getWidth(), 0.0f, c2);
                g2d.setPaint(gradient);
                g2d.fillRect(0, 6, (int)((float)this.getWidth() * this.value), this.getHeight() - 6);
                g2d.fillRect(0, 3, (int)((float)this.getWidth() * this.oldval), 2);
            } else {
                g.setColor(this.color);
                g.fillRect(0, 6, (int)((float)this.getWidth() * this.value), this.getHeight() - 6);
                g.fillRect(0, 3, (int)((float)this.getWidth() * this.oldval), 2);
            }
        }

        public void update() {
            this.oldval = this.dlug.getRoot().getScenario().getAttribute(this.metric + "OldScore", 0.0f);
            this.value = this.dlug.getRoot().getScore(this.metric);
            this.repaint();
        }
    }
}

