/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.GameRoot;
import dd.sim.SimObject;
import dd.ui.GameSupport;
import dd.util.InstructorSupport;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class InstructorInterface
extends JPanel {
    private static final String[] columnLabels = new String[]{"Game Name", "Humans", "Robots"};
    private static final int PLAYERS_PER_GAME = 4;
    private static final String[] numPlayers = new String[]{"1", "2", "3", "4"};
    private ArrayList gameList;
    private JTextField venueName;
    private JComboBox playersPerGame;
    private GameModel gameModel;
    private JTable games;
    private File logFile;
    private File logDir;
    private JButton saveButton;
    private JButton debugButton;
    private JLabel saveDirLoc;
    private JLabel logFileLoc;
    private int teamCount;
    private InstructorSupport target;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    private void addRow(Box box, String label, JComponent c) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(new JLabel(label));
        hBox.add(c);
        box.add(hBox);
    }

    public InstructorInterface() {
        Box vBox = Box.createVerticalBox();
        this.venueName = new JTextField();
        this.addRow(vBox, "Venue Name: ", this.venueName);
        this.playersPerGame = new JComboBox<String>(numPlayers);
        this.addRow(vBox, "Human players per game: ", this.playersPerGame);
        this.gameList = new ArrayList();
        this.teamCount = 1;
        this.gameModel = new GameModel();
        this.games = new JTable(this.gameModel);
        JScrollPane p = new JScrollPane(this.games);
        p.setPreferredSize(new Dimension(400, 200));
        vBox.add(p);
        JButton createButton = new JButton("Create Game");
        createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Game g = new Game();
                g.gameName = "Team " + InstructorInterface.this.teamCount;
                InstructorInterface.this.teamCount++;
                g.humanPlayers = Integer.parseInt(InstructorInterface.this.playersPerGame.getSelectedItem().toString());
                g.robotPlayers = 4 - g.humanPlayers;
                InstructorInterface.this.gameList.add(g);
                InstructorInterface.this.gameModel.fireTableDataChanged();
                GameSupport.sizeCols(InstructorInterface.this.games);
            }
        });
        JButton removeButton = new JButton("Remove Game");
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = InstructorInterface.this.games.getSelectedRow();
                if (row >= 0) {
                    InstructorInterface.this.gameList.remove(row);
                    InstructorInterface.this.gameModel.fireTableDataChanged();
                }
            }
        });
        JButton loadButton = new JButton("Load Game...");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String gameFile;
                GameRoot r;
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showOpenDialog(InstructorInterface.this);
                if (returnVal == 0 && (r = (GameRoot)SimObject.readFromXML(gameFile = chooser.getSelectedFile().getPath())) != null) {
                    Game g = new Game();
                    g.gameName = r.getGameName();
                    g.humanPlayers = r.getHumanPlayers();
                    g.robotPlayers = 4 - g.humanPlayers;
                    g.gameFile = gameFile;
                    InstructorInterface.this.gameList.add(g);
                    InstructorInterface.this.gameModel.fireTableDataChanged();
                }
            }
        });
        Box hBox = Box.createHorizontalBox();
        hBox.add(createButton);
        hBox.add(removeButton);
        hBox.add(loadButton);
        this.addRow(vBox, "", hBox);
        this.saveButton = new JButton("Choose");
        this.saveDirLoc = new JLabel("");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(InstructorInterface.this);
                if (returnVal == 0) {
                    InstructorInterface.this.logDir = chooser.getSelectedFile();
                    InstructorInterface.this.saveDirLoc.setText(InstructorInterface.this.logDir.getPath());
                    SwingUtilities.windowForComponent(InstructorInterface.this).pack();
                }
            }
        });
        JButton clearButton1 = new JButton("Clear");
        clearButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        InstructorInterface.access$700(5.access$800(this.this$1)).setText("");
                        InstructorInterface.access$602(5.access$800(this.this$1), null);
                        SwingUtilities.windowForComponent(5.access$800(this.this$1)).pack();
                    }
                });
            }

            static /* synthetic */ InstructorInterface access$800(5 x0) {
                return x0.InstructorInterface.this;
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Save games to:"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.saveButton);
        hBox.add(clearButton1);
        vBox.add(hBox);
        vBox.add(this.saveDirLoc);
        this.debugButton = new JButton("Save");
        this.logFileLoc = new JLabel("");
        this.debugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(InstructorInterface.this);
                if (returnVal == 0) {
                    InstructorInterface.this.logFile = chooser.getSelectedFile();
                    InstructorInterface.this.logFileLoc.setText(InstructorInterface.this.logFile.getPath());
                    SwingUtilities.windowForComponent(InstructorInterface.this).pack();
                }
            }
        });
        JButton clearButton2 = new JButton("Clear");
        clearButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        InstructorInterface.access$1000(8.access$1100(this.this$1)).setText("");
                        InstructorInterface.access$902(8.access$1100(this.this$1), null);
                        SwingUtilities.windowForComponent(8.access$1100(this.this$1)).pack();
                    }
                });
            }

            static /* synthetic */ InstructorInterface access$1100(8 x0) {
                return x0.InstructorInterface.this;
            }
        });
        hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Save debug log to:"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(this.debugButton);
        hBox.add(clearButton2);
        vBox.add(hBox);
        vBox.add(this.logFileLoc);
        JButton startServer = new JButton("Start Server");
        startServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (InstructorInterface.this.validateInput() && InstructorInterface.this.target != null) {
                    InstructorInterface.this.target.startServer();
                }
            }
        });
        this.addRow(vBox, "", startServer);
        this.add(vBox);
    }

    public void setTarget(InstructorSupport support) {
        this.target = support;
    }

    public boolean validateInput() {
        if (!this.getVenueName().matches("[A-Za-z0-9 ]{1,15}")) {
            JOptionPane.showMessageDialog(this, "Venue name must be less than 15 characters and may contain only letters, numbers, and spaces.");
            return false;
        }
        if (this.getNumGames() == 0) {
            JOptionPane.showMessageDialog(this, "You must create at least one game.");
            return false;
        }
        for (int i = 0; i < this.getNumGames(); ++i) {
            if (this.getHumans(i) >= 0 && this.getRobots(i) >= 0 && this.getHumans(i) + this.getRobots(i) == 4) continue;
            JOptionPane.showMessageDialog(this, "The number of human and robot players must add up to 4.");
            return false;
        }
        return true;
    }

    public void showRunningServerFrame() {
        JFrame f = new JFrame("DD Server");
        f.setDefaultCloseOperation(3);
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel("DD Game Server running"));
        JButton kill = new JButton("Stop Server");
        kill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        vBox.add(kill);
        f.getContentPane().add(vBox);
        f.pack();
        f.setVisible(true);
    }

    public String getVenueName() {
        return this.venueName.getText();
    }

    public int getNumGames() {
        return this.gameList.size();
    }

    public String getGameName(int num) {
        return ((Game)this.gameList.get((int)num)).gameName;
    }

    public int getHumans(int num) {
        return ((Game)this.gameList.get((int)num)).humanPlayers;
    }

    public int getRobots(int num) {
        return ((Game)this.gameList.get((int)num)).robotPlayers;
    }

    public String getGameFile(int num) {
        return ((Game)this.gameList.get((int)num)).gameFile;
    }

    public File getDebugFile() {
        return this.logFile;
    }

    public File getSaveDirectory() {
        return this.logDir;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Instructor Interface");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new InstructorInterface());
        f.pack();
        f.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GameModel
    extends AbstractTableModel {
        GameModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return InstructorInterface.this.gameList.size();
        }

        public String getColumnName(int columnIndex) {
            return columnLabels[columnIndex];
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return ((Game)((InstructorInterface)InstructorInterface.this).gameList.get((int)row)).gameName;
                }
                case 1: {
                    return new Integer(((Game)((InstructorInterface)InstructorInterface.this).gameList.get((int)row)).humanPlayers);
                }
                case 2: {
                    return new Integer(((Game)((InstructorInterface)InstructorInterface.this).gameList.get((int)row)).robotPlayers);
                }
            }
            return "N/A";
        }

        public void setValueAt(Object value, int row, int column) {
            Game g = (Game)InstructorInterface.this.gameList.get(row);
            switch (column) {
                case 0: {
                    g.gameName = (String)value;
                    break;
                }
                case 1: {
                    g.humanPlayers = (Integer)value;
                    g.humanPlayers = Math.min(4, g.humanPlayers);
                    g.humanPlayers = Math.max(0, g.humanPlayers);
                    g.robotPlayers = 4 - g.humanPlayers;
                    this.fireTableDataChanged();
                    break;
                }
                case 2: {
                    g.robotPlayers = (Integer)value;
                    g.robotPlayers = Math.min(4, g.robotPlayers);
                    g.robotPlayers = Math.max(0, g.robotPlayers);
                    g.humanPlayers = 4 - g.robotPlayers;
                    this.fireTableDataChanged();
                }
            }
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$java$lang$String == null ? (class$java$lang$String = InstructorInterface.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InstructorInterface.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 2: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InstructorInterface.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }
    }

    class Game {
        public String gameName;
        public int humanPlayers;
        public int robotPlayers;
        public String gameFile;

        Game() {
        }
    }
}

