/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.HurricaneHex;
import dd.hurricane.Main;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.ui.GameSupport;
import dd.ui.HexView;
import dd.ui.JBoolean;
import dd.ui.MapSelectionListener;
import dd.ui.ProposalVisualizer;
import dd.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MapView
extends JPanel
implements Printable {
    private HexView[] mapCells;
    protected Map map;
    private int mapCellCount;
    private int currentMode;
    private static final int SINGLE_SELECTION_MODE = 111;
    private static final int MULTIPLE_SELECTION_MODE = 222;
    private static final int DEFAULT_SELECTION_MODE = -1;
    private HashSet cellSelection;
    private Image bgImage;
    private Image transitImage;
    private Image labelImage;
    private ArrayList visualizers;
    private ProposalVisualizer currentVisualizer;
    private MapSelectionListener selectionListener;
    private Timer timer;
    private Class cellClass;
    private ArrayList cellLabels;
    private Arrow arrow;
    private JComponent tableOfContents;
    private static JBoolean showTransit;
    private static JBoolean showLabels;
    private static JBoolean showHazard;
    private static JBoolean[] showUrban;
    private static JBoolean showOpen;
    private static JBoolean showFactory;
    private JComponent badgeArea;
    private MapBody mapBody;
    private String myRole;

    public void writeFile(String filename) {
        this.mapBody.writeFile(filename);
    }

    public void defaultClickHandler(HexView clickedCell, int clickCount) {
        if (clickedCell == null) {
            return;
        }
        if (this.currentMode == 111) {
            ((HexView)this.cellSelection.iterator().next()).unhilite();
            this.cellSelection.clear();
            this.cellSelection.add(clickedCell);
            clickedCell.hilite();
            this.repaint();
            if (this.selectionListener != null) {
                this.selectionListener.mapSelectionUpdated(this);
            }
        } else if (this.currentMode == 222) {
            this.cellSelection.add(clickedCell);
            clickedCell.hilite();
            this.repaint();
        }
        if (clickCount == 2 && this.selectionListener != null) {
            this.selectionListener.mapSelectionDone(this);
        }
    }

    public Collection getSelectedCells() {
        return this.cellSelection;
    }

    public void clearCells() {
        for (int i = 0; i < this.mapCells.length; ++i) {
            this.mapCells[i].clear();
        }
    }

    public HexView findCell(String location) {
        return this.findCell(this.map.cellAt(location));
    }

    public HexView findCell(MapCell cell) {
        for (int i = 0; i < this.mapCells.length; ++i) {
            if (this.mapCells[i].getCell() != cell) continue;
            return this.mapCells[i];
        }
        return null;
    }

    public void pulseCell(String cellName, boolean show) {
        if (show) {
            this.findCell(cellName).pulse();
        } else {
            this.findCell(cellName).unpulse();
        }
        this.startTicking();
    }

    public void drawOverlay(String name) {
        this.mapBody.paintOverlay(GameSupport.getImage(name).getImage());
    }

    public void drawLegend(String name) {
        this.mapBody.paintLegend(GameSupport.getImage(name).getImage());
    }

    public void setCurrentLayer(String name) {
        this.map.setAttribute("currentLayer", name);
        this.repaint();
    }

    public void drawLegend(Image image) {
        this.mapBody.paintLegend(image);
    }

    public void startTicking() {
        if (this.timer != null) {
            return;
        }
        ActionListener task = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapView.this.repaint();
            }
        };
        this.timer = new Timer(200, task);
        this.timer.start();
    }

    public void stopTicking() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = null;
    }

    public int print(Graphics g, PageFormat format, int pageNum) {
        Graphics2D g2 = (Graphics2D)g;
        if (pageNum != 0) {
            return 1;
        }
        g2.translate(format.getImageableX(), format.getImageableY());
        return 0;
    }

    public HexView[] getMapCells() {
        return this.mapCells;
    }

    public String getRole() {
        return this.myRole;
    }

    public void setRole(String role) {
        this.myRole = role;
    }

    public void drawDisabledMessage(Graphics g) {
        g.setFont(new Font("Helvetica", 1, 24));
        FontMetrics fm = g.getFontMetrics();
        String line1 = "Waiting for";
        String line2 = "other players";
        int line1w = fm.stringWidth(line1);
        int line2w = fm.stringWidth(line2);
        int iPad = 28;
        int lineHeight = fm.getHeight() + 2;
        int h = 2 * iPad + lineHeight * 2;
        int lineWidth = Math.max(line1w, line2w);
        int w = 2 * iPad + lineWidth;
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2;
        g.setColor(Color.yellow);
        g.fillRect(x, y, w, h);
        g.setColor(Color.black);
        x = (this.getWidth() - line1w) / 2;
        y = y + iPad + lineHeight - 2;
        g.drawString(line1, x, y);
        x = (this.getWidth() - line2w) / 2;
        g.drawString(line2, x, y += lineHeight);
    }

    public void drawModeMessage(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 9));
        if (this.currentMode == 111) {
            g.setColor(Color.yellow);
            g.fillRect(0, this.getSize().height - 14, this.getSize().width, 14);
            g.setColor(Color.black);
            g.drawRect(0, this.getSize().height - 14, this.getSize().width, 14);
            g.drawString("Double-click on a cell to select it", 4, this.getSize().height - 4);
        }
    }

    public void drawArrow(String location) {
        if (location == null) {
            this.arrow = null;
            this.repaint();
            return;
        }
        Point endLoc = this.getCellCoordinates(location);
        this.arrow = new Arrow();
        this.arrow.drawArrow(endLoc.x - 50, endLoc.y - 50, endLoc.x, endLoc.y);
    }

    public Point getCellCoordinates(String location) {
        HexView cell = this.findCell(location);
        Point hexLoc = cell.center();
        return hexLoc;
    }

    public void setBackgroundImage(Image i) {
        this.bgImage = i;
    }

    public void labelCell(String location, String message, boolean show) {
        HexView cell = this.findCell(location);
        if (show) {
            this.cellLabels.add(new CellLabel(cell, message));
        } else {
            this.cellLabels.remove(new CellLabel(cell, message));
        }
    }

    public void setCellIcon(String location, ImageIcon icon) {
        this.findCell(location).addIcon(icon);
    }

    public void removeCellIcon(String location, ImageIcon icon) {
        this.findCell(location).removeIcon(icon);
    }

    public void clearCellLabels() {
        this.cellLabels.clear();
    }

    public void add(ProposalVisualizer vis) {
        this.visualizers.add(vis);
    }

    public void clearVisualizers() {
        this.visualizers.clear();
        this.currentVisualizer = null;
    }

    public void setCurrentVisualizer(ProposalVisualizer vis) {
        this.currentVisualizer = vis;
        if (this.currentVisualizer != null) {
            this.currentVisualizer.setVisible(true);
        }
        this.repaint();
    }

    public void makeTableOfContents() {
        ItemListener update = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MapView.this.tocUpdated();
            }
        };
        if (this.tableOfContents == null) {
            this.tableOfContents = Box.createVerticalBox();
        } else {
            this.tableOfContents.removeAll();
        }
        this.tableOfContents.add(new JLabel("Overlays"));
        if (showTransit == null) {
            showTransit = new JBoolean();
            showTransit.setState(true);
        }
        JCheckBox c = new JCheckBox("Transit");
        c.setModel(showTransit);
        c.addItemListener(update);
        this.tableOfContents.add(c);
        if (showLabels == null) {
            showLabels = new JBoolean();
            showLabels.setState(true);
        }
        c = new JCheckBox("Labels");
        c.setModel(showLabels);
        c.addItemListener(update);
        this.tableOfContents.add(c);
        if (showHazard == null) {
            showHazard = new JBoolean();
            showHazard.setState(false);
        }
        c = new JCheckBox("Hazard");
        c.setModel(showHazard);
        c.addItemListener(update);
        this.tableOfContents.add(c);
        this.tableOfContents.add(new JLabel("Land Use"));
        for (int i = 0; i < 4; ++i) {
            if (showUrban[i] == null) {
                MapView.showUrban[i] = new JBoolean();
                showUrban[i].setState(true);
            }
            String name = StringUtils.capitalize(Main.luNames[i]);
            c = new JCheckBox(name);
            c.setModel(showUrban[i]);
            c.addItemListener(update);
            this.tableOfContents.add(c);
        }
        if (showFactory == null) {
            showFactory = new JBoolean();
            showFactory.setState(true);
        }
        c = new JCheckBox("Factory");
        c.setModel(showFactory);
        c.addItemListener(update);
        this.tableOfContents.add(c);
        if (showOpen == null) {
            showOpen = new JBoolean();
            showOpen.setState(true);
        }
        c = new JCheckBox("Open");
        c.setModel(showOpen);
        c.addItemListener(update);
        this.tableOfContents.add(c);
        if (!this.visualizers.isEmpty()) {
            this.tableOfContents.add(new JLabel("Proposals"));
            Iterator iter = this.visualizers.iterator();
            while (iter.hasNext()) {
                ProposalVisualizer vis = (ProposalVisualizer)iter.next();
                c = new JCheckBox(vis.getName());
                c.setSelected(vis.getVisible());
                c.addItemListener(new VisListener(vis));
                this.tableOfContents.add(c);
            }
        }
        this.tocUpdated();
    }

    public void tocUpdated() {
        HurricaneHex.fillHexes = showHazard.getState();
        for (int i = 0; i < 4; ++i) {
            if (showUrban == null) continue;
            HurricaneHex.showLU[i] = showUrban[i].getState();
        }
        if (showFactory != null) {
            HurricaneHex.showFactory = showFactory.getState();
        }
        if (showOpen != null) {
            HurricaneHex.showOpen = showOpen.getState();
        }
        this.repaint();
    }

    public MapView(Map map, Class cellClass) {
        super(new BorderLayout());
        showUrban = new JBoolean[4];
        this.map = map;
        this.visualizers = new ArrayList();
        this.makeTableOfContents();
        this.add((Component)this.tableOfContents, "West");
        this.mapBody = new MapBody(this);
        this.add((Component)this.mapBody, "Center");
        this.currentMode = -1;
        this.cellSelection = new HashSet();
        this.cellLabels = new ArrayList();
        MouseTracker mt = new MouseTracker();
        this.cellClass = cellClass;
        this.addMouseMotionListener(mt);
        this.addMouseListener(mt);
        try {
            this.makeMap(map, map.getMapWidth(), map.getMapHeight(), cellClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMap(Map map) {
        this.map = map;
        try {
            this.makeMap(map, map.getMapWidth(), map.getMapHeight(), this.cellClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    public void beginSingleSelection(MapSelectionListener listener, HexView startingSelection) {
        this.currentMode = 111;
        this.cellSelection.clear();
        if (startingSelection != null) {
            startingSelection.hilite();
            this.cellSelection.add(startingSelection);
        } else {
            this.cellSelection.add(new HexView());
        }
        this.selectionListener = listener;
        this.repaint();
    }

    public void endSingleSelection() {
        this.currentMode = -1;
        this.cellSelection = new HashSet();
        this.repaint();
    }

    public void resetMap() {
        this.clearCellLabels();
        this.drawArrow(null);
        this.clearCells();
        this.endSingleSelection();
    }

    public void makeMap(Map map, int width, int height, Class cellClass) throws Exception {
        this.cellLabels.clear();
        HexView curPiece = (HexView)cellClass.newInstance();
        int cellWidth = curPiece.defaultCellWidth();
        int cellHeight = curPiece.defaultCellHeight();
        this.mapCells = new HexView[width * height];
        this.mapCellCount = width * height;
        int curCell = 0;
        this.mapBody.setMinimumSize(new Dimension(cellWidth * width, cellHeight * height));
        this.mapBody.setPreferredSize(new Dimension(cellWidth * width + 10, cellHeight * height + 20));
        int curY = 0;
        int curX = 0;
        for (int j = 0; j < width; ++j) {
            for (int i = 0; i < height; ++i) {
                curPiece = (HexView)cellClass.newInstance();
                curPiece.setCell(map.cellAt(i, j));
                curPiece.setParent(this);
                curPiece.setLocation(curX, curY);
                this.mapCells[curCell] = curPiece;
                ++curCell;
                curY += cellHeight;
            }
            if ((j & 1) == 0) {
                curX += cellWidth;
                curY = cellHeight / 2;
                continue;
            }
            curX += cellWidth;
            curY = 0;
        }
        String file = (String)map.getObjectAttribute("bgImage");
        if (file != null) {
            this.bgImage = GameSupport.getImage(file).getImage();
        }
        if ((file = (String)map.getObjectAttribute("transitImage")) != null) {
            this.transitImage = GameSupport.getImage(file).getImage();
        }
        if ((file = (String)map.getObjectAttribute("labelImage")) != null) {
            this.labelImage = GameSupport.getImage(file).getImage();
        }
    }

    public HexView hexForScreenLocation(int x, int y) {
        for (int i = 0; i < this.mapCellCount; ++i) {
            if (!this.mapCells[i].contains(x, y)) continue;
            return this.mapCells[i];
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] myElts = this.getComponents();
        for (int i = 0; i < myElts.length; ++i) {
            myElts[i].setEnabled(enabled);
        }
    }

    public GeneralPath makeBezier(Point[] points) {
        GeneralPath path = new GeneralPath();
        path.moveTo(points[0].x, points[0].y);
        for (int i = 1; i < points.length; ++i) {
            float cpLeftY;
            float cpLeftX;
            float cpRightY;
            float cpRightX;
            float endX = points[i].x;
            float endY = points[i].y;
            if (i == 1) {
                cpRightX = (float)points[i - 1].x - (float)(points[0].x - points[i].x) / 4.0f;
                cpRightY = (float)points[i - 1].y - (float)(points[0].y - points[i].y) / 4.0f;
            } else {
                cpRightX = (float)points[i - 1].x - (float)(points[i - 2].x - points[i].x) / 4.0f;
                cpRightY = (float)points[i - 1].y - (float)(points[i - 2].y - points[i].y) / 4.0f;
            }
            if (i == points.length - 1) {
                cpLeftX = (float)points[i].x + (float)(points[i - 1].x - points[i].x) / 4.0f;
                cpLeftY = (float)points[i].y + (float)(points[i - 1].y - points[i].y) / 4.0f;
            } else {
                cpLeftX = (float)points[i].x + (float)(points[i - 1].x - points[i + 1].x) / 4.0f;
                cpLeftY = (float)points[i].y + (float)(points[i - 1].y - points[i + 1].y) / 4.0f;
            }
            path.curveTo(cpRightX, cpRightY, cpLeftX, cpLeftY, endX, endY);
        }
        return path;
    }

    public Point getLocationFor(int row, int column, int vertex) {
        return this.mapCells[row + this.map.getMapHeight() * column].getVertex(vertex);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Map Window");
        final Map m = args.length == 1 ? (Map)Map.readFromXML(args[0]) : new Map(20, 20);
        HexView hv = new HexView(){

            public void setCell(MapCell c) {
                super.setCell(c);
                String color = (String)this.myCell.getObjectAttribute("color", this.myCell.getMap().createLayer("color"));
                if (color != null) {
                    int r = Integer.parseInt(color.substring(1, 3), 16);
                    int g = Integer.parseInt(color.substring(3, 5), 16);
                    int b = Integer.parseInt(color.substring(5, 7), 16);
                    this.setMyColor(new Color(r, g, b));
                }
            }
        };
        final MapView me = new MapView(m, hv.getClass());
        f.setSize(240, 280);
        f.setDefaultCloseOperation(3);
        JSlider s = new JSlider(0, 10, 2);
        s.setSnapToTicks(true);
        s.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = ((JSlider)e.getSource()).getValue();
                Iterator i = m.getCells().iterator();
                MapCell t = m.cellAt(3, 3);
                while (i.hasNext()) {
                    MapCell c = (MapCell)i.next();
                    if (c.cDistanceTo(t) <= (double)val) {
                        c.setAttribute("dist", "yes");
                        continue;
                    }
                    c.setAttribute("dist", "no");
                }
            }
        });
        JButton b = new JButton("Print");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrinterJob job = PrinterJob.getPrinterJob();
                PageFormat format = job.pageDialog(job.defaultPage());
                job.setPrintable(me, format);
                try {
                    job.print();
                }
                catch (PrinterException ex) {
                    // empty catch block
                }
            }
        });
        s.setMajorTickSpacing(1);
        s.setPaintTicks(true);
        s.setPaintLabels(true);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)s, "South");
        f.getContentPane().add(me);
        f.pack();
        f.setVisible(true);
    }

    class VisListener
    implements ItemListener {
        private ProposalVisualizer visualizer;

        public VisListener(ProposalVisualizer vis) {
            this.visualizer = vis;
        }

        public void itemStateChanged(ItemEvent e) {
            this.visualizer.setVisible(e.getStateChange() == 1);
            MapView.this.tocUpdated();
        }
    }

    class MapBody
    extends JComponent {
        private Graphics currentGraphics;
        private MapView myMapView;
        private int legendX;
        private int legendY;
        private boolean showLegend;

        public MapBody(MapView v) {
            this.myMapView = v;
            this.showLegend = true;
        }

        public void writeFile(String filename) {
            try {
                Image image = this.createImage(this.getWidth(), this.getHeight());
                Graphics g = image.getGraphics();
                this.paint(g);
                ImageIO.write((RenderedImage)((Object)image), "png", new File(filename));
            }
            catch (IOException e) {
                MapView.this.map.error("Unable to write map view to file " + filename);
                e.printStackTrace();
            }
        }

        public boolean isOpaque() {
            return true;
        }

        public void paintOverlay(Image i) {
            this.currentGraphics.drawImage(i, 0, 0, this);
        }

        public void paintLegend(Image i) {
            if (this.showLegend) {
                this.currentGraphics.drawImage(i, this.legendX, this.legendY - i.getHeight(this), this);
                this.legendX += i.getWidth(this) + 2;
            }
        }

        public void paint(Graphics g) {
            this.currentGraphics = g;
            this.legendX = 2;
            this.legendY = this.getSize().height - 2;
            if (!this.isEnabled()) {
                g.setColor(new Color(255, 255, 255, 200));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                MapView.this.drawDisabledMessage(g);
            } else {
                g.setColor(Color.gray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (MapView.this.bgImage != null) {
                    g.drawImage(MapView.this.bgImage, 0, 0, this);
                }
                for (int i = 0; i < MapView.this.mapCellCount; ++i) {
                    MapView.this.mapCells[i].paint(g);
                }
                if (MapView.this.transitImage != null && showTransit.getState()) {
                    g.drawImage(MapView.this.transitImage, 0, 0, this);
                }
                if (MapView.this.labelImage != null && showLabels.getState()) {
                    g.drawImage(MapView.this.labelImage, 0, 0, this);
                }
                Iterator iter = MapView.this.visualizers.iterator();
                while (iter.hasNext()) {
                    ((ProposalVisualizer)iter.next()).show(this.myMapView);
                }
                iter = MapView.this.cellLabels.iterator();
                while (iter.hasNext()) {
                    ((CellLabel)iter.next()).paint(g);
                }
                if (MapView.this.currentVisualizer != null) {
                    MapView.this.currentVisualizer.show(this.myMapView);
                }
                MapView.this.drawModeMessage(g);
                if (MapView.this.arrow != null) {
                    MapView.this.arrow.paint(g);
                }
            }
        }
    }

    class MouseTracker
    extends MouseAdapter
    implements MouseMotionListener {
        HexView currentSelectedCell;

        MouseTracker() {
        }

        public void mouseClicked(MouseEvent e) {
            MapView.this.defaultClickHandler(this.currentSelectedCell, e.getClickCount());
        }

        public void mouseMoved(MouseEvent e) {
            this.currentSelectedCell = MapView.this.hexForScreenLocation(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
        }
    }

    class CellLabel
    extends Paintable {
        public HexView cell;
        public String message;

        public CellLabel(HexView c, String m) {
            this.cell = c;
            this.message = m;
        }

        public void paint(Graphics g) {
            int xDelta = 4;
            g.setFont(new Font("Helvetica", 0, 9));
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(this.message) + 2;
            Point p = this.cell.bottomCenter();
            if (w + 4 + p.x > MapView.this.getSize().width) {
                g.setColor(Color.white);
                g.fillRect(p.x - 4 - w, p.y, w, fm.getAscent());
                g.setColor(Color.black);
                g.drawLine(p.x, p.y, p.x - 4, p.y + fm.getAscent());
                g.drawLine(p.x - 4, p.y + fm.getAscent(), p.x - 4 - w, p.y + fm.getAscent());
                g.drawString(this.message, p.x - 4 - w, p.y + fm.getAscent() - 1);
            } else {
                g.setColor(Color.white);
                g.fillRect(p.x + 4, p.y, w, fm.getAscent());
                g.setColor(Color.black);
                g.drawLine(p.x, p.y, p.x + 4, p.y + fm.getAscent());
                g.drawLine(p.x + 4, p.y + fm.getAscent(), p.x + 4 + w, p.y + fm.getAscent());
                g.drawString(this.message, p.x + 4, p.y + fm.getAscent() - 1);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof CellLabel) {
                CellLabel c = (CellLabel)o;
                return c.cell == this.cell && c.message.equals(this.message);
            }
            return false;
        }
    }

    class Arrow
    extends Paintable {
        public int x1;
        public int x2;
        public int y1;
        public int y2;

        Arrow() {
        }

        private GeneralPath makeArrowShape() {
            GeneralPath arrowShape = new GeneralPath();
            arrowShape.moveTo(0.0f, 0.0f);
            arrowShape.lineTo(1.0f, 0.0f);
            arrowShape.lineTo(0.78f, 0.12f);
            arrowShape.moveTo(0.0f, 0.0f);
            arrowShape.lineTo(1.0f, 0.0f);
            arrowShape.lineTo(0.78f, -0.12f);
            arrowShape.transform(this.makeTransform());
            return arrowShape;
        }

        private AffineTransform makeTransform() {
            AffineTransform t = new AffineTransform();
            float len = (float)Math.sqrt((this.y2 - this.y1) * (this.y2 - this.y1) + (this.x2 - this.x1) * (this.x2 - this.x1));
            float theta = (float)Math.atan(((double)(this.y2 - this.y1) + 0.0) / ((double)(this.x2 - this.x1) + 0.0));
            if (this.x2 < this.x1) {
                theta = (float)((double)theta + Math.PI);
            }
            t.translate(this.x1, this.y1);
            t.rotate(theta);
            t.scale(len, len);
            return t;
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.black);
            g2.setStroke(new BasicStroke(4.0f, 1, 2));
            g2.draw(this.makeArrowShape());
        }

        public void drawArrow(int startX, int startY, int endX, int endY) {
            this.x1 = startX;
            this.x2 = endX;
            this.y1 = startY;
            this.y2 = endY;
            MapView.this.repaint();
        }
    }

    class Paintable {
        Paintable() {
        }

        public void paint(Graphics g) {
        }
    }
}

